/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.api.superscript;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import me.superckl.api.superscript.command.ScriptCommandListing;
import me.superckl.api.superscript.object.ScriptObject;

public class ScriptCommandRegistry {
    public static final ScriptCommandRegistry INSTANCE = new ScriptCommandRegistry();
    private final Map<Class<? extends ScriptObject>, Map<String, ScriptCommandListing>> commands = Maps.newHashMap();

    public Map<Class<? extends ScriptObject>, Map<String, ScriptCommandListing>> getCommandsMap() {
        return Maps.newHashMap(this.commands);
    }

    public void registerListing(String command, ScriptCommandListing listing, Class<? extends ScriptObject> clazz) {
        if (!this.commands.containsKey(clazz)) {
            this.commands.put(clazz, new LinkedHashMap());
        }
        this.commands.get(clazz).put(command, listing);
    }

    public void registerClassListing(Class<? extends ScriptObject> clazz, Map<String, ScriptCommandListing> listing) {
        this.commands.put(clazz, listing);
    }

    public Map<String, ScriptCommandListing> getListings(Class<? extends ScriptObject> clazz) {
        LinkedHashMap listings = this.commands.get(clazz);
        if (listings == null) {
            listings = Maps.newLinkedHashMap();
            this.commands.put(clazz, listings);
        }
        return Maps.newLinkedHashMap((Map)listings);
    }

    public ScriptCommandListing getListing(Class<? extends ScriptObject> clazz, String command) {
        ScriptCommandListing listing = this.getListings(clazz).get(command);
        if (listing == null) {
            listing = new ScriptCommandListing();
            this.commands.get(clazz).put(command, listing);
        }
        return listing;
    }
}

