/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.api.biometweaker.script.pack;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.superckl.api.biometweaker.script.pack.IBiomePackage;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class TypeBiomesPackage
implements IBiomePackage {
    private final String[] sTypes;
    private BiomeDictionary.Type[] types;

    public TypeBiomesPackage(String ... types) {
        this.sTypes = types;
    }

    @Override
    public Iterator<Biome> getIterator() {
        this.checkTypes();
        ArrayList list = Lists.newArrayList();
        for (BiomeDictionary.Type type : this.types) {
            Biome[] gens;
            for (Biome gen : gens = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)type)) {
                if (list.contains(gen)) continue;
                list.add(gen);
            }
        }
        return list.iterator();
    }

    @Override
    public List<Integer> getRawIds() {
        this.checkTypes();
        ArrayList ints = Lists.newArrayList();
        for (BiomeDictionary.Type type : this.types) {
            Biome[] gens;
            for (Biome gen : gens = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)type)) {
                ints.add(Biome.func_185362_a((Biome)gen));
            }
        }
        return ints;
    }

    @Override
    public boolean supportsEarlyRawIds() {
        return false;
    }

    private void checkTypes() {
        if (this.types == null) {
            BiomeDictionary.Type[] bTypes = new BiomeDictionary.Type[this.sTypes.length];
            for (int i = 0; i < this.sTypes.length; ++i) {
                bTypes[i] = BiomeDictionary.Type.getType((String)this.sTypes[i], (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
            }
            this.types = bTypes;
        }
    }
}

