/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.registry;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.blay09.mods.cookingforblockheads.KitchenMultiBlock;
import net.blay09.mods.cookingforblockheads.api.ISortButton;
import net.blay09.mods.cookingforblockheads.api.RecipeStatus;
import net.blay09.mods.cookingforblockheads.api.SinkHandler;
import net.blay09.mods.cookingforblockheads.api.ToastHandler;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.event.FoodRegistryInitEvent;
import net.blay09.mods.cookingforblockheads.balyware.ItemUtils;
import net.blay09.mods.cookingforblockheads.compat.HarvestCraftAddon;
import net.blay09.mods.cookingforblockheads.container.inventory.InventoryCraftBook;
import net.blay09.mods.cookingforblockheads.registry.recipe.FoodIngredient;
import net.blay09.mods.cookingforblockheads.registry.recipe.FoodRecipe;
import net.blay09.mods.cookingforblockheads.registry.recipe.ShapedCraftingFood;
import net.blay09.mods.cookingforblockheads.registry.recipe.ShapedOreCraftingFood;
import net.blay09.mods.cookingforblockheads.registry.recipe.ShapelessCraftingFood;
import net.blay09.mods.cookingforblockheads.registry.recipe.ShapelessOreCraftingFood;
import net.blay09.mods.cookingforblockheads.registry.recipe.SmeltingFood;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class CookingRegistry {
    private static final List<IRecipe> recipeList = Lists.newArrayList();
    private static final ArrayListMultimap<ResourceLocation, FoodRecipe> foodItems = ArrayListMultimap.create();
    private static final List<ItemStack> tools = Lists.newArrayList();
    private static final Map<ItemStack, Integer> ovenFuelItems = Maps.newHashMap();
    private static final Map<ItemStack, ItemStack> ovenRecipes = Maps.newHashMap();
    private static final Map<ItemStack, SinkHandler> sinkHandlers = Maps.newHashMap();
    private static final Map<ItemStack, ToastHandler> toastHandlers = Maps.newHashMap();
    private static final List<ItemStack> waterItems = Lists.newArrayList();
    private static final List<ItemStack> milkItems = Lists.newArrayList();
    private static final List<ISortButton> customSortButtons = Lists.newArrayList();
    private static Collection<ItemStack> nonFoodRecipes;

    public static void initFoodRegistry() {
        recipeList.clear();
        foodItems.clear();
        FoodRegistryInitEvent init = new FoodRegistryInitEvent();
        MinecraftForge.EVENT_BUS.post((Event)init);
        nonFoodRecipes = init.getNonFoodRecipes();
        block0: for (Object e : CraftingManager.func_77594_a().func_77592_b()) {
            IRecipe recipe = (IRecipe)e;
            ItemStack output = recipe.func_77571_b();
            if (output == null) continue;
            if (output.func_77973_b() instanceof ItemFood) {
                if (HarvestCraftAddon.isWeirdBrokenRecipe(recipe)) continue;
                CookingRegistry.addFoodRecipe(recipe);
                continue;
            }
            for (ItemStack itemStack : nonFoodRecipes) {
                if (!ItemUtils.areItemStacksEqualWithWildcard(recipe.func_77571_b(), itemStack)) continue;
                CookingRegistry.addFoodRecipe(recipe);
                continue block0;
            }
        }
        for (Object object : FurnaceRecipes.func_77602_a().func_77599_b().entrySet()) {
            ItemStack resultStack;
            Map.Entry entry = (Map.Entry)object;
            ItemStack sourceStack = null;
            if (entry.getKey() instanceof Item) {
                sourceStack = new ItemStack((Item)entry.getKey());
            } else if (entry.getKey() instanceof Block) {
                sourceStack = new ItemStack((Block)entry.getKey());
            } else if (entry.getKey() instanceof ItemStack) {
                sourceStack = (ItemStack)entry.getKey();
            }
            if ((resultStack = (ItemStack)entry.getValue()) == null) continue;
            if (resultStack.func_77973_b() instanceof ItemFood) {
                foodItems.put((Object)resultStack.func_77973_b().getRegistryName(), (Object)new SmeltingFood(resultStack, sourceStack));
                continue;
            }
            if (!CookingRegistry.isNonFoodRecipe(resultStack)) continue;
            foodItems.put((Object)resultStack.func_77973_b().getRegistryName(), (Object)new SmeltingFood(resultStack, sourceStack));
        }
    }

    public static boolean isNonFoodRecipe(ItemStack itemStack) {
        for (ItemStack nonFoodStack : nonFoodRecipes) {
            if (!ItemUtils.areItemStacksEqualWithWildcard(itemStack, nonFoodStack)) continue;
            return true;
        }
        return false;
    }

    public static void addFoodRecipe(IRecipe recipe) {
        ItemStack output = recipe.func_77571_b();
        if (output != null) {
            recipeList.add(recipe);
            if (recipe instanceof ShapedRecipes) {
                foodItems.put((Object)output.func_77973_b().getRegistryName(), (Object)new ShapedCraftingFood((ShapedRecipes)recipe));
            } else if (recipe instanceof ShapelessRecipes) {
                foodItems.put((Object)output.func_77973_b().getRegistryName(), (Object)new ShapelessCraftingFood((ShapelessRecipes)recipe));
            } else if (recipe instanceof ShapelessOreRecipe) {
                foodItems.put((Object)output.func_77973_b().getRegistryName(), (Object)new ShapelessOreCraftingFood((ShapelessOreRecipe)recipe));
            } else if (recipe instanceof ShapedOreRecipe) {
                foodItems.put((Object)output.func_77973_b().getRegistryName(), (Object)new ShapedOreCraftingFood((ShapedOreRecipe)recipe));
            }
        }
    }

    public static Multimap<ResourceLocation, FoodRecipe> getFoodRecipes() {
        return foodItems;
    }

    public static Collection<FoodRecipe> getFoodRecipes(ItemStack outputItem) {
        return foodItems.get((Object)outputItem.func_77973_b().getRegistryName());
    }

    public static void addToolItem(ItemStack toolItem) {
        tools.add(toolItem);
    }

    public static boolean isToolItem(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        for (ItemStack toolItem : tools) {
            if (!ItemUtils.areItemStacksEqualWithWildcard(toolItem, itemStack)) continue;
            return true;
        }
        return false;
    }

    public static void addOvenFuel(ItemStack itemStack, int fuelTime) {
        ovenFuelItems.put(itemStack, fuelTime);
    }

    public static int getOvenFuelTime(ItemStack itemStack) {
        for (Map.Entry<ItemStack, Integer> entry : ovenFuelItems.entrySet()) {
            if (!ItemUtils.areItemStacksEqualWithWildcard(entry.getKey(), itemStack)) continue;
            return entry.getValue();
        }
        return 0;
    }

    public static void addSmeltingItem(ItemStack source, ItemStack result) {
        ovenRecipes.put(source, result);
    }

    public static ItemStack getSmeltingResult(ItemStack itemStack) {
        for (Map.Entry<ItemStack, ItemStack> entry : ovenRecipes.entrySet()) {
            if (!ItemUtils.areItemStacksEqualWithWildcard(entry.getKey(), itemStack)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static void addToastHandler(ItemStack itemStack, ToastHandler toastHandler) {
        toastHandlers.put(itemStack, toastHandler);
    }

    public static ToastHandler getToastHandler(ItemStack itemStack) {
        for (Map.Entry<ItemStack, ToastHandler> entry : toastHandlers.entrySet()) {
            if (!ItemUtils.areItemStacksEqualWithWildcard(entry.getKey(), itemStack)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static void addSinkHandler(ItemStack itemStack, SinkHandler sinkHandler) {
        sinkHandlers.put(itemStack, sinkHandler);
    }

    public static ItemStack getSinkOutput(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        for (Map.Entry<ItemStack, SinkHandler> entry : sinkHandlers.entrySet()) {
            if (!ItemUtils.areItemStacksEqualWithWildcard(entry.getKey(), itemStack)) continue;
            return entry.getValue().getSinkOutput(itemStack);
        }
        return null;
    }

    public static ItemStack findAnyItemStack(ItemStack checkStack, List<IKitchenItemProvider> inventories, boolean requireBucket) {
        if (checkStack == null) {
            return null;
        }
        for (int i = 0; i < inventories.size(); ++i) {
            IKitchenItemProvider itemProvider = inventories.get(i);
            for (int j = 0; j < itemProvider.getSlots(); ++j) {
                ItemStack itemStack = itemProvider.getStackInSlot(j);
                if (!ItemUtils.areItemStacksEqualWithWildcard(itemStack, checkStack) || itemProvider.useItemStack(j, 1, true, inventories, requireBucket) == null) continue;
                return itemStack;
            }
        }
        return null;
    }

    public static ItemStack findAnyItemStack(FoodIngredient ingredient, List<IKitchenItemProvider> inventories, boolean requireBucket) {
        if (ingredient == null) {
            return null;
        }
        for (int i = 0; i < inventories.size(); ++i) {
            IKitchenItemProvider itemProvider = inventories.get(i);
            for (int j = 0; j < itemProvider.getSlots(); ++j) {
                ItemStack itemStack = itemProvider.getStackInSlot(j);
                if (itemStack == null || !ingredient.isValidItem(itemStack) || itemProvider.useItemStack(j, 1, true, inventories, requireBucket) == null) continue;
                return itemStack;
            }
        }
        return null;
    }

    public static boolean consumeBucket(List<IKitchenItemProvider> inventories, boolean simulate) {
        ItemStack itemStack = new ItemStack(Items.field_151133_ar);
        for (int i = 0; i < inventories.size(); ++i) {
            IKitchenItemProvider itemProvider = inventories.get(i);
            for (int j = 0; j < itemProvider.getSlots(); ++j) {
                ItemStack providedStack = itemProvider.getStackInSlot(j);
                if (providedStack == null || !ItemUtils.areItemStacksEqualWithWildcard(itemStack, providedStack) || itemProvider.useItemStack(j, 1, simulate, inventories, false) == null) continue;
                return true;
            }
        }
        return false;
    }

    public static RecipeStatus getRecipeStatus(FoodRecipe recipe, List<IKitchenItemProvider> inventories) {
        boolean requireBucket = CookingRegistry.doesItemRequireBucketForCrafting(recipe.getOutputItem());
        for (IKitchenItemProvider itemProvider : inventories) {
            itemProvider.resetSimulation();
        }
        List<FoodIngredient> craftMatrix = recipe.getCraftMatrix();
        ItemStack[] itemFound = new ItemStack[craftMatrix.size()];
        boolean missingTools = false;
        for (int i = 0; i < craftMatrix.size(); ++i) {
            FoodIngredient ingredient = craftMatrix.get(i);
            itemFound[i] = CookingRegistry.findAnyItemStack(ingredient, inventories, requireBucket);
            if (itemFound[i] != null || ingredient == null) continue;
            if (ingredient.isToolItem()) {
                missingTools = true;
                continue;
            }
            return RecipeStatus.MISSING_INGREDIENTS;
        }
        return missingTools ? RecipeStatus.MISSING_TOOLS : RecipeStatus.AVAILABLE;
    }

    public static List<IKitchenItemProvider> getItemProviders(KitchenMultiBlock multiBlock, InventoryPlayer inventory) {
        return multiBlock != null ? multiBlock.getItemProviders(inventory) : Lists.newArrayList((Object[])new IKitchenItemProvider[]{new KitchenItemProvider((IItemHandler)new InvWrapper((IInventory)inventory))});
    }

    public static IRecipe findFoodRecipe(InventoryCraftBook craftMatrix, World world) {
        for (IRecipe recipe : recipeList) {
            if (!recipe.func_77569_a((InventoryCrafting)craftMatrix, world)) continue;
            return recipe;
        }
        return null;
    }

    public static void addWaterItem(ItemStack waterItem) {
        waterItems.add(waterItem);
    }

    public static void addMilkItem(ItemStack milkItem) {
        milkItems.add(milkItem);
    }

    public static void addSortButton(ISortButton button) {
        customSortButtons.add(button);
    }

    public static List<ItemStack> getWaterItems() {
        return waterItems;
    }

    public static List<ItemStack> getMilkItems() {
        return milkItems;
    }

    public static List<ISortButton> getSortButtons() {
        return customSortButtons;
    }

    public static boolean doesItemRequireBucketForCrafting(ItemStack outputItem) {
        ItemStack containerItem = ForgeHooks.getContainerItem((ItemStack)outputItem);
        if (containerItem != null && containerItem.func_77973_b() == Items.field_151133_ar) {
            return true;
        }
        ResourceLocation registryName = outputItem.func_77973_b().getRegistryName();
        return registryName != null && registryName.func_110623_a().contains("bucket");
    }
}

