/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.item;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.cyclops.colossalchests.block.ChestWall;
import org.cyclops.colossalchests.block.ColossalChest;
import org.cyclops.colossalchests.block.Interface;
import org.cyclops.colossalchests.block.PropertyMaterial;
import org.cyclops.colossalchests.tileentity.TileColossalChest;
import org.cyclops.cyclopscore.block.multi.CubeDetector;
import org.cyclops.cyclopscore.config.configurable.ConfigurableItem;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.inventory.PlayerInventoryIterator;

public class ItemUpgradeTool
extends ConfigurableItem {
    private static ItemUpgradeTool _instance = null;

    public static ItemUpgradeTool getInstance() {
        return _instance;
    }

    public ItemUpgradeTool(ExtendedConfig eConfig) {
        super(eConfig);
        this.func_77627_a(true);
    }

    public String func_77667_c(ItemStack itemStack) {
        return super.func_77667_c(itemStack) + (itemStack.func_77960_j() == 0 ? "" : ".reverse");
    }

    public EnumActionResult onItemUseFirst(ItemStack itemStack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        IBlockState blockState = world.func_180495_p(pos);
        if (((Boolean)BlockHelpers.getSafeBlockStateProperty((IBlockState)blockState, (IProperty)ColossalChest.ACTIVE, (Object)false)).booleanValue()) {
            BlockPos tileLocation = ColossalChest.getCoreLocation(world, pos);
            TileColossalChest tile = (TileColossalChest)((Object)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)tileLocation, TileColossalChest.class));
            PropertyMaterial.Type newType = this.transformType(itemStack, tile.getMaterial());
            if (newType == null) {
                if (world.field_72995_K) {
                    return EnumActionResult.PASS;
                }
                ColossalChest.addPlayerChatError(player, new L10NHelpers.UnlocalizedString("multiblock.colossalchests.error.upgradeLimit", new Object[0]));
                return EnumActionResult.FAIL;
            }
            L10NHelpers.UnlocalizedString firstError = null;
            do {
                L10NHelpers.UnlocalizedString error;
                if ((error = this.attemptTransform(world, pos, player, tile, newType, tile.getMaterial())) != null) {
                    if (firstError != null) continue;
                    firstError = error;
                    continue;
                }
                return world.field_72995_K ? EnumActionResult.PASS : EnumActionResult.SUCCESS;
            } while ((newType = this.transformType(itemStack, newType)) != null);
            ColossalChest.addPlayerChatError(player, firstError);
            return world.field_72995_K ? EnumActionResult.PASS : EnumActionResult.FAIL;
        }
        return world.field_72995_K ? EnumActionResult.PASS : EnumActionResult.SUCCESS;
    }

    protected L10NHelpers.UnlocalizedString attemptTransform(final World world, BlockPos pos, EntityPlayer player, final TileColossalChest tile, final PropertyMaterial.Type newType, PropertyMaterial.Type currentType) {
        int currentItemMeta = currentType.ordinal();
        int requiredItemMeta = newType.ordinal();
        Vec3i size = tile.getSize();
        final ItemStack requiredCores = new ItemStack((Block)ColossalChest.getInstance(), 0, requiredItemMeta);
        final ItemStack requiredInterfaces = new ItemStack((Block)Interface.getInstance(), 0, requiredItemMeta);
        final ItemStack requiredWalls = new ItemStack((Block)ChestWall.getInstance(), 0, requiredItemMeta);
        TileColossalChest.detector.detect(world, pos, null, new CubeDetector.IValidationAction(){

            public L10NHelpers.UnlocalizedString onValidate(BlockPos location, IBlockState blockState) {
                if (blockState.func_177230_c() == ColossalChest.getInstance()) {
                    ++requiredCores.field_77994_a;
                } else if (blockState.func_177230_c() == Interface.getInstance()) {
                    ++requiredInterfaces.field_77994_a;
                } else if (blockState.func_177230_c() == ChestWall.getInstance()) {
                    ++requiredWalls.field_77994_a;
                }
                return null;
            }
        }, false);
        if (!(this.consumeItems(player, requiredCores, true) && this.consumeItems(player, requiredInterfaces, true) && this.consumeItems(player, requiredWalls, true))) {
            return new L10NHelpers.UnlocalizedString("multiblock.colossalchests.error.upgrade", new Object[]{requiredCores.field_77994_a, requiredInterfaces.field_77994_a, requiredWalls.field_77994_a, newType.getLocalizedName()});
        }
        this.consumeItems(player, requiredCores.func_77946_l(), false);
        this.consumeItems(player, requiredInterfaces.func_77946_l(), false);
        this.consumeItems(player, requiredWalls.func_77946_l(), false);
        if (!world.field_72995_K) {
            tile.setSize(Vec3i.field_177959_e);
            tile.setMaterial(newType);
            TileColossalChest.detector.detect(world, pos, null, new CubeDetector.IValidationAction(){

                public L10NHelpers.UnlocalizedString onValidate(BlockPos location, IBlockState blockState) {
                    world.func_180501_a(location, blockState.func_177226_a((IProperty)ColossalChest.MATERIAL, (Comparable)((Object)newType)), 2);
                    if (blockState.func_177230_c() == ColossalChest.getInstance() || blockState.func_177230_c() == Interface.getInstance()) {
                        tile.addInterface((Vec3i)location);
                    }
                    return null;
                }
            }, false);
            tile.setSize(size);
        }
        ItemStack returnedCores = requiredCores.func_77946_l();
        ItemStack returnedInterfaces = requiredInterfaces.func_77946_l();
        ItemStack returnedWalls = requiredWalls.func_77946_l();
        returnedCores.func_77964_b(currentItemMeta);
        returnedInterfaces.func_77964_b(currentItemMeta);
        returnedWalls.func_77964_b(currentItemMeta);
        InventoryHelpers.tryReAddToStack((EntityPlayer)player, null, (ItemStack)returnedCores);
        InventoryHelpers.tryReAddToStack((EntityPlayer)player, null, (ItemStack)returnedInterfaces);
        InventoryHelpers.tryReAddToStack((EntityPlayer)player, null, (ItemStack)returnedWalls);
        return null;
    }

    protected boolean consumeItems(EntityPlayer player, ItemStack consumeStack, boolean simulate) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        PlayerInventoryIterator it = new PlayerInventoryIterator(player);
        int validItems = 0;
        while (it.hasNext()) {
            ItemStack stack = it.next();
            if (stack == null || !ItemStack.func_179545_c((ItemStack)stack, (ItemStack)consumeStack)) continue;
            int previousValidItems = validItems;
            validItems += stack.field_77994_a;
            validItems = Math.min(consumeStack.field_77994_a, validItems);
            if (simulate) continue;
            stack.field_77994_a -= validItems - previousValidItems;
            it.replace(stack.field_77994_a == 0 ? null : stack);
        }
        return validItems == consumeStack.field_77994_a;
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        super.func_150895_a(itemIn, tab, subItems);
        subItems.add(new ItemStack(itemIn, 1, 1));
    }

    protected PropertyMaterial.Type transformType(ItemStack itemStack, PropertyMaterial.Type type) {
        if (itemStack.func_77960_j() == 0 && type.ordinal() < PropertyMaterial.Type.values().length - 1) {
            return PropertyMaterial.Type.values()[type.ordinal() + 1];
        }
        if (itemStack.func_77960_j() == 1 && type.ordinal() > 0) {
            return PropertyMaterial.Type.values()[type.ordinal() - 1];
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemUpgradeTool)) {
            return false;
        }
        ItemUpgradeTool other = (ItemUpgradeTool)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ItemUpgradeTool;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    public String toString() {
        return "ItemUpgradeTool()";
    }
}

