/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.util;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;

public class ZUtils {
    public static int getAverageColor(long r, long g, long b, int total) {
        return (int)(r / (long)total | g / (long)total << 8 | b / (long)total << 16);
    }

    public static int getDirectionFacing(float rotationYaw) {
        int l = MathHelper.func_76128_c((double)((double)(MathHelper.func_76142_g((float)rotationYaw) * 4.0f / 360.0f) + 0.5)) & 3;
        l = l == 0 ? 2 : (l == 1 ? 5 : (l == 2 ? 3 : 4));
        return l;
    }

    public static List copyRandomElements(List fromList, int maxElements) {
        LinkedList returnList = new LinkedList();
        LinkedList moveList = new LinkedList(fromList);
        Random rand = new Random(System.nanoTime());
        for (int i = 0; i < maxElements && !moveList.isEmpty(); ++i) {
            returnList.add(moveList.remove(rand.nextInt(moveList.size())));
        }
        return returnList;
    }

    public static TileEntity createTile(NBTTagCompound nbt) {
        TileEntity tileentity = null;
        String s = nbt.func_74779_i("id");
        Class oclass = null;
        try {
            oclass = (Class)((Map)ObfuscationReflectionHelper.getPrivateValue(TileEntity.class, null, (String[])new String[]{"field_145855_i", "nameToClassMap"})).get(s);
            if (oclass != null) {
                tileentity = (TileEntity)oclass.newInstance();
            }
        }
        catch (Throwable throwable1) {
            FMLLog.log((Level)Level.ERROR, (Throwable)throwable1, (String)"A TileEntity %s(%s) has thrown an exception during loading, its state cannot be restored. Report this to the mod author", (Object[])new Object[]{s, oclass.getName()});
        }
        if (tileentity != null) {
            try {
                tileentity.func_145839_a(nbt);
            }
            catch (Throwable throwable) {
                FMLLog.log((Level)Level.ERROR, (Throwable)throwable, (String)"A TileEntity %s(%s) has thrown an exception during loading, its state cannot be restored. Report this to the mod author", (Object[])new Object[]{s, oclass.getName()});
                tileentity = null;
            }
        } else {
            FMLLog.warning((String)"Skipping BlockEntity with id {}", (Object[])new Object[]{s});
        }
        return tileentity;
    }

    public static AxisAlignedBB rotateAABB(AxisAlignedBB axis, double angleDeg) {
        double buffer;
        double angle = Math.toRadians(90.0 - angleDeg);
        double minZ = -(axis.field_72340_a * Math.sin(angle) + axis.field_72339_c * Math.cos(angle));
        double maxZ = -(axis.field_72336_d * Math.sin(angle) + axis.field_72334_f * Math.cos(angle));
        double minX = -(axis.field_72339_c * Math.sin(angle) + axis.field_72340_a * Math.cos(angle));
        double maxX = -(axis.field_72334_f * Math.sin(angle) + axis.field_72336_d * Math.cos(angle));
        if (minZ > maxZ) {
            buffer = minZ;
            minZ = maxZ;
            maxZ = buffer;
        }
        if (minX > maxZ) {
            buffer = minX;
            minX = maxX;
            maxX = buffer;
        }
        AxisAlignedBB ret = new AxisAlignedBB(minX, axis.field_72338_b, minZ, maxX, axis.field_72337_e, maxZ);
        return ret;
    }

    public static AxisAlignedBB convertLocalBBToGlobal(AxisAlignedBB local, AxisAlignedBB global, Entity e, double angle) {
        AxisAlignedBB rotatedLocal = ZUtils.rotateAABB(local, angle);
        return new AxisAlignedBB(e.field_70165_t + rotatedLocal.field_72340_a, e.field_70163_u + rotatedLocal.field_72338_b, e.field_70161_v + rotatedLocal.field_72339_c, rotatedLocal.field_72336_d + e.field_70165_t, rotatedLocal.field_72337_e + e.field_70163_u, rotatedLocal.field_72334_f + e.field_70161_v);
    }

    public static String formatNumber(int number) {
        if (number > 999999999) {
            return (float)(number / 1000000) / 10.0f + "T";
        }
        if (number > 999999) {
            return (float)(number / 1000000) / 10.0f + "M";
        }
        if (number > 999) {
            return (float)(number / 100) / 10.0f + "K";
        }
        return String.valueOf(number);
    }

    public static boolean isInvEmpty(ItemStack[] stack) {
        boolean empty = true;
        if (stack == null) {
            return true;
        }
        for (ItemStack i : stack) {
            if (i == null) continue;
            return false;
        }
        return true;
    }

    public static boolean doesArrayContains(Object[] object, Object object2) {
        for (Object obj : object) {
            if (!obj.equals(object2)) continue;
            return true;
        }
        return false;
    }

    public static boolean doesArrayContains(int[] object, Object object2) {
        int[] nArray = object;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer obj = nArray[i];
            if (!((Object)obj).equals(object2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInvEmpty(IInventory stack) {
        boolean empty = true;
        if (stack == null) {
            return true;
        }
        for (int i = 0; i < stack.func_70302_i_(); ++i) {
            if (stack.func_70301_a(i) == null) continue;
            return false;
        }
        return true;
    }

    public static boolean doesInvHaveRoom(ItemStack item, IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i) != null && (!item.func_77969_a(inv.func_70301_a(i)) || inv.func_70301_a((int)i).field_77994_a >= inv.func_70297_j_())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasFullStack(IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i) == null || inv.func_70301_a(i).func_77976_d() != inv.func_70301_a((int)i).field_77994_a) continue;
            return true;
        }
        return false;
    }

    public static int numEmptySlots(IInventory inv) {
        int num = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i) != null) continue;
            ++num;
        }
        return num;
    }

    public static int numFilledSlots(IInventory inv) {
        int num = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i) == null || inv.func_70301_a((int)i).field_77994_a != inv.func_70301_a(i).func_77976_d()) continue;
            ++num;
        }
        return num;
    }

    public static void mergeInventory(ItemStack[] a, IInventory b) {
        for (int i = 0; i < a.length; ++i) {
            int firstEmtpySlot = -1;
            if (a[i] == null) continue;
            for (int slot = 0; slot < b.func_70302_i_(); ++slot) {
                if (b.func_70301_a(slot) == null) {
                    if (firstEmtpySlot != -1) continue;
                    firstEmtpySlot = slot;
                    continue;
                }
                if (!b.func_70301_a(slot).func_77969_a(a[i])) continue;
                int maxTransfer = b.func_70297_j_() - b.func_70301_a((int)slot).field_77994_a;
                if (a[i].field_77994_a < maxTransfer) {
                    b.func_70301_a((int)slot).field_77994_a += a[i].field_77994_a;
                    a[i] = null;
                    break;
                }
                b.func_70301_a((int)slot).field_77994_a = b.func_70297_j_();
                a[i].field_77994_a -= maxTransfer;
            }
            if (a[i] == null || firstEmtpySlot == -1) continue;
            b.func_70299_a(firstEmtpySlot, a[i].func_77946_l());
            a[i] = null;
        }
    }

    public static void mergeInventory(ItemStack a, IInventory b) {
        int firstEmtpySlot = -1;
        if (a != null) {
            for (int slot = 0; slot < b.func_70302_i_(); ++slot) {
                if (b.func_70301_a(slot) == null) {
                    if (firstEmtpySlot != -1) continue;
                    firstEmtpySlot = slot;
                    continue;
                }
                if (!b.func_70301_a(slot).func_77969_a(a)) continue;
                int maxTransfer = b.func_70297_j_() - b.func_70301_a((int)slot).field_77994_a;
                if (a.field_77994_a < maxTransfer) {
                    b.func_70301_a((int)slot).field_77994_a += a.field_77994_a;
                    a = null;
                    break;
                }
                b.func_70301_a((int)slot).field_77994_a = b.func_70297_j_();
                a.field_77994_a -= maxTransfer;
            }
            if (a != null && firstEmtpySlot != -1) {
                if (a.field_77994_a != 0) {
                    b.func_70299_a(firstEmtpySlot, a.func_77946_l());
                }
                a = null;
            }
        }
    }

    public static ItemStack getFirstItemInInv(ItemStack[] i) {
        for (ItemStack stack : i) {
            if (stack == null) continue;
            return stack;
        }
        return null;
    }

    public static int getFirstFilledSlotIndex(IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i) == null) continue;
            return i;
        }
        return inv.func_70302_i_();
    }

    public static int getContinuousBlockLength(World world, EnumFacing direction, BlockPos pos, int maxDist, Block block) {
        int dist = 0;
        for (int i = 0; i < maxDist && world.func_180495_p(new BlockPos((Vec3i)pos.func_177982_a(i * direction.func_82601_c(), i * direction.func_96559_d(), i * direction.func_82599_e()))).func_177230_c() == block; ++i) {
            dist = i + 1;
        }
        return dist;
    }

    public static int getContinuousBlockLength(World world, EnumFacing direction, BlockPos pos, int maxDist, Block[] blocks) {
        int dist = 0;
        for (int i = 0; i < maxDist; ++i) {
            Block blockchecked = world.func_180495_p(new BlockPos((Vec3i)pos.func_177982_a(i * direction.func_82601_c(), i * direction.func_96559_d(), i * direction.func_82599_e()))).func_177230_c();
            boolean exists = false;
            for (Block b : blocks) {
                if (blockchecked != b) continue;
                exists = true;
                break;
            }
            if (!exists) break;
            dist = i + 1;
        }
        return dist;
    }

    public static boolean areOresSameTypeOreDict(ItemStack stack1, ItemStack stack2) {
        int[] stack1Id = OreDictionary.getOreIDs((ItemStack)stack1);
        int[] stack2Id = OreDictionary.getOreIDs((ItemStack)stack2);
        for (int i : stack1Id) {
            for (int j : stack2Id) {
                if (i != j) continue;
                return true;
            }
        }
        return false;
    }

    public static enum RedstoneState {
        ON,
        OFF,
        INVERTED;


        public RedstoneState getNext() {
            int i = this.ordinal() + 1;
            if (i >= RedstoneState.values().length) {
                return RedstoneState.values()[0];
            }
            return RedstoneState.values()[i];
        }

        public RedstoneState getPrev() {
            int i = this.ordinal() - 1;
            if (i < 0) {
                return RedstoneState.values()[RedstoneState.values().length - 1];
            }
            return RedstoneState.values()[i];
        }

        public void writeToNBT(NBTTagCompound tag) {
            tag.func_74774_a("redstoneState", (byte)this.ordinal());
        }

        public static RedstoneState createFromNBT(NBTTagCompound tag) {
            return RedstoneState.values()[tag.func_74771_c("redstoneState")];
        }
    }
}

