/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.inventory.modules;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zmaster587.libVulpes.inventory.TextureResources;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.util.ZUtils;

public class ModuleRedstoneOutputButton
extends ModuleButton {
    ZUtils.RedstoneState state;
    String suppText;

    public ModuleRedstoneOutputButton(int offsetX, int offsetY, int buttonId, String text, IButtonInventory tile) {
        super(offsetX, offsetY, buttonId, text, tile, TextureResources.buttonRedstoneActive, 24, 24);
        this.sizeX = 24;
        this.sizeY = 24;
        this.state = ZUtils.RedstoneState.ON;
        this.suppText = "";
    }

    public ModuleRedstoneOutputButton(int offsetX, int offsetY, int buttonId, String text, IButtonInventory tile, String text2) {
        this(offsetX, offsetY, buttonId, text, tile);
        this.suppText = text2;
    }

    public ZUtils.RedstoneState getState() {
        return this.state;
    }

    public void setRedstoneState(int i) {
        this.state = ZUtils.RedstoneState.values()[i];
    }

    public void setRedstoneState(ZUtils.RedstoneState i) {
        this.state = i;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderBackground(GuiContainer gui, int x, int y, int mouseX, int mouseY, FontRenderer font) {
        if (this.state != null) {
            switch (this.state) {
                case ON: {
                    this.button.setButtonTexture(TextureResources.buttonRedstoneActive);
                    this.tooltipText = this.suppText + "Redstone control normal";
                    break;
                }
                case OFF: {
                    this.button.setButtonTexture(TextureResources.buttonRedstoneDisabled);
                    this.tooltipText = this.suppText + "Redstone control disabled";
                    break;
                }
                case INVERTED: {
                    this.button.setButtonTexture(TextureResources.buttonRedstoneInverted);
                    this.tooltipText = this.suppText + "Redstone control inverted";
                }
            }
        }
        super.renderBackground(gui, x, y, mouseX, mouseY, font);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void actionPerform(GuiButton button) {
        if (this.enabled && button == this.button) {
            if (this.state == null) {
                this.state = ZUtils.RedstoneState.ON;
            }
            this.state = this.state.getNext();
            this.tile.onInventoryButtonPressed(this.buttonId);
        }
    }
}

