/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.inventory.modules;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.Slot;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.gui.CommonResources;
import zmaster587.libVulpes.inventory.GuiModular;

public abstract class ModuleBase {
    public int offsetX;
    public int offsetY;
    protected int sizeX;
    protected int sizeY;
    protected List<Slot> slotList;
    protected Long lastTickTime;
    boolean isSendingChanges = false;
    private boolean enabled;
    private boolean visible;

    protected ModuleBase(int offsetX, int offsetY) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.slotList = new LinkedList<Slot>();
        this.enabled = true;
        this.visible = true;
    }

    protected long getCurrentTime() {
        return LibVulpes.time;
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public int getSizeY() {
        return this.sizeY;
    }

    protected void updatePreviousState(int localId) {
    }

    public boolean needsUpdate(int localId) {
        return false;
    }

    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @SideOnly(value=Side.CLIENT)
    public void onMouseClicked(GuiModular gui, int x, int y, int button) {
    }

    @SideOnly(value=Side.CLIENT)
    public void onMouseClickedAndDragged(int x, int y, int button, long timeSineLastClick) {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean keyTyped(char chr, int t) {
        return true;
    }

    public boolean isUpdateRequired(int localId) {
        boolean ret = this.needsUpdate(localId);
        if (ret) {
            if (!this.isSendingChanges) {
                this.lastTickTime = this.getCurrentTime();
                this.isSendingChanges = true;
            } else if (this.lastTickTime.longValue() != this.getCurrentTime()) {
                this.isSendingChanges = false;
                this.updatePreviousState(localId);
            }
        }
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderBackground(GuiContainer gui, int x, int y, int mouseX, int mouseY, FontRenderer font) {
        gui.field_146297_k.func_110434_K().func_110577_a(CommonResources.genericBackground);
        for (Slot slot : this.slotList) {
            gui.func_73729_b(x + slot.field_75223_e - 1, y + slot.field_75221_f - 1, 176, 0, 18, 18);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderForeground(int guiOffsetX, int guiOffsetY, int mouseX, int mouseY, float zLevel, GuiContainer gui, FontRenderer font) {
    }

    public void sendChanges(Container container, IContainerListener crafter, int variableId, int localId) {
    }

    public void sendInitialChanges(Container container, IContainerListener crafter, int variableId) {
        for (int i = 0; i < this.numberOfChangesToSend(); ++i) {
            this.sendChanges(container, crafter, variableId + i, i);
        }
    }

    public void onChangeRecieved(int slot, int value) {
    }

    public int numberOfChangesToSend() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public List<GuiButton> addButtons(int x, int y) {
        return new LinkedList<GuiButton>();
    }

    @SideOnly(value=Side.CLIENT)
    public void actionPerform(GuiButton button) {
    }

    public List<Slot> getSlots(Container container) {
        return new LinkedList<Slot>();
    }

    @SideOnly(value=Side.CLIENT)
    protected void drawTooltip(GuiContainer gui, List<String> textList, int x, int y, float zLevel, FontRenderer font) {
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        int k = 0;
        for (String s : textList) {
            int l = font.func_78256_a(s);
            if (l <= k) continue;
            k = l;
        }
        int j2 = x + 12;
        int k2 = y - 12;
        int i1 = 8 + 12 * (textList.size() - 1);
        zLevel = 300.0f;
        int j1 = -267386864;
        this.drawGradientRect(j2 - 3, k2 - 4, j2 + k + 3, k2 - 3, j1, j1, zLevel);
        this.drawGradientRect(j2 - 3, k2 + i1 + 3, j2 + k + 3, k2 + i1 + 4, j1, j1, zLevel);
        this.drawGradientRect(j2 - 3, k2 - 3, j2 + k + 3, k2 + i1 + 3, j1, j1, zLevel);
        this.drawGradientRect(j2 - 4, k2 - 3, j2 - 3, k2 + i1 + 3, j1, j1, zLevel);
        this.drawGradientRect(j2 + k + 3, k2 - 3, j2 + k + 4, k2 + i1 + 3, j1, j1, zLevel);
        int k1 = 0x505000FF;
        int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
        this.drawGradientRect(j2 - 3, k2 - 3 + 1, j2 - 3 + 1, k2 + i1 + 3 - 1, k1, l1, zLevel);
        this.drawGradientRect(j2 + k + 2, k2 - 3 + 1, j2 + k + 3, k2 + i1 + 3 - 1, k1, l1, zLevel);
        this.drawGradientRect(j2 - 3, k2 - 3, j2 + k + 3, k2 - 3 + 1, k1, k1, zLevel);
        this.drawGradientRect(j2 - 3, k2 + i1 + 2, j2 + k + 3, k2 + i1 + 3, l1, l1, zLevel);
        for (int i2 = 0; i2 < textList.size(); ++i2) {
            String s1 = textList.get(i2);
            font.func_175063_a(s1, (float)j2, (float)k2, -1);
            if (i2 == 0) {
                k2 += 2;
            }
            k2 += 10;
        }
        zLevel = 0.0f;
        GL11.glEnable((int)2929);
        RenderHelper.func_74519_b();
        GL11.glEnable((int)32826);
        GL11.glDisable((int)2896);
    }

    @SideOnly(value=Side.CLIENT)
    protected void drawGradientRect(int x1, int y1, int x2, int y2, int colorA, int colorB, float zLevel) {
        float f = (float)(colorA >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(colorA >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(colorA >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(colorA & 0xFF) / 255.0f;
        float f4 = (float)(colorB >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(colorB >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(colorB >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(colorB & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertex = tessellator.func_178180_c();
        vertex.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertex.func_181662_b((double)x2, (double)y1, (double)zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        vertex.func_181662_b((double)x1, (double)y1, (double)zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        vertex.func_181662_b((double)x1, (double)y2, (double)zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        vertex.func_181662_b((double)x2, (double)y2, (double)zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }
}

