/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.util;

import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;

public final class StringHelper {
    private static DecimalFormat decimalFormat = new DecimalFormat("###,###,###,###,###");
    public static final String BLACK = "\u00a70";
    public static final String BLUE = "\u00a71";
    public static final String GREEN = "\u00a72";
    public static final String TEAL = "\u00a73";
    public static final String RED = "\u00a74";
    public static final String PURPLE = "\u00a75";
    public static final String ORANGE = "\u00a76";
    public static final String LIGHT_GRAY = "\u00a77";
    public static final String GRAY = "\u00a78";
    public static final String LIGHT_BLUE = "\u00a79";
    public static final String BRIGHT_GREEN = "\u00a7a";
    public static final String BRIGHT_BLUE = "\u00a7b";
    public static final String LIGHT_RED = "\u00a7c";
    public static final String PINK = "\u00a7d";
    public static final String YELLOW = "\u00a7e";
    public static final String WHITE = "\u00a7f";
    public static final String OBFUSCATED = "\u00a7k";
    public static final String BOLD = "\u00a7l";
    public static final String STRIKETHROUGH = "\u00a7m";
    public static final String UNDERLINE = "\u00a7n";
    public static final String ITALIC = "\u00a7o";
    public static final String END = "\u00a7r";
    public static boolean displayShiftForDetail = true;
    public static boolean displayStackCount = false;

    private StringHelper() {
    }

    public static int getSplitStringHeight(FontRenderer fontRenderer, String input, int width) {
        List stringRows = fontRenderer.func_78271_c(input, width);
        return stringRows.size() * fontRenderer.field_78288_b;
    }

    public static String camelCase(String input) {
        return input.substring(0, 1).toLowerCase() + input.substring(1);
    }

    public static String titleCase(String input) {
        return input.substring(0, 1).toUpperCase() + input.substring(1);
    }

    public static String localize(String key) {
        return I18n.func_74838_a((String)key);
    }

    public static String getItemName(ItemStack item) {
        String name = END;
        if (item.func_77953_t() == EnumRarity.UNCOMMON) {
            name = name + YELLOW;
        } else if (item.func_77953_t() == EnumRarity.RARE) {
            name = name + BRIGHT_BLUE;
        } else if (item.func_77953_t() == EnumRarity.EPIC) {
            name = name + PINK;
        }
        name = name + item.func_82833_r() + END;
        return name;
    }

    public static String getScaledNumber(int number) {
        return StringHelper.getScaledNumber(number, 10);
    }

    public static String getScaledNumber(int number, int minDigits) {
        String numString = "";
        int numMod = 10 * minDigits;
        numString = number > 100000 * numMod ? numString + decimalFormat.format(number / 1000000) + "M" : (number > 100 * numMod ? numString + decimalFormat.format(number / 1000) + "k" : numString + decimalFormat.format(number));
        return numString;
    }

    public static String getActivationText(String key) {
        return "\u00a7b\u00a7o" + StringHelper.localize(key) + END;
    }

    public static String getDeactivationText(String key) {
        return "\u00a7e\u00a7o" + StringHelper.localize(key) + END;
    }

    public static String getInfoText(String key) {
        return BRIGHT_GREEN + StringHelper.localize(key) + END;
    }

    public static String getFlavorText(String key) {
        return "\u00a7f\u00a7o" + StringHelper.localize(key) + END;
    }
}

