/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.ref;

import com.vanhal.progressiveautomation.items.PAItems;
import com.vanhal.progressiveautomation.util.PlayerFake;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class ToolHelper {
    public static int TYPE_PICKAXE = 0;
    public static int TYPE_SHOVEL = 1;
    public static int TYPE_AXE = 2;
    public static int TYPE_SWORD = 3;
    public static int TYPE_HOE = 4;
    public static final int LEVEL_WOOD = 0;
    public static final int LEVEL_STONE = 1;
    public static final int LEVEL_IRON = 2;
    public static final int LEVEL_GOLD = 0;
    public static final int LEVEL_DIAMOND = 3;
    public static final int LEVEL_MAX = 100;
    public static int SPEED_WOOD = 2;
    public static int SPEED_STONE = 4;
    public static int SPEED_IRON = 6;
    public static int SPEED_DIAMOND = 8;
    public static int SPEED_GOLD = 12;
    protected static Random RND = new Random();

    public static int getType(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        if (item instanceof ItemPickaxe) {
            return TYPE_PICKAXE;
        }
        if (item instanceof ItemAxe) {
            return TYPE_AXE;
        }
        if (item instanceof ItemSpade) {
            return TYPE_SHOVEL;
        }
        if (item instanceof ItemSword) {
            return TYPE_SWORD;
        }
        if (item instanceof ItemHoe) {
            return TYPE_HOE;
        }
        if (item instanceof ItemTool) {
            Set toolClasses = ((ItemTool)item).getToolClasses(itemStack);
            if (toolClasses.contains("pickaxe")) {
                return TYPE_PICKAXE;
            }
            if (toolClasses.contains("axe")) {
                return TYPE_AXE;
            }
            if (toolClasses.contains("shovel")) {
                return TYPE_SHOVEL;
            }
            if (toolClasses.contains("hoe")) {
                return TYPE_HOE;
            }
            return -1;
        }
        if (ToolHelper.tinkersType(item) >= 0) {
            return ToolHelper.tinkersType(item);
        }
        return -1;
    }

    public static int getLevel(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof ItemTool) {
            return ((ItemTool)itemStack.func_77973_b()).func_150913_i().func_77996_d();
        }
        if (itemStack.func_77973_b() instanceof ItemSword || itemStack.func_77973_b() instanceof ItemHoe) {
            String material = "";
            if (itemStack.func_77973_b() instanceof ItemSword) {
                material = ((ItemSword)itemStack.func_77973_b()).func_150932_j();
            } else if (itemStack.func_77973_b() instanceof ItemHoe) {
                material = ((ItemHoe)itemStack.func_77973_b()).func_77842_f();
            }
            if (material.equals("WOOD")) {
                return 0;
            }
            if (material.equals("STONE")) {
                return 1;
            }
            if (material.equals("IRON")) {
                return 2;
            }
            if (material.equals("GOLD")) {
                return 0;
            }
            if (material.equals("EMERALD")) {
                return 3;
            }
            if (material.equals("DIAMOND")) {
                return 3;
            }
        } else if (itemStack.func_77942_o()) {
            return ToolHelper.tinkersLevel(itemStack);
        }
        return -1;
    }

    public static int tinkersLevel(ItemStack item) {
        if (item.func_77978_p().func_74764_b("Stats")) {
            NBTTagCompound tags = item.func_77978_p().func_74775_l("Stats");
            int toolLevel = tags.func_74762_e("HarvestLevel");
            return toolLevel;
        }
        return -1;
    }

    public static int tinkersType(Item item) {
        String name = item.func_77658_a();
        if (name.length() >= 16 && name.substring(5, 15).equalsIgnoreCase("tconstruct")) {
            if (name.substring(16).equalsIgnoreCase("pickaxe")) {
                return TYPE_PICKAXE;
            }
            if (name.substring(16).equalsIgnoreCase("axe") || name.substring(16).equalsIgnoreCase("hatchet")) {
                return TYPE_AXE;
            }
            if (name.substring(16).equalsIgnoreCase("shovel")) {
                return TYPE_SHOVEL;
            }
            if (name.substring(16).equalsIgnoreCase("hoe") || name.substring(16).equalsIgnoreCase("Mattock")) {
                return TYPE_HOE;
            }
            if (name.substring(16).equalsIgnoreCase("Broadsword") || name.substring(16).equalsIgnoreCase("Rapier") || name.substring(16).equalsIgnoreCase("Cutlass") || name.substring(16).equalsIgnoreCase("Cleaver")) {
                return TYPE_SWORD;
            }
        }
        return -1;
    }

    public static boolean isBroken(ItemStack item) {
        if (item == null) {
            return false;
        }
        boolean broken = ToolHelper.tinkersIsBroken(item);
        if (!broken && item.func_77952_i() >= item.func_77958_k()) {
            return true;
        }
        return broken;
    }

    public static boolean tinkersIsBroken(ItemStack item) {
        if (item == null) {
            return false;
        }
        if (item.func_77942_o() && item.func_77978_p().func_74764_b("Stats")) {
            NBTTagCompound tags = item.func_77978_p().func_74775_l("Stats");
            return tags.func_74767_n("Broken");
        }
        return false;
    }

    public static ItemStack getUpgradeType(int level) {
        if (level >= 3) {
            return new ItemStack((Item)PAItems.diamondUpgrade);
        }
        if (level == 2) {
            return new ItemStack((Item)PAItems.ironUpgrade);
        }
        if (level == 1) {
            return new ItemStack((Item)PAItems.stoneUpgrade);
        }
        return new ItemStack((Item)PAItems.woodUpgrade);
    }

    public static int getHarvestLevel(ItemStack item) {
        int value = ToolHelper.getLevel(item);
        return value;
    }

    public static int getSpeed(int level) {
        if (level == 0) {
            return SPEED_GOLD;
        }
        if (level >= 3) {
            return SPEED_DIAMOND;
        }
        if (level == 2) {
            return SPEED_IRON;
        }
        if (level == 1) {
            return SPEED_STONE;
        }
        if (level == 0) {
            return SPEED_WOOD;
        }
        return 1;
    }

    public static float getDigSpeed(ItemStack itemStack, IBlockState state) {
        if (itemStack != null && itemStack.func_77973_b() != null && itemStack.func_77973_b() instanceof ItemTool) {
            ItemTool tool = (ItemTool)itemStack.func_77973_b();
            Item.ToolMaterial mat = tool.func_150913_i();
            if (tool.canHarvestBlock(state, itemStack)) {
                return mat.func_77998_b();
            }
        }
        return 1.0f;
    }

    public static boolean damageTool(ItemStack tool, World world, int x, int y, int z) {
        if (tool.func_77973_b() instanceof ItemShears || tool.func_77973_b() instanceof ItemTool || tool.func_77973_b() instanceof ItemHoe || tool.func_77973_b() instanceof ItemSword) {
            if (tool.func_96631_a(1, RND)) {
                return true;
            }
        } else {
            Block mineBlock = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
            PlayerFake fakePlayer = new PlayerFake((WorldServer)world);
            if (ToolHelper.tinkersType(tool.func_77973_b()) == TYPE_HOE) {
                tool.func_96631_a(1, RND);
            } else {
                tool.func_77973_b().func_179218_a(tool, world, mineBlock.func_176223_P(), new BlockPos(x, y, z), (EntityLivingBase)fakePlayer);
            }
            if (ToolHelper.tinkersIsBroken(tool)) {
                return true;
            }
        }
        return false;
    }
}

