/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.items;

import com.vanhal.progressiveautomation.blocks.BaseBlock;
import com.vanhal.progressiveautomation.entities.BaseTileEntity;
import com.vanhal.progressiveautomation.items.BaseItem;
import com.vanhal.progressiveautomation.ref.WrenchModes;
import com.vanhal.progressiveautomation.util.IDismantleable;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ItemWrench
extends BaseItem {
    public ItemWrench() {
        super("Wrench");
        this.func_77625_d(1);
    }

    private void setMode(ItemStack itemStack, WrenchModes.Mode mode) {
        this.setDamage(itemStack, mode.ordinal());
    }

    private WrenchModes.Mode getMode(ItemStack itemStack) {
        if (WrenchModes.modes.size() > itemStack.func_77952_i()) {
            return WrenchModes.modes.get(itemStack.func_77952_i());
        }
        return WrenchModes.Mode.Rotate;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean bool) {
        list.add(TextFormatting.GRAY + "Current Mode: " + TextFormatting.WHITE + (Object)((Object)this.getMode(itemStack)));
    }

    public EnumActionResult onItemUseFirst(ItemStack itemStack, EntityPlayer player, World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, EnumHand hand) {
        return EnumActionResult.PASS;
    }

    public EnumActionResult func_180614_a(ItemStack itemStack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (player.func_70093_af()) {
            IDismantleable dBlock;
            if (block instanceof IDismantleable && (dBlock = (IDismantleable)block).canDismantle(player, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) {
                if (!world.field_72995_K) {
                    dBlock.dismantleBlock(player, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), false);
                }
                return EnumActionResult.SUCCESS;
            }
        } else {
            if (this.getMode(itemStack) == WrenchModes.Mode.Rotate) {
                block.rotateBlock(world, pos, face);
                return EnumActionResult.SUCCESS;
            }
            if (block instanceof BaseBlock) {
                BaseTileEntity PABlock = (BaseTileEntity)world.func_175625_s(pos);
                if (this.getMode(itemStack) == WrenchModes.Mode.Query) {
                    if (world.field_72995_K) {
                        player.func_145747_a((ITextComponent)new TextComponentString(face + " side currently set to: " + (Object)((Object)PABlock.getSide(face))));
                    }
                } else {
                    PABlock.setSide(face, this.getMode(itemStack));
                    if (world.field_72995_K) {
                        player.func_145747_a((ITextComponent)new TextComponentString(face + " side set to: " + (Object)((Object)this.getMode(itemStack))));
                    }
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStack, World world, EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            int temp = this.getMode(itemStack).ordinal() + 1;
            if (temp >= WrenchModes.modes.size()) {
                temp = 0;
            }
            ((ItemWrench)itemStack.func_77973_b()).setMode(itemStack, WrenchModes.modes.get(temp));
            if (world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString("Mode: " + (Object)((Object)WrenchModes.modes.get(temp))));
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemStack);
    }

    public void dumpItems(World world, int x, int y, int z, ItemStack items) {
        EntityItem entItem = new EntityItem(world, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), items);
        float f3 = 0.05f;
        entItem.field_70159_w = (float)world.field_73012_v.nextGaussian() * f3;
        entItem.field_70181_x = (float)world.field_73012_v.nextGaussian() * f3 + 0.2f;
        entItem.field_70179_y = (float)world.field_73012_v.nextGaussian() * f3;
        world.func_72838_d((Entity)entItem);
    }

    @Override
    protected void addNormalRecipe() {
        ShapedOreRecipe recipe = new ShapedOreRecipe(new ItemStack((Item)this), new Object[]{"s s", " i ", " s ", Character.valueOf('i'), Items.field_151042_j, Character.valueOf('s'), Items.field_151055_y});
        GameRegistry.addRecipe((IRecipe)recipe);
    }

    @Override
    protected void addUpgradeRecipe() {
        this.addNormalRecipe();
    }

    @Override
    public void init() {
        for (int i = 0; i < WrenchModes.Mode.values().length; ++i) {
            Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a((Item)this, i, new ModelResourceLocation("progressiveautomation:" + this.itemName, "inventory"));
        }
    }
}

