/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.gui.client;

import com.vanhal.progressiveautomation.entities.planter.TilePlanter;
import com.vanhal.progressiveautomation.gui.client.BaseGUI;
import com.vanhal.progressiveautomation.gui.container.ContainerPlanter;
import com.vanhal.progressiveautomation.upgrades.UpgradeType;
import com.vanhal.progressiveautomation.util.StringHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class GUIPlanter
extends BaseGUI {
    public static final ResourceLocation texture = new ResourceLocation("progressiveautomation", "textures/gui/Planter.png");
    protected int infoScreenX = 38;
    protected int infoScreenW = 66;
    protected int infroScreenY1 = 17;
    protected int infroScreenY2 = 27;
    protected int infroScreenY3 = 37;
    TilePlanter planter;

    public GUIPlanter(InventoryPlayer inv, TileEntity entity) {
        super(new ContainerPlanter(inv, entity), texture);
        this.planter = (TilePlanter)entity;
    }

    @Override
    protected void drawText() {
        this.drawString(StringHelper.localize("gui.planter"), 5, GRAY);
        this.drawString(StringHelper.localize("gui.range") + ": " + StringHelper.getScaledNumber(this.planter.getRange()), this.infoScreenX, this.infoScreenW, this.infroScreenY3, this.planter.hasUpgrade(UpgradeType.WITHER) ? GREEN : WHITE);
        if (this.planter.isInvalidTool()) {
            this.drawString(this.getTextLine(1, "gui.invalidtool.1"), this.infoScreenX, this.infoScreenW, this.infroScreenY1, ORANGE);
            this.drawString(this.getTextLine(2, "gui.invalidtool.2"), this.infoScreenX, this.infoScreenW, this.infroScreenY2, ORANGE);
        } else if (this.planter.isLooked()) {
            boolean readyToPlant = false;
            if (this.planter.isFull()) {
                this.drawString(StringHelper.localize("gui.full"), this.infoScreenX, this.infoScreenW, this.infroScreenY2, RED);
            } else if (!this.planter.hasFuel() && !this.planter.isBurning()) {
                String fuelString = "gui.need.fuel";
                if (this.planter.hasEngine()) {
                    fuelString = "gui.need.energy";
                }
                this.drawString(StringHelper.localize(fuelString), this.infoScreenX, this.infoScreenW, this.infroScreenY2, RED);
            } else if (this.planter.func_70301_a(this.planter.SLOT_SEEDS) == null && !this.planter.isBurning()) {
                this.drawString(StringHelper.localize("gui.need.seeds"), this.infoScreenX, this.infoScreenW, this.infroScreenY2, RED);
            } else if (this.planter.func_70301_a(this.planter.SLOT_HOE) == null) {
                this.drawString(StringHelper.localize("gui.need.hoe"), this.infoScreenX, this.infoScreenW, this.infroScreenY2, RED);
            } else {
                readyToPlant = true;
                String status = "gui.waiting";
                if (this.planter.getStatus() == 1) {
                    status = "gui.harvesting";
                } else if (this.planter.getStatus() == 2) {
                    status = "gui.planting";
                }
                this.drawString(StringHelper.localize(status), this.infoScreenX, this.infoScreenW, this.infroScreenY2, BLUE);
            }
            if (!readyToPlant) {
                this.drawString(StringHelper.localize("gui.notready"), this.infoScreenX, this.infoScreenW, this.infroScreenY1, RED);
            } else if (this.planter.isBurning()) {
                this.drawString(StringHelper.localize("gui.running"), this.infoScreenX, this.infoScreenW, this.infroScreenY1, BLUE);
            } else {
                this.drawString(StringHelper.localize("gui.waiting"), this.infoScreenX, this.infoScreenW, this.infroScreenY1, GREEN);
            }
        } else {
            this.drawString(this.getTextLine(1, "gui.hi.planter"), this.infoScreenX, this.infoScreenW, this.infroScreenY1, GREEN);
            this.drawString(this.getTextLine(2, "gui.addtools"), this.infoScreenX, this.infoScreenW, this.infroScreenY2, GREEN);
        }
    }

    @Override
    protected void drawElements() {
        this.drawFlame(this.planter.getPercentDone(), 10, 34);
    }
}

