/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.gui.client;

import com.vanhal.progressiveautomation.entities.generator.TileGenerator;
import com.vanhal.progressiveautomation.gui.client.BaseGUI;
import com.vanhal.progressiveautomation.gui.container.ContainerGenerator;
import com.vanhal.progressiveautomation.util.StringHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class GUIGenerator
extends BaseGUI {
    public static final ResourceLocation texture = new ResourceLocation("progressiveautomation", "textures/gui/Generator.png");
    protected int infoScreenX = 68;
    protected int infoScreenW = 87;
    protected int infroScreenY1 = 16;
    protected int infroScreenY2 = 26;
    protected int infroScreenY3 = 36;
    TileGenerator generator;

    public GUIGenerator(InventoryPlayer inv, TileEntity entity) {
        super(new ContainerGenerator(inv, entity), texture);
        this.generator = (TileGenerator)entity;
        this.setHeight(135);
    }

    @Override
    protected void drawText() {
        this.drawString(StringHelper.localize("gui.generator"), 5, GRAY);
        this.drawString(StringHelper.getScaledNumber(this.generator.getEnergyStored(), 100) + " / " + StringHelper.getScaledNumber(this.generator.getMaxEnergyStored()) + " RF", this.infoScreenX, this.infoScreenW, this.infroScreenY3, RED);
        boolean ready = false;
        if (!this.generator.hasFuel() && !this.generator.isBurning()) {
            this.drawString(StringHelper.localize("gui.need.fuel"), this.infoScreenX, this.infoScreenW, this.infroScreenY2, RED);
        } else if (this.generator.getEnergyStored() >= this.generator.getMaxEnergyStored() && !this.generator.isBurning()) {
            ready = true;
            this.drawString(StringHelper.localize("gui.full"), this.infoScreenX, this.infoScreenW, this.infroScreenY2, GREEN);
        } else {
            ready = true;
            this.drawString("+" + this.generator.getProduceRate() + " RF/t", this.infoScreenX, this.infoScreenW, this.infroScreenY2, BLUE);
        }
        if (!ready) {
            this.drawString(StringHelper.localize("gui.notready"), this.infoScreenX, this.infoScreenW, this.infroScreenY1, RED);
        } else if (this.generator.isBurning()) {
            this.drawString(StringHelper.localize("gui.running"), this.infoScreenX, this.infoScreenW, this.infroScreenY1, BLUE);
        } else {
            this.drawString(StringHelper.localize("gui.waiting"), this.infoScreenX, this.infoScreenW, this.infroScreenY1, GREEN);
        }
    }

    @Override
    protected void drawElements() {
        this.drawFlame(this.generator.getPercentDone(), 47, 22);
    }
}

