/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.gui.client;

import com.vanhal.progressiveautomation.entities.chopper.TileChopper;
import com.vanhal.progressiveautomation.gui.client.BaseGUI;
import com.vanhal.progressiveautomation.gui.container.ContainerChopper;
import com.vanhal.progressiveautomation.upgrades.UpgradeType;
import com.vanhal.progressiveautomation.util.StringHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class GUIChopper
extends BaseGUI {
    public static final ResourceLocation texture = new ResourceLocation("progressiveautomation", "textures/gui/Chopper.png");
    protected int infoScreenX = 38;
    protected int infoScreenW = 66;
    protected int infroScreenY1 = 17;
    protected int infroScreenY2 = 27;
    protected int infroScreenY3 = 37;
    TileChopper chopper;

    public GUIChopper(InventoryPlayer inv, TileEntity entity) {
        super(new ContainerChopper(inv, entity), texture);
        this.chopper = (TileChopper)entity;
    }

    @Override
    protected void drawText() {
        this.drawString(StringHelper.localize("gui.chopper"), 5, GRAY);
        this.drawString(StringHelper.localize("gui.range") + ": " + StringHelper.getScaledNumber(this.chopper.getRange()), this.infoScreenX, this.infoScreenW, this.infroScreenY3, this.chopper.hasUpgrade(UpgradeType.WITHER) ? GREEN : WHITE);
        if (this.chopper.isInvalidTool()) {
            this.drawString(this.getTextLine(1, "gui.invalidtool.1"), this.infoScreenX, this.infoScreenW, this.infroScreenY1, ORANGE);
            this.drawString(this.getTextLine(2, "gui.invalidtool.2"), this.infoScreenX, this.infoScreenW, this.infroScreenY2, ORANGE);
        } else if (this.chopper.isLooked()) {
            boolean readyToChop = false;
            if (this.chopper.isFull()) {
                this.drawString(StringHelper.localize("gui.full"), this.infoScreenX, this.infoScreenW, this.infroScreenY2, RED);
            } else if (!this.chopper.hasFuel() && !this.chopper.isBurning()) {
                String fuelString = "gui.need.fuel";
                if (this.chopper.hasEngine()) {
                    fuelString = "gui.need.energy";
                }
                this.drawString(StringHelper.localize(fuelString), this.infoScreenX, this.infoScreenW, this.infroScreenY2, RED);
            } else if (this.chopper.func_70301_a(this.chopper.SLOT_SAPLINGS) == null && !this.chopper.isBurning()) {
                this.drawString(StringHelper.localize("gui.need.sapling"), this.infoScreenX, this.infoScreenW, this.infroScreenY2, RED);
            } else if (this.chopper.func_70301_a(this.chopper.SLOT_AXE) == null) {
                this.drawString(StringHelper.localize("gui.need.axe"), this.infoScreenX, this.infoScreenW, this.infroScreenY2, RED);
            } else {
                readyToChop = true;
                String status = "gui.waiting";
                if (this.chopper.isChopping()) {
                    status = "gui.chopping";
                } else if (this.chopper.isPlanting()) {
                    status = "gui.planting";
                }
                this.drawString(StringHelper.localize(status), this.infoScreenX, this.infoScreenW, this.infroScreenY2, BLUE);
            }
            if (!readyToChop) {
                this.drawString(StringHelper.localize("gui.notready"), this.infoScreenX, this.infoScreenW, this.infroScreenY1, RED);
            } else if (this.chopper.isBurning()) {
                this.drawString(StringHelper.localize("gui.running"), this.infoScreenX, this.infoScreenW, this.infroScreenY1, BLUE);
            } else {
                this.drawString(StringHelper.localize("gui.waiting"), this.infoScreenX, this.infoScreenW, this.infroScreenY1, GREEN);
            }
        } else {
            this.drawString(this.getTextLine(1, "gui.hi.chopper"), this.infoScreenX, this.infoScreenW, this.infroScreenY1, GREEN);
            this.drawString(this.getTextLine(2, "gui.addtools"), this.infoScreenX, this.infoScreenW, this.infroScreenY2, GREEN);
        }
    }

    @Override
    protected void drawElements() {
        this.drawFlame(this.chopper.getPercentDone(), 10, 34);
        if (this.chopper.hasUpgrade(UpgradeType.SHEARING)) {
            this.func_73729_b(this.field_147003_i + 62, this.field_147009_r + 51, 238, 0, 18, 18);
        }
    }
}

