/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.gui.client;

import com.vanhal.progressiveautomation.entities.capacitor.TileCapacitor;
import com.vanhal.progressiveautomation.gui.client.BaseGUI;
import com.vanhal.progressiveautomation.gui.container.ContainerCapacitor;
import com.vanhal.progressiveautomation.util.StringHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class GUICapacitor
extends BaseGUI {
    public static final ResourceLocation texture = new ResourceLocation("progressiveautomation", "textures/gui/Capacitor.png");
    protected int infoScreenX = 68;
    protected int infoScreenW = 87;
    protected int infroScreenY1 = 21;
    protected int infroScreenY2 = 31;
    TileCapacitor capacitor;

    public GUICapacitor(InventoryPlayer inv, TileEntity entity) {
        super(new ContainerCapacitor(inv, entity), texture);
        this.capacitor = (TileCapacitor)entity;
        this.setHeight(135);
    }

    @Override
    protected void drawText() {
        this.drawString(StringHelper.localize("gui.capacitor"), 5, GRAY);
        this.drawString(StringHelper.localize("gui.maximum") + ": " + this.capacitor.getTransferRate() + " RF/t", this.infoScreenX, this.infoScreenW, this.infroScreenY1, GREEN);
        if (this.capacitor.getEnergyStored() >= this.capacitor.getMaxEnergyStored()) {
            this.drawString(StringHelper.getScaledNumber(this.capacitor.getEnergyStored(), 100) + " / " + StringHelper.getScaledNumber(this.capacitor.getMaxEnergyStored()) + " RF", this.infoScreenX, this.infoScreenW, this.infroScreenY2, RED);
        } else {
            this.drawString(StringHelper.getScaledNumber(this.capacitor.getEnergyStored(), 100) + " / " + StringHelper.getScaledNumber(this.capacitor.getMaxEnergyStored()) + " RF", this.infoScreenX, this.infoScreenW, this.infroScreenY2, BLUE);
        }
    }
}

