/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.entities.miner;

import com.vanhal.progressiveautomation.entities.UpgradeableTileEntity;
import com.vanhal.progressiveautomation.ref.ToolHelper;
import com.vanhal.progressiveautomation.upgrades.UpgradeType;
import com.vanhal.progressiveautomation.util.Point2I;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeHooks;

public class TileMiner
extends UpgradeableTileEntity {
    protected int totalMineBlocks = -1;
    protected int currentMineBlocks = 0;
    protected int currentColumn = 0;
    protected int currentYLevel = 0;
    protected Block currentBlock = null;
    protected int miningWith = 0;
    protected int blockMineDuration = 0;
    protected int elapsedDuration = 0;
    protected int lastPick = -1;
    protected int lastShovel = -1;
    private int previousUpgrades;

    public TileMiner() {
        super(13);
        this.setUpgradeLevel(0);
        this.setAllowedUpgrades(UpgradeType.WOODEN, UpgradeType.WITHER, UpgradeType.COBBLE_GEN, UpgradeType.FILLER);
        this.SLOT_PICKAXE = 2;
        this.SLOT_SHOVEL = 3;
        this.SLOT_UPGRADE = 4;
    }

    @Override
    public void writeCommonNBT(NBTTagCompound nbt) {
        super.writeCommonNBT(nbt);
        nbt.func_74768_a("MineBlocks", this.totalMineBlocks);
        nbt.func_74768_a("MinedBlocks", this.currentMineBlocks);
    }

    @Override
    public void readCommonNBT(NBTTagCompound nbt) {
        super.readCommonNBT(nbt);
        if (nbt.func_74764_b("MineBlocks")) {
            this.totalMineBlocks = nbt.func_74762_e("MineBlocks");
        }
        if (nbt.func_74764_b("MinedBlocks")) {
            this.currentMineBlocks = nbt.func_74762_e("MinedBlocks");
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.checkForChanges();
            this.checkInventory();
            if (this.isFull()) {
                return;
            }
            if (this.isBurning()) {
                this.useCobbleGen();
                if (!this.isDone()) {
                    this.mine();
                }
            }
        }
    }

    public void scanBlocks() {
        this.currentMineBlocks = 0;
        this.totalMineBlocks = 0;
        for (int i = 1; i <= this.getRange(); ++i) {
            Point2I currentPoint = this.spiral(i, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p());
            boolean bedrock = false;
            int newY = this.field_174879_c.func_177956_o() - 1;
            while (!bedrock) {
                int result = this.canMineBlock(currentPoint.getX(), newY, currentPoint.getY());
                if (result >= 1) {
                    ++this.totalMineBlocks;
                } else if (result == -1) {
                    ++this.totalMineBlocks;
                    ++this.currentMineBlocks;
                }
                if (--newY >= 0) continue;
                bedrock = true;
            }
        }
        this.addPartialUpdate("MineBlocks", this.totalMineBlocks);
        this.addPartialUpdate("MinedBlocks", this.currentMineBlocks);
        this.notifyUpdate();
    }

    public int canMineBlock(int x, int y, int z) {
        BlockPos minePos = new BlockPos(x, y, z);
        IBlockState tryState = this.field_145850_b.func_180495_p(minePos);
        Block tryBlock = tryState.func_177230_c();
        if (tryBlock != null) {
            int meta = tryBlock.func_176201_c(tryState);
            if (tryBlock.func_176195_g(tryState, this.field_145850_b, minePos) >= 0.0f && !tryBlock.isAir(tryState, (IBlockAccess)this.field_145850_b, minePos)) {
                boolean mine = false;
                if (tryBlock == Blocks.field_150347_e) {
                    return -1;
                }
                if (tryBlock.getHarvestTool(tryState) == "chisel") {
                    return 2;
                }
                if (tryBlock.getHarvestTool(tryState) == "pickaxe") {
                    if (ForgeHooks.canToolHarvestBlock((IBlockAccess)this.field_145850_b, (BlockPos)minePos, (ItemStack)this.func_70301_a(2))) {
                        return 2;
                    }
                } else if (tryBlock.getHarvestTool(tryState) == "shovel") {
                    if (ForgeHooks.canToolHarvestBlock((IBlockAccess)this.field_145850_b, (BlockPos)minePos, (ItemStack)this.func_70301_a(3))) {
                        return 3;
                    }
                } else if (!tryBlock.func_149688_o(tryState).func_76224_d()) {
                    return 1;
                }
            }
            if (this.hasUpgrade(UpgradeType.FILLER) && (tryBlock.isAir(tryState, (IBlockAccess)this.field_145850_b, minePos) || tryBlock.func_149688_o(tryState).func_76224_d())) {
                return 4;
            }
        }
        return 0;
    }

    public void mine() {
        if (this.slots[1] == null || this.slots[2] == null || this.slots[3] == null) {
            return;
        }
        if (this.currentBlock != null) {
            if (this.elapsedDuration >= this.blockMineDuration) {
                Point2I currentPoint = this.spiral(this.currentColumn, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p());
                BlockPos currentPosition = new BlockPos(currentPoint.getX(), this.currentYLevel, currentPoint.getY());
                Block testBlock = this.field_145850_b.func_180495_p(currentPosition).func_177230_c();
                if (testBlock != this.currentBlock) {
                    this.currentBlock = testBlock;
                    this.miningWith = this.canMineBlock(currentPosition.func_177958_n(), currentPosition.func_177956_o(), currentPosition.func_177952_p());
                    if (this.miningWith == -1) {
                        this.miningWith = 2;
                    }
                    this.blockMineDuration = this.miningDuration(currentPosition, this.miningWith);
                    if (this.elapsedDuration < this.blockMineDuration) {
                        ++this.elapsedDuration;
                        return;
                    }
                }
                if (this.miningWith != 4) {
                    int i;
                    if (this.field_145850_b.func_175625_s(currentPosition) instanceof IInventory) {
                        IInventory inv = (IInventory)this.field_145850_b.func_175625_s(currentPosition);
                        for (i = 0; i < inv.func_70302_i_(); ++i) {
                            if (inv.func_70301_a(i) == null) continue;
                            this.addToInventory(inv.func_70301_a(i));
                            inv.func_70299_a(i, null);
                        }
                    }
                    int silkTouch = 0;
                    if (this.miningWith != 1) {
                        silkTouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)this.slots[this.miningWith]);
                    }
                    if (silkTouch > 0) {
                        i = 0;
                        Item item = Item.func_150898_a((Block)this.currentBlock);
                        if (item != null && item.func_77614_k()) {
                            i = this.currentBlock.func_176201_c(this.field_145850_b.func_180495_p(currentPosition));
                        }
                        ItemStack addItem = new ItemStack(this.currentBlock, 1, i);
                        this.addToInventory(addItem);
                    } else {
                        int fortuneLevel = 0;
                        if (this.miningWith != 1) {
                            fortuneLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)this.slots[this.miningWith]);
                        }
                        List items = this.currentBlock.getDrops((IBlockAccess)this.field_145850_b, currentPosition, this.field_145850_b.func_180495_p(currentPosition), fortuneLevel);
                        for (ItemStack item : items) {
                            this.addToInventory(item);
                        }
                    }
                    if (this.miningWith != 1 && ToolHelper.damageTool(this.slots[this.miningWith], this.field_145850_b, currentPoint.getX(), this.currentYLevel, currentPoint.getY())) {
                        this.destroyTool(this.miningWith);
                    }
                }
                this.field_145850_b.func_175713_t(currentPosition);
                this.field_145850_b.func_175656_a(currentPosition, Blocks.field_150347_e.func_176223_P());
                --this.slots[1].field_77994_a;
                if (this.slots[1].field_77994_a == 0) {
                    this.slots[1] = null;
                }
                ++this.currentMineBlocks;
                this.addPartialUpdate("MinedBlocks", this.currentMineBlocks);
                this.currentBlock = null;
                this.elapsedDuration = 0;
            } else {
                ++this.elapsedDuration;
            }
        } else if (!this.isDone()) {
            this.currentBlock = this.getNextBlock();
            if (this.currentBlock != null) {
                Point2I currentPoint = this.spiral(this.currentColumn, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p());
                BlockPos currentPosition = new BlockPos(currentPoint.getX(), this.currentYLevel, currentPoint.getY());
                this.blockMineDuration = this.miningDuration(currentPosition, this.miningWith);
            }
        }
        if (this.isDone()) {
            this.scanBlocks();
            this.currentColumn = this.getRange();
        }
    }

    private int miningDuration(BlockPos pos, int tool) {
        int duration = 0;
        IBlockState state = this.field_145850_b.func_180495_p(pos);
        Block block = state.func_177230_c();
        int normal = (int)Math.ceil((double)block.func_176195_g(state, this.field_145850_b, pos) * 1.5 * 20.0);
        switch (tool) {
            case 1: {
                duration = normal;
                break;
            }
            case 2: 
            case 3: {
                float miningSpeed = ToolHelper.getDigSpeed(this.slots[tool], state);
                if (miningSpeed <= 1.0f) {
                    duration = normal;
                    break;
                }
                int eff = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)this.slots[tool]);
                if (eff > 0) {
                    for (int i = 0; i < eff; ++i) {
                        miningSpeed *= 1.3f;
                    }
                }
                duration = (int)Math.ceil((float)normal / miningSpeed);
                break;
            }
            case 4: {
                duration = 1;
                break;
            }
            default: {
                duration = 0;
            }
        }
        return duration;
    }

    public Block getNextBlock() {
        Point2I currentPoint = this.spiral(this.currentColumn, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p());
        this.miningWith = this.canMineBlock(currentPoint.getX(), this.currentYLevel, currentPoint.getY());
        while (this.miningWith <= 0 && this.currentYLevel >= 0) {
            if (this.miningWith > 0) {
                return this.field_145850_b.func_180495_p(new BlockPos(currentPoint.getX(), this.currentYLevel, currentPoint.getY())).func_177230_c();
            }
            --this.currentYLevel;
            if (this.currentYLevel < 0) continue;
            this.miningWith = this.canMineBlock(currentPoint.getX(), this.currentYLevel, currentPoint.getY());
        }
        if (this.miningWith > 0) {
            return this.field_145850_b.func_180495_p(new BlockPos(currentPoint.getX(), this.currentYLevel, currentPoint.getY())).func_177230_c();
        }
        if (this.currentYLevel < 0) {
            this.currentYLevel = this.field_174879_c.func_177956_o() - 1;
            --this.currentColumn;
            if (this.currentColumn < 0) {
                this.scanBlocks();
                this.currentColumn = this.getRange();
            } else {
                return this.getNextBlock();
            }
        }
        return null;
    }

    protected int getCurrentUpgrades() {
        if (this.SLOT_UPGRADE == -1) {
            return 0;
        }
        if (this.func_70301_a(this.SLOT_UPGRADE) == null) {
            return 0;
        }
        return this.func_70301_a((int)this.SLOT_UPGRADE).field_77994_a;
    }

    public int getMinedBlocks() {
        return this.currentMineBlocks;
    }

    public void setMinedBlocks(int value) {
        this.currentMineBlocks = value;
    }

    public int getMineBlocks() {
        return this.totalMineBlocks;
    }

    public void setMineBlocks(int value) {
        this.totalMineBlocks = value;
    }

    public boolean isDone() {
        return this.totalMineBlocks == this.currentMineBlocks && this.totalMineBlocks > 0 && this.slots[this.SLOT_PICKAXE] != null && this.slots[this.SLOT_SHOVEL] != null;
    }

    public void useCobbleGen() {
        if (this.hasUpgrade(UpgradeType.COBBLE_GEN) && (this.slots[1] == null || this.slots[1].field_77994_a == 0) && this.slots[this.SLOT_PICKAXE] != null) {
            if (ToolHelper.damageTool(this.slots[this.SLOT_PICKAXE], this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p())) {
                this.destroyTool(this.SLOT_PICKAXE);
            }
            this.slots[1] = new ItemStack(Blocks.field_150347_e);
        }
    }

    public void checkForChanges() {
        boolean update = false;
        if (this.slots[2] == null && this.lastPick >= 0) {
            this.lastPick = -1;
            update = true;
        } else if (this.slots[2] != null && ToolHelper.getLevel(this.slots[2]) != this.lastPick) {
            this.lastPick = ToolHelper.getLevel(this.slots[2]);
            update = true;
        }
        if (this.slots[3] == null && this.lastShovel >= 0) {
            this.lastShovel = -1;
            update = true;
        } else if (this.slots[3] != null && ToolHelper.getLevel(this.slots[3]) != this.lastShovel) {
            this.lastShovel = ToolHelper.getLevel(this.slots[3]);
            update = true;
        }
        if (this.previousUpgrades != this.getUpgrades()) {
            this.previousUpgrades = this.getUpgrades();
            update = true;
        }
        if (update) {
            this.scanBlocks();
            this.currentColumn = this.getRange();
            this.currentBlock = null;
            this.elapsedDuration = 0;
            this.blockMineDuration = 0;
            this.currentYLevel = this.field_174879_c.func_177956_o() - 1;
        }
    }

    @Override
    public boolean readyToBurn() {
        if (this.totalMineBlocks > 0 && this.currentMineBlocks < this.totalMineBlocks && (this.slots[1] != null || this.hasUpgrade(UpgradeType.COBBLE_GEN)) && this.slots[2] != null && this.slots[3] != null) {
            return true;
        }
        return (this.slots[1] == null || this.slots[1].field_77994_a == 0) && this.hasUpgrade(UpgradeType.COBBLE_GEN) && this.slots[2] != null && this.slots[3] != null;
    }

    @Override
    public int extraSlotCheck(ItemStack item) {
        if (item.func_77969_a(new ItemStack(Blocks.field_150347_e))) {
            return 1;
        }
        return super.extraSlotCheck(item);
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 1 && stack.func_77969_a(new ItemStack(Blocks.field_150347_e))) {
            return true;
        }
        return super.func_94041_b(slot, stack);
    }
}

