/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.entities.killer;

import com.google.common.collect.Multimap;
import com.vanhal.progressiveautomation.PAConfig;
import com.vanhal.progressiveautomation.entities.UpgradeableTileEntity;
import com.vanhal.progressiveautomation.ref.ToolHelper;
import com.vanhal.progressiveautomation.upgrades.UpgradeType;
import com.vanhal.progressiveautomation.util.PlayerFake;
import com.vanhal.progressiveautomation.util.Point2I;
import com.vanhal.progressiveautomation.util.Point3I;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.WorldServer;

public class TileKiller
extends UpgradeableTileEntity {
    protected int searchBlock = -1;
    public int waitTime = 40;
    public int currentTime = 0;
    protected PlayerFake faker;
    protected AxisAlignedBB boundCheck = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public TileKiller() {
        super(11);
        this.setUpgradeLevel(0);
        this.setAllowedUpgrades(UpgradeType.WOODEN, UpgradeType.WITHER, UpgradeType.FILTER_ADULT, UpgradeType.FILTER_ANIMAL, UpgradeType.FILTER_MOB, UpgradeType.FILTER_PLAYER);
        this.setExtDirection(EnumFacing.DOWN);
        this.SLOT_SWORD = 1;
        this.SLOT_UPGRADE = 2;
    }

    public void setAttackTime(int time) {
        this.waitTime = time;
    }

    @Override
    public void writeCommonNBT(NBTTagCompound nbt) {
        super.writeCommonNBT(nbt);
        nbt.func_74768_a("currentTime", this.currentTime);
        nbt.func_74768_a("currentBlock", this.searchBlock);
    }

    @Override
    public void readCommonNBT(NBTTagCompound nbt) {
        super.readCommonNBT(nbt);
        if (nbt.func_74764_b("currentTime")) {
            this.currentTime = nbt.func_74762_e("currentTime");
        }
        if (nbt.func_74764_b("currentBlock")) {
            this.searchBlock = nbt.func_74762_e("currentBlock");
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.doXpPickup();
            this.checkInventory();
            if (this.isFull()) {
                return;
            }
            if (this.isBurning()) {
                if (this.currentTime > 0) {
                    --this.currentTime;
                } else if (this.searchBlock > -1) {
                    EntityLivingBase mob = this.getMob(this.searchBlock);
                    if (mob == null) {
                        this.searchBlock = -1;
                        this.addPartialUpdate("currentBlock", this.searchBlock);
                    } else if (this.slots[this.SLOT_SWORD] != null) {
                        if (this.faker == null) {
                            this.faker = new PlayerFake((WorldServer)this.field_145850_b, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c().func_149732_F());
                            this.faker.func_70107_b(0.0, 0.0, 0.0);
                        }
                        this.faker.setItemInHand(this.slots[this.SLOT_SWORD].func_77946_l());
                        Multimap attributeModifiers = this.slots[this.SLOT_SWORD].func_111283_C(EntityEquipmentSlot.MAINHAND);
                        attributeModifiers.get((Object)SharedMonsterAttributes.field_188790_f.func_111108_a());
                        this.faker.setItemInUse(this.faker.func_184614_ca(), 72000);
                        this.faker.func_70071_h_();
                        this.faker.func_71059_n((Entity)mob);
                        if (ToolHelper.damageTool(this.slots[this.SLOT_SWORD], this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p())) {
                            this.destroyTool(this.SLOT_SWORD);
                        }
                        this.pickupDrops(this.searchBlock);
                        this.currentTime = this.waitTime;
                        this.addPartialUpdate("currentTime", this.currentTime);
                    } else {
                        this.searchBlock = -1;
                        this.addPartialUpdate("currentBlock", this.searchBlock);
                    }
                } else {
                    this.doSearch();
                }
            }
        }
    }

    public void doXpPickup() {
        for (int i = 0; i < this.getRange(); ++i) {
            this.pickupXP(i);
        }
    }

    public boolean doSearch() {
        if (this.searchBlock >= 0) {
            return true;
        }
        for (int i = 0; i < this.getRange(); ++i) {
            if (this.getMob(i) == null) continue;
            this.searchBlock = i;
            this.addPartialUpdate("currentBlock", this.searchBlock);
            return true;
        }
        return false;
    }

    public EntityLivingBase getMob(int n) {
        Point3I point = this.getPoint(n);
        this.boundCheck = new AxisAlignedBB((double)point.getX(), (double)(point.getY() - 1), (double)point.getZ(), (double)(point.getX() + 1), (double)(point.getY() + 2), (double)(point.getZ() + 1));
        List entities = this.field_145850_b.func_72872_a(EntityLivingBase.class, this.boundCheck);
        if (!entities.isEmpty()) {
            for (EntityLivingBase mob : entities) {
                if (mob instanceof EntityPlayer) {
                    if (!PAConfig.allowKillPlayer) continue;
                    if (this.hasFilterInstalled()) {
                        if (!this.hasUpgrade(UpgradeType.FILTER_PLAYER)) continue;
                        return mob;
                    }
                    return mob;
                }
                if (this.hasFilterInstalled()) {
                    if (this.hasUpgrade(UpgradeType.FILTER_ANIMAL) && mob instanceof IAnimals) {
                        if (this.hasUpgrade(UpgradeType.FILTER_ADULT)) {
                            if (!mob.func_70631_g_()) {
                                return mob;
                            }
                        } else {
                            return mob;
                        }
                    }
                    if (this.hasUpgrade(UpgradeType.FILTER_MOB) && mob instanceof IMob) {
                        if (this.hasUpgrade(UpgradeType.FILTER_ADULT)) {
                            if (!mob.func_70631_g_()) {
                                return mob;
                            }
                        } else {
                            return mob;
                        }
                    }
                    if (this.hasUpgrade(UpgradeType.FILTER_MOB) || this.hasUpgrade(UpgradeType.FILTER_ANIMAL) || !this.hasUpgrade(UpgradeType.FILTER_ADULT) || mob.func_70631_g_()) continue;
                    return mob;
                }
                return mob;
            }
        }
        return null;
    }

    public void pickupDrops(int n) {
        Point3I point = this.getPoint(n);
        this.boundCheck = new AxisAlignedBB((double)point.getX(), (double)point.getY(), (double)point.getZ(), (double)(point.getX() + 1), (double)(point.getY() + 2), (double)(point.getZ() + 1));
        List entities = this.field_145850_b.func_72872_a(EntityItem.class, this.boundCheck);
        if (!entities.isEmpty()) {
            for (EntityItem item : entities) {
                if (!this.roomInInventory(item.func_92059_d())) continue;
                if (!this.field_145850_b.field_72995_K) {
                    this.addToInventory(item.func_92059_d());
                }
                this.field_145850_b.func_72900_e((Entity)item);
            }
        }
    }

    public void pickupXP(int n) {
        Point3I point = this.getPoint(n);
        this.boundCheck = new AxisAlignedBB((double)point.getX(), (double)point.getY(), (double)point.getZ(), (double)(point.getX() + 1), (double)(point.getY() + 2), (double)(point.getZ() + 1));
        List entities = this.field_145850_b.func_72872_a(EntityXPOrb.class, this.boundCheck);
        if (!entities.isEmpty()) {
            for (EntityXPOrb item : entities) {
                this.field_145850_b.func_72900_e((Entity)item);
            }
        }
    }

    public boolean hasFilterInstalled() {
        if (this.hasUpgrade(UpgradeType.FILTER_ADULT)) {
            return true;
        }
        if (this.hasUpgrade(UpgradeType.FILTER_ANIMAL)) {
            return true;
        }
        if (this.hasUpgrade(UpgradeType.FILTER_MOB)) {
            return true;
        }
        return this.hasUpgrade(UpgradeType.FILTER_PLAYER);
    }

    protected Point3I getPoint(int n) {
        Point2I p1 = this.spiral(n + 1, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p());
        return new Point3I(p1.getX(), this.field_174879_c.func_177956_o() + 1, p1.getY());
    }

    @Override
    public boolean readyToBurn() {
        return this.slots[this.SLOT_SWORD] != null && this.doSearch();
    }

    public boolean isKilling() {
        return this.searchBlock > -1;
    }

    @Override
    protected Point3I adjustedSpiral(int n) {
        Point3I point = super.adjustedSpiral(n);
        point.setY(point.getY() + 1);
        return point;
    }
}

