/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.entities.generator;

import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyReceiver;
import com.vanhal.progressiveautomation.PAConfig;
import com.vanhal.progressiveautomation.entities.BaseTileEntity;
import com.vanhal.progressiveautomation.ref.WrenchModes;
import com.vanhal.progressiveautomation.util.Point2I;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileGenerator
extends BaseTileEntity {
    protected float fireRisk = 0.02f;
    protected int maxStorage = 10000;
    protected int currentStorage = 0;
    protected int generationRate = 10;
    protected int consumeRate = 1;
    protected boolean burnUpdate = false;
    public int SLOT_CHARGER = 1;

    public TileGenerator() {
        super(1);
        this.setEnergyStorage(20000, 0.5f);
        this.sides[this.extDirection.ordinal()] = WrenchModes.Mode.Normal;
    }

    @Override
    public void writeCommonNBT(NBTTagCompound nbt) {
        super.writeCommonNBT(nbt);
        nbt.func_74768_a("energy", this.currentStorage);
        this.sides[this.extDirection.ordinal()] = WrenchModes.Mode.Normal;
    }

    @Override
    public void readCommonNBT(NBTTagCompound nbt) {
        super.readCommonNBT(nbt);
        if (nbt.func_74764_b("energy")) {
            this.currentStorage = nbt.func_74762_e("energy");
        }
    }

    public void setFireChance(float chance) {
        this.fireRisk = chance;
    }

    public void setEnergyStorage(int size, float rate) {
        this.maxStorage = size;
        this.generationRate = (int)((float)PAConfig.rfCost * rate);
        this.consumeRate = (int)((float)PAConfig.fuelCost * rate);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            int giveAmount;
            IEnergyContainerItem container;
            if (this.isBurning()) {
                this.changeCharge(this.generationRate);
                this.checkForFire();
            }
            if (this.slots[this.SLOT_CHARGER] != null && this.currentStorage > 0 && this.slots[this.SLOT_CHARGER].func_77973_b() instanceof IEnergyContainerItem && (container = (IEnergyContainerItem)this.slots[this.SLOT_CHARGER].func_77973_b()).getEnergyStored(this.slots[this.SLOT_CHARGER]) < container.getMaxEnergyStored(this.slots[this.SLOT_CHARGER]) && (giveAmount = container.receiveEnergy(this.slots[this.SLOT_CHARGER], this.currentStorage, false)) > 0) {
                this.changeCharge(giveAmount * -1);
            }
            this.outputEnergy();
        } else {
            this.checkUpdate();
        }
    }

    protected void checkUpdate() {
        if (this.isBurning() != this.burnUpdate) {
            this.burnUpdate = this.isBurning();
            this.field_145850_b.func_180496_d(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        }
    }

    protected void checkForFire() {
        if (this.fireRisk > this.field_145850_b.field_73012_v.nextFloat()) {
            int n = (int)Math.floor(8.0f * this.field_145850_b.field_73012_v.nextFloat()) + 1;
            Point2I p2 = this.spiral(n, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p());
            BlockPos supportPos = new BlockPos(p2.getX(), this.field_174879_c.func_177956_o() - 1, p2.getY());
            BlockPos firePos = new BlockPos(p2.getX(), this.field_174879_c.func_177956_o(), p2.getY());
            Block supportBlock = this.field_145850_b.func_180495_p(supportPos).func_177230_c();
            IBlockState fireState = this.field_145850_b.func_180495_p(firePos);
            Block fireBlock = fireState.func_177230_c();
            if (fireBlock.isAir(fireState, (IBlockAccess)this.field_145850_b, firePos) && supportBlock.isFlammable((IBlockAccess)this.field_145850_b, supportPos, EnumFacing.UP)) {
                this.field_145850_b.func_175656_a(firePos, Blocks.field_150480_ab.func_176223_P());
            }
        }
    }

    @Override
    public boolean readyToBurn() {
        return this.currentStorage < this.maxStorage;
    }

    public int getProduceRate() {
        return this.generationRate;
    }

    @Override
    public int getBurnTime(ItemStack item) {
        return TileGenerator.getItemBurnTime(item) / this.consumeRate;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return 0;
    }

    @Override
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        int energyExtracted = Math.min(this.currentStorage, maxExtract);
        if (!simulate) {
            this.changeCharge(energyExtracted * -1);
        }
        return energyExtracted;
    }

    public void changeCharge(int amount) {
        int prevAmount = this.currentStorage;
        this.currentStorage += amount;
        if (this.currentStorage >= this.maxStorage) {
            this.currentStorage = this.maxStorage;
        }
        if (this.currentStorage < 0) {
            this.currentStorage = 0;
        }
        if (this.currentStorage != prevAmount) {
            this.addPartialUpdate("energy", this.currentStorage);
        }
    }

    @Override
    public int getEnergyStored(EnumFacing facing) {
        return this.getEnergyStored();
    }

    @Override
    public int getEnergyStored() {
        return this.currentStorage;
    }

    @Override
    public int getMaxEnergyStored(EnumFacing facing) {
        return this.getMaxEnergyStored();
    }

    @Override
    public int getMaxEnergyStored() {
        return this.maxStorage;
    }

    public void outputEnergy() {
        for (EnumFacing facing : EnumFacing.values()) {
            int giveAmount;
            IEnergyReceiver energy;
            TileEntity entity;
            if (this.currentStorage <= 0 || (entity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing))) == null) continue;
            if (entity.hasCapability(CapabilityEnergy.ENERGY, facing.func_176734_d())) {
                energy = (IEnergyStorage)entity.getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d());
                if (!energy.canReceive() || (giveAmount = energy.receiveEnergy(this.currentStorage, false)) <= 0) continue;
                this.changeCharge(giveAmount * -1);
                continue;
            }
            if (!(entity instanceof IEnergyReceiver) || !(energy = (IEnergyReceiver)entity).canConnectEnergy(facing.func_176734_d()) || (giveAmount = energy.receiveEnergy(facing.func_176734_d(), this.currentStorage, false)) <= 0) continue;
            this.changeCharge(giveAmount * -1);
        }
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return super.func_94041_b(slot, stack);
    }
}

