/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.entities.farmer;

import com.vanhal.progressiveautomation.entities.UpgradeableTileEntity;
import com.vanhal.progressiveautomation.ref.ToolHelper;
import com.vanhal.progressiveautomation.upgrades.UpgradeType;
import com.vanhal.progressiveautomation.util.PlayerFake;
import com.vanhal.progressiveautomation.util.Point2I;
import com.vanhal.progressiveautomation.util.Point3I;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.IShearable;

public class TileFarmer
extends UpgradeableTileEntity {
    public int SLOT_FOOD;
    public int SLOT_SHEARS;
    public int SLOT_BUCKETS;
    public int waitTime = 80;
    public int currentTime = 0;
    protected int searchBlock = -1;
    protected PlayerFake faker;
    protected int currentAction = 0;
    protected AxisAlignedBB boundCheck = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public TileFarmer() {
        super(13);
        this.setUpgradeLevel(0);
        this.setAllowedUpgrades(UpgradeType.WOODEN, UpgradeType.WITHER, UpgradeType.MILKER, UpgradeType.SHEARING);
        this.SLOT_UPGRADE = 1;
        this.SLOT_FOOD = 2;
        this.SLOT_SHEARS = 3;
        this.SLOT_BUCKETS = 4;
    }

    public void setWaitTime(int time) {
        this.waitTime = time;
    }

    public int getCurrentAction() {
        return this.currentAction;
    }

    @Override
    protected void writeSyncOnlyNBT(NBTTagCompound nbt) {
        super.writeSyncOnlyNBT(nbt);
        nbt.func_74768_a("currentAction", this.currentAction);
    }

    @Override
    public void readSyncOnlyNBT(NBTTagCompound nbt) {
        super.readSyncOnlyNBT(nbt);
        if (nbt.func_74764_b("currentAction")) {
            this.currentAction = nbt.func_74762_e("currentAction");
        }
    }

    @Override
    public void writeCommonNBT(NBTTagCompound nbt) {
        super.writeCommonNBT(nbt);
        nbt.func_74768_a("currentTime", this.currentTime);
        nbt.func_74768_a("currentBlock", this.searchBlock);
    }

    @Override
    public void readCommonNBT(NBTTagCompound nbt) {
        super.readCommonNBT(nbt);
        if (nbt.func_74764_b("currentTime")) {
            this.currentTime = nbt.func_74762_e("currentTime");
        }
        if (nbt.func_74764_b("currentBlock")) {
            this.searchBlock = nbt.func_74762_e("currentBlock");
        }
    }

    public boolean doSearch() {
        int i;
        if (this.searchBlock >= 0) {
            return true;
        }
        if (this.slots[this.SLOT_FOOD] != null) {
            for (i = 0; i < this.getRange(); ++i) {
                if (this.findAnimalToFeed(i) == null) continue;
                this.searchBlock = i;
                this.addPartialUpdate("currentBlock", this.searchBlock);
                this.currentAction = 1;
                this.addPartialUpdate("currentAction", this.currentAction);
                return true;
            }
        }
        if (this.hasUpgrade(UpgradeType.SHEARING) && this.slots[this.SLOT_SHEARS] != null) {
            for (i = 0; i < this.getRange(); ++i) {
                if (this.findAnimalToShear(i) == null) continue;
                this.searchBlock = i;
                this.addPartialUpdate("currentBlock", this.searchBlock);
                this.currentAction = 2;
                this.addPartialUpdate("currentAction", this.currentAction);
                return true;
            }
        }
        if (this.hasUpgrade(UpgradeType.MILKER) && this.slots[this.SLOT_BUCKETS] != null && this.slots[this.SLOT_BUCKETS].field_77994_a > 0) {
            for (i = 0; i < this.getRange(); ++i) {
                if (this.findAnimalToMilk(i) == null) continue;
                this.searchBlock = i;
                this.addPartialUpdate("currentBlock", this.searchBlock);
                this.currentAction = 3;
                this.addPartialUpdate("currentAction", this.currentAction);
                return true;
            }
        }
        this.currentAction = 0;
        this.addPartialUpdate("currentAction", this.currentAction);
        return false;
    }

    protected EntityAnimal findAnimalToFeed(int n) {
        Point3I point = this.getPoint(n);
        this.boundCheck = new AxisAlignedBB((double)point.getX(), (double)(point.getY() - 1), (double)point.getZ(), (double)(point.getX() + 1), (double)(point.getY() + 2), (double)(point.getZ() + 1));
        List entities = this.field_145850_b.func_72872_a(EntityAnimal.class, this.boundCheck);
        if (!entities.isEmpty()) {
            for (EntityAnimal animal : entities) {
                if (this.slots[this.SLOT_FOOD] == null || !animal.func_70877_b(this.slots[this.SLOT_FOOD]) || animal.func_70874_b() != 0 || animal.func_70880_s()) continue;
                return animal;
            }
        }
        return null;
    }

    protected EntityAnimal findAnimalToShear(int n) {
        if (!this.hasUpgrade(UpgradeType.SHEARING)) {
            return null;
        }
        Point3I point = this.getPoint(n);
        this.boundCheck = new AxisAlignedBB((double)point.getX(), (double)(point.getY() - 1), (double)point.getZ(), (double)(point.getX() + 1), (double)(point.getY() + 2), (double)(point.getZ() + 1));
        List entities = this.field_145850_b.func_72872_a(EntityAnimal.class, this.boundCheck);
        if (!entities.isEmpty()) {
            for (EntityAnimal animal : entities) {
                if (this.slots[this.SLOT_SHEARS] == null || !(animal instanceof IShearable) || !((IShearable)animal).isShearable(this.slots[this.SLOT_SHEARS], (IBlockAccess)this.field_145850_b, point.toPosition())) continue;
                return animal;
            }
        }
        return null;
    }

    protected EntityAnimal findAnimalToMilk(int n) {
        if (!this.hasUpgrade(UpgradeType.MILKER)) {
            return null;
        }
        Point3I point = this.getPoint(n);
        this.boundCheck = new AxisAlignedBB((double)point.getX(), (double)(point.getY() - 1), (double)point.getZ(), (double)(point.getX() + 1), (double)(point.getY() + 2), (double)(point.getZ() + 1));
        List entities = this.field_145850_b.func_72872_a(EntityAnimal.class, this.boundCheck);
        if (!entities.isEmpty()) {
            for (EntityAnimal animal : entities) {
                int coolDown;
                if (this.slots[this.SLOT_BUCKETS] == null || this.slots[this.SLOT_BUCKETS].field_77994_a <= 0 || !(animal instanceof EntityCow)) continue;
                NBTTagCompound cowTag = new NBTTagCompound();
                animal.func_70014_b(cowTag);
                if (cowTag.func_74764_b("CurrentUseCooldown")) {
                    coolDown = cowTag.func_74762_e("CurrentUseCooldown");
                    if (coolDown > 0) continue;
                    return animal;
                }
                if (cowTag.func_74764_b("NextUseCooldown")) {
                    coolDown = cowTag.func_74762_e("NextUseCooldown");
                    if (coolDown > 0) continue;
                    return animal;
                }
                this.initFaker();
                this.faker.setItemInHand(this.slots[this.SLOT_BUCKETS].func_77946_l());
                if (!animal.func_184645_a((EntityPlayer)this.faker, EnumHand.MAIN_HAND, this.faker.func_184614_ca())) continue;
                return animal;
            }
        }
        return null;
    }

    public void pickup(int n) {
        Point3I point = this.getPoint(n);
        this.boundCheck = new AxisAlignedBB((double)point.getX(), (double)point.getY(), (double)point.getZ(), (double)(point.getX() + 1), (double)(point.getY() + 2), (double)(point.getZ() + 1));
        List entities = this.field_145850_b.func_72872_a(Entity.class, this.boundCheck);
        if (!entities.isEmpty()) {
            for (Entity item : entities) {
                if (item instanceof EntityXPOrb) {
                    this.field_145850_b.func_72900_e(item);
                    continue;
                }
                if (!(item instanceof EntityItem) || ((EntityItem)item).func_92059_d().func_77973_b() != Items.field_151110_aK || !this.roomInInventory(((EntityItem)item).func_92059_d())) continue;
                if (!this.field_145850_b.field_72995_K) {
                    this.addToInventory(((EntityItem)item).func_92059_d());
                }
                this.field_145850_b.func_72900_e(item);
            }
        }
    }

    public void doPickup() {
        for (int i = 0; i < this.getRange(); ++i) {
            this.pickup(i);
        }
    }

    protected Point3I getPoint(int n) {
        Point2I p1 = this.spiral(n + 2, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p());
        return new Point3I(p1.getX(), this.field_174879_c.func_177956_o(), p1.getY());
    }

    @Override
    public boolean readyToBurn() {
        return this.doSearch();
    }

    protected void initFaker() {
        if (this.faker == null) {
            this.faker = new PlayerFake((WorldServer)this.field_145850_b, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c().func_149732_F());
            this.faker.func_70107_b(0.0, 0.0, 0.0);
        }
        this.faker.field_71071_by.func_174888_l();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.doPickup();
            this.checkInventory();
            if (this.isFull()) {
                return;
            }
            if (this.isBurning()) {
                if (this.currentTime > 0) {
                    --this.currentTime;
                } else if (this.searchBlock > -1) {
                    this.initFaker();
                    EntityAnimal animal = this.findAnimalToFeed(this.searchBlock);
                    if (animal != null) {
                        this.feedAnimal(animal);
                    } else {
                        animal = this.findAnimalToShear(this.searchBlock);
                        if (animal != null) {
                            this.shearAnimal(animal);
                        } else {
                            animal = this.findAnimalToMilk(this.searchBlock);
                            if (animal != null) {
                                this.milkAnimal(animal);
                            } else {
                                this.searchBlock = -1;
                                this.addPartialUpdate("currentBlock", this.searchBlock);
                            }
                        }
                    }
                } else {
                    this.doSearch();
                }
            }
        }
    }

    protected void feedAnimal(EntityAnimal animal) {
        if (this.slots[this.SLOT_FOOD] != null) {
            animal.func_146082_f((EntityPlayer)this.faker);
            --this.slots[this.SLOT_FOOD].field_77994_a;
            if (this.slots[this.SLOT_FOOD].field_77994_a == 0) {
                this.slots[this.SLOT_FOOD] = null;
            }
            this.currentTime = this.waitTime;
            this.addPartialUpdate("currentTime", this.currentTime);
        }
    }

    protected void shearAnimal(EntityAnimal animal) {
        if (this.slots[this.SLOT_SHEARS] != null && this.hasUpgrade(UpgradeType.SHEARING) && animal instanceof IShearable) {
            int fortuneLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantment.func_180305_b((String)"fortune"), (ItemStack)this.slots[this.SLOT_SHEARS]);
            List items = ((IShearable)animal).onSheared(this.slots[this.SLOT_SHEARS], (IBlockAccess)this.field_145850_b, this.field_174879_c, fortuneLevel);
            for (ItemStack item : items) {
                this.addToInventory(item);
            }
            if (ToolHelper.damageTool(this.slots[this.SLOT_SHEARS], this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p())) {
                this.destroyTool(this.SLOT_SHEARS);
            }
            this.currentTime = this.waitTime;
            this.addPartialUpdate("currentTime", this.currentTime);
        }
    }

    protected void milkAnimal(EntityAnimal animal) {
        if (this.slots[this.SLOT_BUCKETS] != null && this.hasUpgrade(UpgradeType.MILKER)) {
            this.initFaker();
            ItemStack item = this.slots[this.SLOT_BUCKETS].func_77946_l();
            item.field_77994_a = 1;
            this.faker.setItemInHand(item);
            if (animal.func_184645_a((EntityPlayer)this.faker, EnumHand.MAIN_HAND, this.faker.func_184614_ca())) {
                InventoryPlayer inv = this.faker.field_71071_by;
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    if (inv.func_70301_a(i) == null) continue;
                    this.addToInventory(inv.func_70301_a(i));
                    inv.func_70299_a(i, null);
                }
                --this.slots[this.SLOT_BUCKETS].field_77994_a;
                if (this.slots[this.SLOT_BUCKETS].field_77994_a == 0) {
                    this.slots[this.SLOT_BUCKETS] = null;
                }
                this.currentTime = this.waitTime;
                this.addPartialUpdate("currentTime", this.currentTime);
            }
        }
    }

    public static boolean isFeed(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        if (itemStack.func_77973_b() == null) {
            return false;
        }
        if (itemStack.func_77973_b() == Items.field_151015_O) {
            return true;
        }
        if (itemStack.func_77973_b() == Items.field_151014_N) {
            return true;
        }
        return itemStack.func_77973_b() == Items.field_151172_bF;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (slot == this.SLOT_FOOD) {
            if (TileFarmer.isFeed(stack)) {
                return true;
            }
        }
        if (slot == this.SLOT_SHEARS && stack.func_77973_b() == Items.field_151097_aZ && this.hasUpgrade(UpgradeType.SHEARING)) {
            return true;
        }
        if (slot == this.SLOT_BUCKETS && stack.func_77973_b() == Items.field_151133_ar && this.hasUpgrade(UpgradeType.MILKER)) {
            return true;
        }
        return super.func_94041_b(slot, stack);
    }

    @Override
    protected Point3I adjustedSpiral(int n) {
        Point3I point = super.adjustedSpiral(n + 1);
        return point;
    }
}

