/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.entities.capacitor;

import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyReceiver;
import com.vanhal.progressiveautomation.PAConfig;
import com.vanhal.progressiveautomation.entities.BaseTileEntity;
import com.vanhal.progressiveautomation.ref.WrenchModes;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileCapacitor
extends BaseTileEntity {
    protected int transferRate = 10;
    protected int maxStorage = 10000;
    protected int currentStorage = 0;
    public int SLOT_CHARGER = 1;

    public TileCapacitor() {
        super(1);
        this.setEnergyStorage(5000 * PAConfig.rfStorageFactor, 80);
        this.sides[this.extDirection.ordinal()] = WrenchModes.Mode.Normal;
    }

    @Override
    public void writeCommonNBT(NBTTagCompound nbt) {
        super.writeCommonNBT(nbt);
        nbt.func_74768_a("energy", this.currentStorage);
        this.sides[this.extDirection.ordinal()] = WrenchModes.Mode.Normal;
    }

    @Override
    public void readCommonNBT(NBTTagCompound nbt) {
        super.readCommonNBT(nbt);
        if (nbt.func_74764_b("energy")) {
            this.currentStorage = nbt.func_74762_e("energy");
        }
    }

    public void setEnergyStorage(int size, int rate) {
        this.maxStorage = size;
        this.transferRate = rate;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            int giveAmount;
            IEnergyContainerItem container;
            if (this.slots[this.SLOT_CHARGER] != null && this.currentStorage > 0 && this.slots[this.SLOT_CHARGER].func_77973_b() instanceof IEnergyContainerItem && (container = (IEnergyContainerItem)this.slots[this.SLOT_CHARGER].func_77973_b()).getEnergyStored(this.slots[this.SLOT_CHARGER]) < container.getMaxEnergyStored(this.slots[this.SLOT_CHARGER]) && (giveAmount = container.receiveEnergy(this.slots[this.SLOT_CHARGER], this.currentStorage, false)) > 0) {
                this.changeCharge(giveAmount * -1);
            }
            if (this.field_145850_b.func_175651_c(this.field_174879_c, EnumFacing.UP) == 0 || this.field_145850_b.func_175651_c(this.field_174879_c, EnumFacing.DOWN) == 0 || this.field_145850_b.func_175651_c(this.field_174879_c, EnumFacing.NORTH) == 0 || this.field_145850_b.func_175651_c(this.field_174879_c, EnumFacing.SOUTH) == 0 || this.field_145850_b.func_175651_c(this.field_174879_c, EnumFacing.WEST) == 0 || this.field_145850_b.func_175651_c(this.field_174879_c, EnumFacing.EAST) == 0) {
                this.outputEnergy();
            }
        }
    }

    public int getTransferRate() {
        return this.transferRate;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        int energyReceived = 0;
        if (!(from.func_176734_d().func_176745_a() != this.func_145832_p() || this.currentStorage + maxReceive > this.maxStorage && this.currentStorage + this.transferRate > this.maxStorage || simulate)) {
            energyReceived = maxReceive > this.transferRate ? this.transferRate : maxReceive;
            this.changeCharge(energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        int energyExtracted = Math.min(this.currentStorage, maxExtract);
        if (from.func_176734_d().func_176745_a() != this.func_145832_p() - 1 && !simulate) {
            this.changeCharge(energyExtracted * -1);
        }
        return energyExtracted;
    }

    public void changeCharge(int amount) {
        int prevAmount = this.currentStorage;
        this.currentStorage += amount;
        if (this.currentStorage >= this.maxStorage) {
            this.currentStorage = this.maxStorage;
        }
        if (this.currentStorage < 0) {
            this.currentStorage = 0;
        }
        if (this.currentStorage != prevAmount) {
            this.addPartialUpdate("energy", this.currentStorage);
        }
    }

    @Override
    public int getEnergyStored(EnumFacing facing) {
        return this.getEnergyStored();
    }

    @Override
    public int getEnergyStored() {
        return this.currentStorage;
    }

    @Override
    public int getMaxEnergyStored(EnumFacing facing) {
        return this.getMaxEnergyStored();
    }

    @Override
    public int getMaxEnergyStored() {
        return this.maxStorage;
    }

    public void outputEnergy() {
        for (EnumFacing facing : EnumFacing.values()) {
            int giveAmount;
            IEnergyReceiver energy;
            TileEntity entity;
            if (this.currentStorage <= 0 || (entity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing))) == null) continue;
            if (entity.hasCapability(CapabilityEnergy.ENERGY, facing.func_176734_d())) {
                energy = (IEnergyStorage)entity.getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d());
                if (!energy.canReceive() || (giveAmount = energy.receiveEnergy(this.currentStorage, false)) <= 0) continue;
                this.changeCharge(giveAmount * -1);
                continue;
            }
            if (!(entity instanceof IEnergyReceiver) || !(energy = (IEnergyReceiver)entity).canConnectEnergy(facing.func_176734_d()) || (giveAmount = energy.receiveEnergy(facing.func_176734_d(), this.currentStorage, false)) <= 0) continue;
            this.changeCharge(giveAmount * -1);
        }
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return super.func_94041_b(slot, stack);
    }
}

