/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.compat.mods;

import com.vanhal.progressiveautomation.compat.mods.Vanilla;
import com.vanhal.progressiveautomation.util.PlayerFake;
import com.vanhal.progressiveautomation.util.Point3I;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.IPlantable;

public class AgriCraft
extends Vanilla {
    private PlayerFake faker = null;

    public AgriCraft() {
        this.modID = "agricraft";
    }

    @Override
    public boolean shouldLoad() {
        return this.checkModLoad();
    }

    @Override
    public boolean isPlantible(ItemStack item) {
        if (item.func_77973_b() instanceof IPlantable) {
            return true;
        }
        return item != null && item.func_77973_b() != null && item.func_77973_b().toString().contains("ItemAgriSeed");
    }

    @Override
    public boolean isPlant(Block plantBlock, IBlockState state) {
        return super.isPlant(plantBlock, state) && ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)plantBlock)).func_110624_b().equals(this.modID);
    }

    @Override
    protected IBlockState getPlantBlock(World worldObj, ItemStack itemStack, Point3I point) {
        if (this.isPlantible(itemStack)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return null;
    }

    @Override
    public boolean validBlock(World worldObj, ItemStack itemStack, Point3I point) {
        TileEntity tile;
        IBlockState plant = this.getPlantBlock(worldObj, itemStack, point);
        if (plant != null && (tile = worldObj.func_175625_s(point.toPosition())) != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tile.func_189515_b(tag);
            if (tag.func_74764_b("agri_cross_crop") && !tag.func_74764_b("agri_seed") && !tag.func_74767_n("agri_cross_crop")) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean placeSeed(World worldObj, ItemStack itemStack, Point3I point, boolean doAction) {
        IBlockState block = worldObj.func_180495_p(point.toPosition());
        Block actualBlock = block.func_177230_c();
        if (actualBlock != null) {
            if (doAction) {
                PlayerFake faker = new PlayerFake((WorldServer)worldObj);
                faker.field_71071_by.func_70299_a(1, itemStack.func_77946_l());
                faker.setItemInHand(1);
                faker.func_70107_b(point.getX(), point.getY(), point.getZ());
                actualBlock.func_180639_a(worldObj, point.toPosition(), block, (EntityPlayer)faker, EnumHand.MAIN_HAND, faker.field_71071_by.func_70301_a(1), EnumFacing.UP, 0.0f, 0.0f, 0.0f);
                if (faker.field_71071_by.func_70301_a(1) != null && faker.field_71071_by.func_70301_a((int)1).field_77994_a == itemStack.field_77994_a) {
                    faker = null;
                    return false;
                }
                faker = null;
            }
            return true;
        }
        return false;
    }

    @Override
    public List<ItemStack> harvestPlant(Point3I plantPoint, Block plantBlock, IBlockState state, World worldObj) {
        PlayerFake faker = new PlayerFake((WorldServer)worldObj);
        plantBlock.func_180639_a(worldObj, plantPoint.toPosition(), state, (EntityPlayer)faker, EnumHand.MAIN_HAND, null, EnumFacing.UP, 0.0f, 0.0f, 0.0f);
        AxisAlignedBB block = new AxisAlignedBB((double)plantPoint.getX(), (double)plantPoint.getY(), (double)plantPoint.getZ(), (double)(plantPoint.getX() + 1), (double)(plantPoint.getY() + 1), (double)(plantPoint.getZ() + 1));
        List entities = worldObj.func_72872_a(EntityItem.class, block);
        if (entities.isEmpty()) {
            return null;
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (EntityItem item : entities) {
            items.add(item.func_92059_d());
            worldObj.func_72900_e((Entity)item);
        }
        return items;
    }
}

