/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.blocks;

import com.vanhal.progressiveautomation.ProgressiveAutomation;
import com.vanhal.progressiveautomation.entities.BaseTileEntity;
import com.vanhal.progressiveautomation.entities.UpgradeableTileEntity;
import com.vanhal.progressiveautomation.items.ItemBlockMachine;
import com.vanhal.progressiveautomation.items.PAItems;
import com.vanhal.progressiveautomation.upgrades.UpgradeRegistry;
import com.vanhal.progressiveautomation.upgrades.UpgradeType;
import com.vanhal.progressiveautomation.util.IDismantleable;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class BaseBlock
extends BlockContainer
implements IDismantleable {
    public String name;
    public String machineType;
    public int GUIid = -1;
    protected int rangeCount = -1;
    protected int blockLevel = 0;

    public static String returnLevelName(int level) {
        if (level == 1) {
            return "Stone";
        }
        if (level == 2) {
            return "Iron";
        }
        if (level == 3) {
            return "Diamond";
        }
        return "";
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (this.blockLevel == 0) {
            return 5;
        }
        return 0;
    }

    public BaseBlock(String machineType, int level) {
        super(Material.field_151573_f);
        this.machineType = machineType;
        this.name = machineType + BaseBlock.returnLevelName(level);
        this.func_149663_c(this.name);
        this.func_149711_c(1.0f);
        this.func_149647_a(ProgressiveAutomation.PATab);
        this.blockLevel = level;
        this.GUIid = ProgressiveAutomation.proxy.registerGui(machineType);
    }

    public String getLevelName() {
        String thisName = BaseBlock.returnLevelName(this.blockLevel);
        if (thisName == "") {
            thisName = "Wooden";
        }
        return thisName;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (heldItem != null && heldItem.func_77973_b() != null && heldItem.func_77973_b() == PAItems.wrench) {
            return false;
        }
        if (!world.field_72995_K && this.GUIid >= 0 && !(player instanceof FakePlayer)) {
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)ProgressiveAutomation.instance, (int)this.GUIid, (World)world, (int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p());
        }
        return true;
    }

    public TileEntity func_149915_a(World world, int var2) {
        return null;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        BaseTileEntity tileEntity = (BaseTileEntity)world.func_175625_s(pos);
        if (tileEntity != null) {
            ArrayList<ItemStack> items = this.getInsides(world, pos);
            for (ItemStack item : items) {
                this.dumpItems(world, pos, item);
            }
        }
        super.func_180663_b(world, pos, state);
    }

    public void dumpItems(World world, BlockPos pos, ItemStack items) {
        EntityItem entItem = new EntityItem(world, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), items);
        float f3 = 0.05f;
        entItem.field_70159_w = (float)world.field_73012_v.nextGaussian() * f3;
        entItem.field_70181_x = (float)world.field_73012_v.nextGaussian() * f3 + 0.2f;
        entItem.field_70179_y = (float)world.field_73012_v.nextGaussian() * f3;
        world.func_72838_d((Entity)entItem);
    }

    public void addRecipe(Block previousTier) {
    }

    public void preInit(Block previousTier) {
        GameRegistry.registerBlock((Block)this, ItemBlockMachine.class, (String)this.name);
        this.addRecipe(previousTier);
    }

    public void init() {
        if (ProgressiveAutomation.proxy.isClient()) {
            Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(Item.func_150898_a((Block)this), 0, new ModelResourceLocation("progressiveautomation:" + this.name, "inventory"));
        }
    }

    public void postInit() {
    }

    protected ArrayList<ItemStack> getInsides(World world, BlockPos pos) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        BaseTileEntity tileEntity = (BaseTileEntity)world.func_175625_s(pos);
        if (tileEntity != null) {
            for (int i = 0; i < tileEntity.func_70302_i_(); ++i) {
                ItemStack itemstack = tileEntity.func_70301_a(i);
                if (itemstack == null) continue;
                items.add(itemstack);
            }
            if (tileEntity instanceof UpgradeableTileEntity) {
                UpgradeableTileEntity tileMachine = (UpgradeableTileEntity)tileEntity;
                for (UpgradeType upgradeType : tileMachine.getInstalledUpgradeTypes()) {
                    int stackSize;
                    for (int amount = tileMachine.getUpgradeAmount(upgradeType).intValue(); amount > 0; amount -= stackSize) {
                        ItemStack upgradeItemStack = new ItemStack((Item)UpgradeRegistry.getUpgradeItem(upgradeType));
                        upgradeItemStack.field_77994_a = stackSize = amount > 64 ? 64 : amount;
                        items.add(upgradeItemStack);
                    }
                }
            }
        }
        return items;
    }

    @Override
    public ArrayList<ItemStack> dismantleBlock(EntityPlayer player, World world, int x, int y, int z, boolean returnDrops) {
        BlockPos pos = new BlockPos(x, y, z);
        Block targetBlock = world.func_180495_p(pos).func_177230_c();
        ItemStack block = new ItemStack(targetBlock);
        if (world.func_175625_s(pos) instanceof BaseTileEntity) {
            BaseTileEntity tileEntity = (BaseTileEntity)world.func_175625_s(pos);
            tileEntity.writeToItemStack(block);
        }
        if (!returnDrops) {
            this.dumpItems(world, pos, block);
            world.func_175713_t(pos);
            world.func_175698_g(pos);
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(block);
        return items;
    }

    @Override
    public boolean canDismantle(EntityPlayer player, World world, int x, int y, int z) {
        return true;
    }

    public boolean rotateBlock(World worldObj, BlockPos pos, EnumFacing axis) {
        BaseTileEntity tileEntity = (BaseTileEntity)worldObj.func_175625_s(pos);
        if (tileEntity.facing == EnumFacing.NORTH) {
            tileEntity.facing = EnumFacing.EAST;
        } else if (tileEntity.facing == EnumFacing.EAST) {
            tileEntity.facing = EnumFacing.SOUTH;
        } else if (tileEntity.facing == EnumFacing.SOUTH) {
            tileEntity.facing = EnumFacing.WEST;
        } else if (tileEntity.facing == EnumFacing.WEST) {
            tileEntity.facing = EnumFacing.NORTH;
        }
        worldObj.func_175704_b(pos, pos);
        return true;
    }

    protected EnumFacing nextFace(EnumFacing dir) {
        if (dir == EnumFacing.NORTH) {
            return EnumFacing.EAST;
        }
        if (dir == EnumFacing.EAST) {
            return EnumFacing.SOUTH;
        }
        if (dir == EnumFacing.SOUTH) {
            return EnumFacing.WEST;
        }
        if (dir == EnumFacing.WEST) {
            return EnumFacing.NORTH;
        }
        return dir;
    }
}

