/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.ctweaks.features.update;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import net.darkhax.ctweaks.lib.Constants;

public class UpdateInfo {
    @SerializedName(value="version")
    private String version;
    @SerializedName(value="mainMessage")
    private String guiMessage;
    @SerializedName(value="chatMessage")
    private String chatMessage;

    public static UpdateInfo create(String url) {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            JsonReader reader = new JsonReader((Reader)new InputStreamReader((InputStream)connection.getContent()));
            GsonBuilder builder = new GsonBuilder();
            Gson gson = builder.create();
            UpdateInfo info = (UpdateInfo)gson.fromJson(reader, UpdateInfo.class);
            System.out.println(info.toString());
            return info;
        }
        catch (IOException exception) {
            Constants.LOG.warn((Object)exception);
            return new UpdateInfo();
        }
    }

    public String getVersion() {
        return this.version;
    }

    public String getGuiMessage() {
        return this.guiMessage;
    }

    public String getChatMessage() {
        return this.chatMessage;
    }

    public String toString() {
        return String.format("Version: %s Chat: %s GUI: %s", this.version, this.chatMessage, this.guiMessage);
    }
}

