/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.ctweaks.features.serverlist;

import net.darkhax.ctweaks.features.Feature;
import net.darkhax.ctweaks.lib.Constants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraftforge.common.config.Configuration;

public class FeatureServerList
extends Feature {
    private String[] serverEntries;
    private String[] removeEntries;
    private ServerList serverList;

    @Override
    public void onPreInit() {
        this.serverList = new ServerList(Minecraft.func_71410_x());
        this.serverList.func_78853_a();
        Minecraft.func_71410_x().func_152344_a(() -> this.removeServers());
        Minecraft.func_71410_x().func_152344_a(() -> this.addServers());
        this.serverList.func_78855_b();
    }

    @Override
    public void setupConfig(Configuration config) {
        this.serverEntries = config.getStringList("servers", this.configName, new String[]{"Example Server 1_127.0.0.1:25566", "Example Server 2_192.168.1.254"}, "Servers on this list will be automatically added to the players server list, if they do not already exist. Format is name@@serverAdress. The @ character is used to split the name from the IP adress, so it should not be used in the server name.");
        this.removeEntries = config.getStringList("removeEntries", this.configName, new String[]{"192.168.1.1", "192.168.1.2:25565", "play.olddomain.xyz"}, "Server IPs on this list will be automatically removed from the players server list. Allows for old server IPs to be removed from the server list.");
    }

    private void removeServers() {
        for (String removeIP : this.removeEntries) {
            for (ServerData serverEntry : this.serverList.field_78858_b) {
                if (!serverEntry.field_78845_b.equals(removeIP)) continue;
                this.serverList.field_78858_b.remove(serverEntry);
            }
        }
    }

    private void addServers() {
        for (String entry : this.serverEntries) {
            String[] parameters = entry.split("@@");
            if (parameters.length == 2) {
                boolean serverExists = false;
                for (ServerData serverEntry : this.serverList.field_78858_b) {
                    if (!serverEntry.field_78847_a.equals(parameters[0])) continue;
                    if (!serverEntry.field_78845_b.equals(parameters[1])) {
                        serverEntry.field_78845_b = parameters[1];
                    }
                    serverExists = true;
                    break;
                }
                if (!serverExists) {
                    ServerData data = new ServerData(parameters[0], parameters[1], false);
                    this.serverList.func_78849_a(data);
                }
                this.serverList.func_78855_b();
                continue;
            }
            Constants.LOG.warn(String.format("The server entry %s does not have the right amount of parameters. Expected 2, got %n", entry, parameters.length));
        }
    }
}

