/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.ctweaks.features.branding;

import net.darkhax.ctweaks.features.Feature;
import net.darkhax.ctweaks.features.branding.GuiGraphicButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class FeatureBrandingButtons
extends Feature {
    private String[] promoLinks;
    private int buttonWidth;

    @Override
    public void setupConfig(Configuration config) {
        this.promoLinks = config.getStringList("promoLinks", this.configName, new String[]{"twitter|twitter.com/Darkh4x", "patreon|patreon.com/Darkhax", "other|darkhax.net"}, "Each entry on the list represents a promotion button that will be added to the main menu. The format is siteType|Title|URL where | is used to split the message.");
        this.buttonWidth = config.getInt("buttonWidth", this.configName, 6, 1, 20, "The amount of buttons to add per row. If there are multiple promo buttons they will wrap after hitting the width");
    }

    @SubscribeEvent
    public void onGuiOpened(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.getGui() instanceof GuiMainMenu) {
            ScaledResolution res = new ScaledResolution(Minecraft.func_71410_x());
            int index = 1;
            for (String promoLink : this.promoLinks) {
                String[] params = promoLink.split("@@");
                int x = res.func_78326_a() - index * 25;
                GuiGraphicButton button = new GuiGraphicButton(params[1], params[0], index, x, 5 + index / this.buttonWidth);
                event.getButtonList().add(button);
                ++index;
            }
        }
    }

    @Override
    public boolean usesEvents() {
        return true;
    }
}

