/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.ctweaks.features.branding;

import java.util.ArrayList;
import java.util.List;
import net.darkhax.ctweaks.features.Feature;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.lwjgl.opengl.Display;

public class FeatureBranding
extends Feature {
    private String windowTitle;
    private String splashText;
    private String[] brandingTexts;
    private boolean replaceBrandings;
    private boolean shouldSplash = true;

    @Override
    public void onPreInit() {
        if (!this.windowTitle.isEmpty()) {
            Display.setTitle((String)this.windowTitle);
        }
        if (this.brandingTexts.length > 0) {
            this.addBrandings();
        }
    }

    @Override
    public void setupConfig(Configuration config) {
        this.windowTitle = config.getString("windowTitle", this.configName, "", "Changes the title of the window to a custom one. Leave blank to disable.");
        this.splashText = config.getString("splashText", this.configName, "", "Replaces the yellow splash text on the main menu. Leave blank to disable.");
        this.brandingTexts = config.getStringList("brandingTexts", this.configName, new String[0], "Entries to this list will be added to the brandings text on the bottom left side of the main menu.");
        this.replaceBrandings = config.getBoolean("replaceBrandings", this.configName, false, "Should the branding text replace the existing branding text? If not it will be added.");
    }

    @SubscribeEvent
    public void onUpdate(TickEvent.RenderTickEvent event) {
        GuiScreen guiscreen = Minecraft.func_71410_x().field_71462_r;
        if (guiscreen instanceof GuiMainMenu) {
            if (this.shouldSplash && !this.splashText.isEmpty()) {
                this.setSplash((GuiMainMenu)guiscreen, this.splashText);
            } else {
                this.shouldSplash = true;
            }
        }
    }

    public void setSplash(GuiMainMenu menu, String text) {
        menu.field_73975_c = text;
        this.shouldSplash = false;
    }

    private void addBrandings() {
        List existingBrandings = FMLCommonHandler.instance().getBrandings(true);
        ArrayList<String> newList = new ArrayList<String>();
        for (String branding : this.brandingTexts) {
            newList.add(branding);
        }
        if (!this.replaceBrandings) {
            newList.addAll(existingBrandings);
        }
        ReflectionHelper.setPrivateValue(FMLCommonHandler.class, (Object)FMLCommonHandler.instance(), newList, (String[])new String[]{"brandings"});
    }

    @Override
    public boolean usesEvents() {
        return true;
    }
}

