/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.player;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import org.apache.commons.lang3.tuple.Pair;

public class ItemCraftedAchievements {
    private static final ItemCraftedAchievements _INSTANCE = new ItemCraftedAchievements();
    private static final Multimap<Item, Pair<Predicate<ItemStack>, Achievement>> REGISTRY = Multimaps.newSetMultimap((Map)Maps.newIdentityHashMap(), (Supplier)new Supplier<Set<Pair<Predicate<ItemStack>, Achievement>>>(){

        public Set<Pair<Predicate<ItemStack>, Achievement>> get() {
            return Sets.newIdentityHashSet();
        }
    });

    private ItemCraftedAchievements() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onCrafted(PlayerEvent.ItemCraftedEvent event) {
        for (Pair pair : REGISTRY.get((Object)event.crafting.func_77973_b())) {
            if (!((Predicate)pair.getLeft()).apply((Object)event.crafting)) continue;
            event.player.func_71029_a((StatBase)pair.getRight());
        }
    }

    public static void register(Item item, Achievement achievement) {
        ItemCraftedAchievements.register(item, achievement, (Predicate<ItemStack>)Predicates.alwaysTrue());
    }

    public static void register(Item item, Achievement achievement, Predicate<ItemStack> predicate) {
        REGISTRY.put((Object)item, (Object)Pair.of(predicate, (Object)achievement));
    }
}

