/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.modcompat.minetweaker.handlers;

import mezz.jei.api.recipe.IRecipeWrapper;
import minetweaker.MineTweakerAPI;
import net.minecraftforge.fml.common.Optional;
import org.cyclops.cyclopscore.modcompat.jei.IJeiRecipeWrapperWrapper;
import org.cyclops.cyclopscore.modcompat.minetweaker.handlers.BaseListRemoval;
import org.cyclops.cyclopscore.modcompat.minetweaker.handlers.RecipeRegistryAddition;
import org.cyclops.cyclopscore.recipe.custom.api.IMachine;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipe;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeInput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeOutput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeProperties;

public class RecipeRegistryRemoval<M extends IMachine<M, I, O, P>, I extends IRecipeInput, O extends IRecipeOutput, P extends IRecipeProperties>
extends BaseListRemoval<IRecipe<I, O, P>> {
    private final M machine;
    private final IJeiRecipeWrapperWrapper<I, O, P> jeiRecipeWrapperWrapper;

    protected RecipeRegistryRemoval(String machineName, M machine, IRecipe<I, O, P> recipe, IJeiRecipeWrapperWrapper<I, O, P> jeiRecipeWrapperWrapper) {
        super(machineName, machine.getRecipeRegistry().allRecipes());
        this.machine = machine;
        this.recipes.add(recipe);
        this.jeiRecipeWrapperWrapper = jeiRecipeWrapperWrapper;
    }

    protected RecipeRegistryRemoval(String machineName, M machine, O output, IJeiRecipeWrapperWrapper<I, O, P> jeiRecipeWrapperWrapper) {
        super(machineName, machine.getRecipeRegistry().allRecipes());
        this.machine = machine;
        this.recipes.addAll(machine.getRecipeRegistry().findRecipesByOutput(output));
        this.jeiRecipeWrapperWrapper = jeiRecipeWrapperWrapper;
    }

    @Override
    public void apply() {
        if (this.recipes.isEmpty()) {
            return;
        }
        for (IRecipe recipe : this.recipes) {
            if (recipe != null) {
                IRecipe removed = this.machine.getRecipeRegistry().unregisterRecipe(recipe);
                if (removed != null) {
                    this.successful.add(removed);
                    MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe(this.wrapRecipe(recipe) != null ? this.wrapRecipe(recipe) : recipe);
                    continue;
                }
                MineTweakerAPI.logError((String)String.format("Error removing %s Recipe for %s", this.name, this.getRecipeInfo(recipe)));
                continue;
            }
            MineTweakerAPI.logError((String)String.format("Error removing %s Recipe: null object", this.name));
        }
    }

    @Override
    protected String getRecipeInfo(IRecipe<I, O, P> recipe) {
        return RecipeRegistryAddition.getRecipeInfo(this.name, recipe);
    }

    @Override
    @Optional.Method(modid="JEI")
    public IRecipeWrapper wrapRecipe(IRecipe<I, O, P> recipe) {
        return this.jeiRecipeWrapperWrapper.wrap(recipe);
    }
}

