/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.modcompat.minetweaker.handlers;

import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.modcompat.jei.IJeiRecipeWrapperWrapper;
import org.cyclops.cyclopscore.modcompat.minetweaker.handlers.RecipeRegistryAddition;
import org.cyclops.cyclopscore.modcompat.minetweaker.handlers.RecipeRegistryRemoval;
import org.cyclops.cyclopscore.recipe.custom.api.IMachine;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipe;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeInput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeOutput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeProperties;

public abstract class RecipeRegistryHandler<M extends IMachine<M, I, O, P>, I extends IRecipeInput, O extends IRecipeOutput, P extends IRecipeProperties> {
    protected abstract M getMachine();

    protected abstract String getRegistryName();

    protected abstract IJeiRecipeWrapperWrapper<I, O, P> createJeiWrapperWrapper();

    protected IJeiRecipeWrapperWrapper<I, O, P> createJeiWrapperWrapperSafe() {
        if (!Loader.isModLoaded((String)"JEI")) {
            return null;
        }
        return this.createJeiWrapperWrapper();
    }

    public void add(IRecipe<I, O, P> recipe) {
        MineTweakerAPI.apply(new RecipeRegistryAddition<M, I, O, P>(this.getRegistryName(), this.getMachine(), recipe, this.createJeiWrapperWrapperSafe()));
    }

    public void remove(IRecipe<I, O, P> recipe) {
        MineTweakerAPI.apply(new RecipeRegistryRemoval<M, I, IRecipe<I, O, P>, P>(this.getRegistryName(), this.getMachine(), recipe, this.createJeiWrapperWrapperSafe()));
    }

    public void remove(O output) {
        MineTweakerAPI.apply(new RecipeRegistryRemoval<M, I, O, P>(this.getRegistryName(), this.getMachine(), output, this.createJeiWrapperWrapperSafe()));
    }

    public static ItemStack toStack(IItemStack stack) {
        if (stack == null) {
            return null;
        }
        Object internal = stack.getInternal();
        if (!(internal instanceof ItemStack)) {
            CyclopsCore.clog("Not a valid item stack: " + stack);
            return null;
        }
        return (ItemStack)internal;
    }

    public static FluidStack toFluid(ILiquidStack stack) {
        if (stack == null) {
            return null;
        }
        return FluidRegistry.getFluidStack((String)stack.getName(), (int)stack.getAmount());
    }
}

