/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.modcompat.minetweaker.handlers;

import mezz.jei.api.recipe.IRecipeWrapper;
import minetweaker.MineTweakerAPI;
import net.minecraftforge.fml.common.Optional;
import org.cyclops.cyclopscore.modcompat.jei.IJeiRecipeWrapperWrapper;
import org.cyclops.cyclopscore.modcompat.minetweaker.handlers.BaseListAddition;
import org.cyclops.cyclopscore.recipe.custom.api.IMachine;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipe;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeInput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeOutput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeProperties;

public class RecipeRegistryAddition<M extends IMachine<M, I, O, P>, I extends IRecipeInput, O extends IRecipeOutput, P extends IRecipeProperties>
extends BaseListAddition<IRecipe<I, O, P>> {
    private final M machine;
    private final IJeiRecipeWrapperWrapper<I, O, P> jeiRecipeWrapperWrapper;

    protected RecipeRegistryAddition(String machineName, M machine, IRecipe<I, O, P> recipe, IJeiRecipeWrapperWrapper<I, O, P> jeiRecipeWrapperWrapper) {
        super(machineName, machine.getRecipeRegistry().allRecipes());
        this.machine = machine;
        this.recipes.add(recipe);
        this.jeiRecipeWrapperWrapper = jeiRecipeWrapperWrapper;
    }

    @Override
    protected String getRecipeInfo(IRecipe<I, O, P> recipe) {
        return RecipeRegistryAddition.getRecipeInfo(this.name, recipe);
    }

    @Override
    public void undo() {
        for (IRecipe recipe : this.successful) {
            if (recipe != null) {
                if (this.machine.getRecipeRegistry().unregisterRecipe(recipe) == null) {
                    MineTweakerAPI.logError((String)String.format("Error removing %s Recipe for %s", this.name, this.getRecipeInfo(recipe)));
                    continue;
                }
                MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe(this.wrapRecipe(recipe) != null ? this.wrapRecipe(recipe) : recipe);
                continue;
            }
            MineTweakerAPI.logError((String)String.format("Error removing %s Recipe: null object", this.name));
        }
    }

    @Override
    @Optional.Method(modid="JEI")
    public IRecipeWrapper wrapRecipe(IRecipe<I, O, P> recipe) {
        return this.jeiRecipeWrapperWrapper.wrap(recipe);
    }

    public static <I extends IRecipeInput, O extends IRecipeOutput, P extends IRecipeProperties> String getRecipeInfo(String machineName, IRecipe<I, O, P> recipe) {
        StringBuilder build = new StringBuilder();
        build.append(machineName);
        build.append(" recipe: ");
        build.append("Input: " + recipe.getInput().toString()).append("; ");
        build.append("Output: " + recipe.getOutput().toString()).append("; ");
        build.append("Properties: " + recipe.getProperties().toString()).append("; ");
        return build.toString();
    }
}

