/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.modcompat.minetweaker.handlers;

import java.util.List;
import minetweaker.MineTweakerAPI;
import org.cyclops.cyclopscore.modcompat.minetweaker.handlers.BaseListModification;

public abstract class BaseListAddition<T>
extends BaseListModification<T> {
    protected BaseListAddition(String name, List<T> list) {
        super(name, list);
    }

    protected BaseListAddition(String name, List<T> list, List<T> recipies) {
        this(name, list);
        if (this.recipes != null) {
            this.recipes.addAll(recipies);
        }
    }

    public void apply() {
        if (this.recipes.isEmpty()) {
            return;
        }
        for (Object recipe : this.recipes) {
            if (recipe != null) {
                if (this.list.add(recipe)) {
                    this.successful.add(recipe);
                    MineTweakerAPI.getIjeiRecipeRegistry().addRecipe(this.wrapRecipe(recipe) != null ? this.wrapRecipe(recipe) : recipe);
                    continue;
                }
                MineTweakerAPI.logError((String)String.format("Error adding %s Recipe for %s", this.name, this.getRecipeInfo(recipe)));
                continue;
            }
            MineTweakerAPI.logError((String)String.format("Error adding %s Recipe: null object", this.name));
        }
    }

    public void undo() {
        if (this.successful.isEmpty()) {
            return;
        }
        for (Object recipe : this.successful) {
            if (recipe != null) {
                if (!this.list.remove(recipe)) {
                    MineTweakerAPI.logError((String)String.format("Error removing %s Recipe for %s", this.name, this.getRecipeInfo(recipe)));
                    continue;
                }
                MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe(this.wrapRecipe(recipe) != null ? this.wrapRecipe(recipe) : recipe);
                continue;
            }
            MineTweakerAPI.logError((String)String.format("Error removing %s Recipe: null object", this.name));
        }
    }

    @Override
    public String describe() {
        return String.format("Adding %d %s Recipe(s) for %s", this.recipes.size(), this.name, this.getRecipeInfo());
    }

    @Override
    public String describeUndo() {
        return String.format("Removing %d %s Recipe(s) for %s", this.recipes.size(), this.name, this.getRecipeInfo());
    }
}

