/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory;

import com.google.common.collect.Maps;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.inventory.IndexedSlotlessItemHandlerWrapper;
import org.cyclops.cyclopscore.inventory.LargeInventory;

public class IndexedInventory
extends LargeInventory
implements IndexedSlotlessItemHandlerWrapper.IInventoryIndexReference {
    private final Map<Item, TIntObjectMap<ItemStack>> index = Maps.newIdentityHashMap();
    private int firstEmptySlot = 0;
    private int lastEmptySlot;
    private int firstNonEmptySlot;
    private int lastNonEmptySlot;

    public IndexedInventory() {
        this(0, "", 0);
    }

    public IndexedInventory(int size, String name, int stackLimit) {
        super(size, name, stackLimit);
        this.lastEmptySlot = size - 1;
        this.firstNonEmptySlot = -1;
        this.lastNonEmptySlot = -1;
    }

    protected void createIndex() {
        this.index.clear();
        this.firstEmptySlot = -1;
        this.lastEmptySlot = -1;
        this.firstNonEmptySlot = -1;
        this.lastNonEmptySlot = -1;
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack itemStack = this.func_70301_a(i);
            if (itemStack != null) {
                TIntObjectHashMap stacks = this.index.get(itemStack.func_77973_b());
                if (stacks == null) {
                    stacks = new TIntObjectHashMap();
                    this.index.put(itemStack.func_77973_b(), (TIntObjectMap<ItemStack>)stacks);
                }
                stacks.put(i, (Object)itemStack);
                if (this.firstNonEmptySlot < 0) {
                    this.firstNonEmptySlot = i;
                }
                this.lastNonEmptySlot = i;
                continue;
            }
            if (this.firstEmptySlot < 0) {
                this.firstEmptySlot = i;
            }
            this.lastEmptySlot = i;
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data, String tag) {
        super.readFromNBT(data, tag);
        this.createIndex();
    }

    @Override
    public void func_70299_a(int slotId, ItemStack itemStack) {
        int i;
        TIntObjectMap<ItemStack> stacks;
        ItemStack oldStack = this.func_70301_a(slotId);
        if (oldStack != null && (stacks = this.index.get(oldStack.func_77973_b())) != null) {
            stacks.remove(slotId);
        }
        if (itemStack != null) {
            stacks = this.index.get(itemStack.func_77973_b());
            if (stacks == null) {
                stacks = new TIntObjectHashMap();
                this.index.put(itemStack.func_77973_b(), stacks);
            }
            stacks.put(slotId, (Object)itemStack);
        }
        super.func_70299_a(slotId, itemStack);
        if (slotId == this.firstEmptySlot && oldStack == null && itemStack != null) {
            int oldFirstEmptySlot = this.firstEmptySlot;
            this.firstEmptySlot = -1;
            for (i = Math.max(0, oldFirstEmptySlot); i < this.func_70302_i_(); ++i) {
                if (this.func_70301_a(i) != null) continue;
                this.firstEmptySlot = i;
                break;
            }
        }
        if (slotId == this.lastEmptySlot && oldStack == null && itemStack != null) {
            int oldLastEmptySlot = this.lastEmptySlot;
            this.lastEmptySlot = -1;
            for (i = oldLastEmptySlot; i >= 0; --i) {
                if (this.func_70301_a(i) != null) continue;
                this.lastEmptySlot = i;
                break;
            }
        }
        if (slotId == this.firstNonEmptySlot && oldStack != null && itemStack == null) {
            int oldFirstNonEmptySlot = this.firstNonEmptySlot;
            this.firstNonEmptySlot = -1;
            for (i = Math.max(0, oldFirstNonEmptySlot); i < this.func_70302_i_(); ++i) {
                if (this.func_70301_a(i) == null) continue;
                this.firstNonEmptySlot = i;
                break;
            }
        }
        if (slotId == this.lastNonEmptySlot && oldStack != null && itemStack == null) {
            int oldLastNonEmptySlot = this.lastNonEmptySlot;
            this.lastNonEmptySlot = -1;
            for (i = oldLastNonEmptySlot; i >= 0; --i) {
                if (this.func_70301_a(i) == null) continue;
                this.lastNonEmptySlot = i;
                break;
            }
        }
        if ((slotId < this.firstEmptySlot || this.firstEmptySlot < 0) && itemStack == null) {
            this.firstEmptySlot = slotId;
        }
        if (slotId > this.lastEmptySlot && itemStack == null) {
            this.lastEmptySlot = slotId;
        }
        if ((slotId < this.firstNonEmptySlot || this.firstNonEmptySlot < 0) && itemStack != null) {
            this.firstNonEmptySlot = slotId;
        }
        if (slotId > this.lastNonEmptySlot && itemStack != null) {
            this.lastNonEmptySlot = slotId;
        }
        if (this.firstEmptySlot == this.firstNonEmptySlot) {
            CyclopsCore.clog(Level.WARN, String.format("Indexed inventory at inconsistent with first empty %s and first non-empty %s.", this.firstEmptySlot, this.firstNonEmptySlot));
        }
        if (this.lastEmptySlot == this.lastNonEmptySlot) {
            CyclopsCore.clog(Level.WARN, String.format("Indexed inventory at inconsistent with last empty %s and last non-empty %s.", this.lastEmptySlot, this.lastNonEmptySlot));
        }
    }

    @Override
    public void func_174888_l() {
        super.func_174888_l();
        this.index.clear();
    }

    @Override
    public Map<Item, TIntObjectMap<ItemStack>> getIndex() {
        return this.index;
    }

    @Override
    public int getFirstEmptySlot() {
        return this.firstEmptySlot;
    }

    @Override
    public int getLastEmptySlot() {
        return this.lastEmptySlot;
    }

    @Override
    public int getFirstNonEmptySlot() {
        return this.firstNonEmptySlot;
    }

    @Override
    public int getLastNonEmptySlot() {
        return this.lastNonEmptySlot;
    }
}

