/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.init;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.init.ModBase;

public class Debug {
    private static final String CONFIGCHECKER_PREFIX = "[CONFIGCHECKER] ";
    private final Set<ExtendedConfig> savedConfigs = Sets.newHashSet();
    private final ModBase mod;
    private boolean ok = true;

    public Debug(ModBase mod) {
        this.mod = mod;
    }

    public void checkPreConfigurables(Set<ExtendedConfig> configs) {
        for (ExtendedConfig config : configs) {
            try {
                config.getClass().getField("_instance");
            }
            catch (NoSuchFieldException e) {
                this.log(config + " has no static '_instance' field.");
            }
            catch (SecurityException e) {
                this.log(config + " has a non-public static '_instance' field, make it public.");
            }
        }
        this.savedConfigs.addAll(configs);
    }

    public void checkPostConfigurables() {
        for (ExtendedConfig config : this.savedConfigs) {
            if (!config.getHolderType().hasUniqueInstance() || !config.isEnabled()) continue;
            if (config.getSubInstance() == null) {
                this.log(config.getElement() + " has no sub-instance, even though it is enabled.");
            }
            try {
                config.getElement().getMethod("getInstance", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                this.log(config.getElement() + " has no static 'getInstance()' method.");
            }
            catch (SecurityException e) {
                this.log(config.getElement() + " has a non-public static 'getInstance()' method, make it public.");
            }
        }
        if (this.ok) {
            this.log("Everything is just fine!");
        }
    }

    private void log(String message) {
        this.ok = false;
        this.mod.log(Level.INFO, CONFIGCHECKER_PREFIX + message);
    }
}

