/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook.pageelement;

import java.util.Collections;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.helper.obfuscation.ObfuscationHelpers;
import org.cyclops.cyclopscore.infobook.AdvancedButton;
import org.cyclops.cyclopscore.infobook.GuiInfoBook;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.pageelement.RecipeAppendix;

public class CraftingRecipeAppendix
extends RecipeAppendix<IRecipe> {
    private static final int SLOT_OFFSET_X = 5;
    private static final int SLOT_OFFSET_Y = 5;
    private static final int START_X_RESULT = 84;
    private static final AdvancedButton.Enum[] INPUT = new AdvancedButton.Enum[9];
    private static final AdvancedButton.Enum RESULT;

    public CraftingRecipeAppendix(IInfoBook infoBook, IRecipe recipe) {
        super(infoBook, recipe);
    }

    @Override
    protected int getWidth() {
        return 104;
    }

    @Override
    protected int getHeightInner() {
        return 58;
    }

    @Override
    protected String getUnlocalizedTitle() {
        return "tile.workbench.name";
    }

    @Override
    public void bakeElement(InfoSection infoSection) {
        for (int i = 0; i < 9; ++i) {
            this.renderItemHolders.put(INPUT[i], new RecipeAppendix.ItemButton(this.getInfoBook()));
        }
        this.renderItemHolders.put(RESULT, new RecipeAppendix.ItemButton(this.getInfoBook()));
        super.bakeElement(infoSection);
    }

    @Override
    protected void drawElementInner(GuiInfoBook gui, int x, int y, int width, int height, int page, int mx, int my) {
        int j;
        int i;
        gui.drawArrowRight(x + 63 - 3, y + 5 + 16 + 2);
        int tick = this.getTick(gui);
        ItemStack[] grid = new ItemStack[9];
        ItemStack result = this.prepareItemStack(((IRecipe)this.recipe).func_77571_b(), tick);
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                grid[i + j * 3] = this.prepareItemStacks(this.getItemStacks(i + j * 3), tick);
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.renderItem(gui, x + 21 * i, y + 21 * j, grid[i + j * 3], mx, my, INPUT[i + j * 3]);
            }
        }
        this.renderItem(gui, x + 84, y + 21, result, mx, my, RESULT);
        this.renderItem(gui, x + 63, y + 5 + 16, new ItemStack(Blocks.field_150462_ai), mx, my, false, null);
    }

    private static Object[] formatShapedGrid(Object[] itemStacksRaw, int width, int height) {
        int rawIndex = 0;
        Object[] itemStacks = new Object[9];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                itemStacks[y * 3 + x] = itemStacksRaw[rawIndex++];
                if (rawIndex >= itemStacksRaw.length) break;
            }
            if (rawIndex >= itemStacksRaw.length) break;
        }
        return itemStacks;
    }

    protected List<ItemStack> getItemStacks(int index) {
        Object[] itemStacks;
        if (this.recipe instanceof ShapedRecipes) {
            itemStacks = CraftingRecipeAppendix.formatShapedGrid(((ShapedRecipes)this.recipe).field_77574_d, ((ShapedRecipes)this.recipe).field_77576_b, ((ShapedRecipes)this.recipe).field_77577_c);
        } else if (this.recipe instanceof ShapedOreRecipe) {
            itemStacks = CraftingRecipeAppendix.formatShapedGrid(((ShapedOreRecipe)this.recipe).getInput(), ObfuscationHelpers.getShapedOreRecipeWidth((ShapedOreRecipe)this.recipe), ObfuscationHelpers.getShapedOreRecipeHeight((ShapedOreRecipe)this.recipe));
        } else if (this.recipe instanceof ShapelessRecipes) {
            itemStacks = ((ShapelessRecipes)this.recipe).field_77579_b.toArray();
        } else if (this.recipe instanceof ShapelessOreRecipe) {
            itemStacks = ((ShapelessOreRecipe)this.recipe).getInput().toArray();
        } else {
            this.getInfoBook().getMod().log(Level.ERROR, "Recipe of type " + ((IRecipe)this.recipe).getClass() + " is not supported.");
            return Collections.emptyList();
        }
        if (itemStacks.length <= index) {
            return Collections.emptyList();
        }
        Object element = itemStacks[index];
        if (element == null) {
            return Collections.emptyList();
        }
        return element instanceof ItemStack ? Collections.singletonList((ItemStack)element) : (List<ItemStack>)element;
    }

    static {
        for (int i = 0; i < 9; ++i) {
            CraftingRecipeAppendix.INPUT[i] = AdvancedButton.Enum.create();
        }
        RESULT = AdvancedButton.Enum.create();
    }
}

