/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.obfuscation.ObfuscationHelpers;

public class LootHelpers {
    private static final LootHelpers INSTANCE = new LootHelpers();
    private static final Multimap<ResourceLocation, LootPool> INJECT_LOOTPOOLS = MultimapBuilder.ListMultimapBuilder.hashKeys().arrayListValues().build();
    private static final Multimap<Pair<ResourceLocation, String>, LootEntryItem> INJECT_LOOTENTRIES = MultimapBuilder.ListMultimapBuilder.hashKeys().arrayListValues().build();
    public static List<ResourceLocation> VANILLA_LOOT_CHEST_TABLES = Lists.newArrayList((Object[])new ResourceLocation[]{LootTableList.field_186424_f, LootTableList.field_186429_k, LootTableList.field_186421_c, LootTableList.field_186431_m, LootTableList.field_186430_l, LootTableList.field_186425_g, LootTableList.field_186422_d, LootTableList.field_186420_b, LootTableList.field_186428_j, LootTableList.field_186427_i, LootTableList.field_186426_h, LootTableList.field_186423_e});

    private LootHelpers() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        ResourceLocation resourceLocation;
        for (Map.Entry poolEntry : INJECT_LOOTPOOLS.entries()) {
            resourceLocation = (ResourceLocation)poolEntry.getKey();
            LootPool pool = (LootPool)poolEntry.getValue();
            if (!event.getName().equals((Object)resourceLocation)) continue;
            event.getTable().addPool(pool);
        }
        for (Map.Entry entryItemEntry : INJECT_LOOTENTRIES.entries()) {
            resourceLocation = (ResourceLocation)((Pair)entryItemEntry.getKey()).getKey();
            String poolName = (String)((Pair)entryItemEntry.getKey()).getValue();
            LootEntryItem entryItem = (LootEntryItem)entryItemEntry.getValue();
            if (!event.getName().equals((Object)resourceLocation)) continue;
            LootTable lootTable = event.getTable();
            if (poolName == null) {
                List<LootPool> pools = ObfuscationHelpers.getLootPools(lootTable);
                for (LootPool pool : pools) {
                    if (pool.isFrozen()) continue;
                    pool.addEntry((LootEntry)entryItem);
                }
                continue;
            }
            LootPool lootPool = lootTable.getPool(poolName);
            if (lootPool == null) {
                throw new RuntimeException(String.format("Could not find loot pool %s in loot table %s.", poolName, resourceLocation));
            }
            if (lootPool.isFrozen()) continue;
            lootPool.addEntry((LootEntry)entryItem);
        }
    }

    public static void addVanillaLootChestLootEntry(LootEntryItem ... lootEntryItems) {
        for (ResourceLocation lootTable : VANILLA_LOOT_CHEST_TABLES) {
            LootHelpers.addLootEntry(lootTable, null, lootEntryItems);
        }
    }

    public static void addVanillaLootChestLootEntry(@Nullable String poolName, LootEntryItem ... lootEntryItems) {
        for (ResourceLocation lootTable : VANILLA_LOOT_CHEST_TABLES) {
            LootHelpers.addLootEntry(lootTable, poolName, lootEntryItems);
        }
    }

    public static void addVanillaLootChestLootPool(LootPool lootPool) {
        for (ResourceLocation lootTable : VANILLA_LOOT_CHEST_TABLES) {
            LootHelpers.addLootPool(lootTable, lootPool);
        }
    }

    public static void addLootEntry(ResourceLocation lootTable, @Nullable String poolName, LootEntryItem ... lootEntryItems) {
        for (LootEntryItem lootEntryItem : lootEntryItems) {
            INJECT_LOOTENTRIES.put((Object)Pair.of((Object)lootTable, (Object)poolName), (Object)lootEntryItem);
        }
    }

    public static void addLootPool(ResourceLocation lootTable, LootPool lootPool) {
        INJECT_LOOTPOOLS.put((Object)lootTable, (Object)lootPool);
    }
}

