/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.configurabletypeaction;

import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import org.cyclops.cyclopscore.client.gui.GuiHandler;
import org.cyclops.cyclopscore.config.ConfigurableType;
import org.cyclops.cyclopscore.config.configurable.ConfigurableBlockContainer;
import org.cyclops.cyclopscore.config.configurable.IConfigurableBlock;
import org.cyclops.cyclopscore.config.configurabletypeaction.ConfigurableTypeAction;
import org.cyclops.cyclopscore.config.configurabletypeaction.ItemAction;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.inventory.IGuiContainerProvider;

public class BlockAction
extends ConfigurableTypeAction<BlockConfig> {
    public static void register(Block block, ExtendedConfig config, @Nullable CreativeTabs creativeTabs) {
        BlockAction.register(block, null, config, creativeTabs);
    }

    public static void register(Block block, @Nullable Class<? extends ItemBlock> itemBlockClass, ExtendedConfig config, @Nullable CreativeTabs creativeTabs) {
        BlockAction.register(block, config);
        if (itemBlockClass != null) {
            try {
                ItemBlock item = itemBlockClass.getConstructor(Block.class).newInstance(block);
                BlockAction.register(item, config);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (creativeTabs != null) {
            block.func_149647_a(creativeTabs);
        }
    }

    @Override
    public void preRun(BlockConfig eConfig, Configuration config, boolean startup) {
        Property property = config.get(eConfig.getHolderType().getCategory(), eConfig.getNamedId(), eConfig.isEnabled());
        property.setRequiresMcRestart(true);
        property.setComment(eConfig.getComment());
        property.setLanguageKey(eConfig.getFullUnlocalizedName());
        if (startup) {
            eConfig.setEnabled(property.getBoolean(true));
        }
    }

    @Override
    public void postRun(BlockConfig eConfig, Configuration config) {
        eConfig.save();
        Block block = (Block)eConfig.getSubInstance();
        BlockAction.register(block, eConfig.getItemBlockClass(), eConfig, eConfig.getTargetTab());
        GuiHandler.GuiType<Void> guiType = GuiHandler.GuiType.BLOCK;
        if (eConfig.getHolderType().equals(ConfigurableType.BLOCKCONTAINER)) {
            ConfigurableBlockContainer container = (ConfigurableBlockContainer)block;
            GameRegistry.registerTileEntityWithAlternatives(container.getTileEntity(), (String)(eConfig.getMod().getModId() + ":" + eConfig.getSubUniqueName()), (String[])new String[]{eConfig.getSubUniqueName()});
            guiType = GuiHandler.GuiType.TILE;
        }
        if (block instanceof IConfigurableBlock && ((IConfigurableBlock)block).hasGui()) {
            IGuiContainerProvider gui = (IGuiContainerProvider)block;
            eConfig.getMod().getGuiHandler().registerGUI(gui, guiType);
        }
        if (eConfig.getOreDictionaryId() != null) {
            OreDictionary.registerOre((String)eConfig.getOreDictionaryId(), (ItemStack)new ItemStack((Block)eConfig.getSubInstance()));
        }
    }

    @Override
    public void polish(BlockConfig config) {
        if (MinecraftHelpers.isClientSide()) {
            IConfigurableBlock configurableBlock;
            IBlockColor blockColorHandler;
            Block block = config.getBlockInstance();
            ItemAction.handleItemModel(Item.func_150898_a((Block)block), config.getNamedId(), config.getTargetTab(), config.getMod().getModId(), config);
            if (block instanceof IConfigurableBlock && (blockColorHandler = (configurableBlock = (IConfigurableBlock)block).getBlockColorHandler()) != null) {
                Minecraft.func_71410_x().func_184125_al().func_186722_a(blockColorHandler, new Block[]{block});
            }
        }
    }
}

