/*
 * Decompiled with CFR 0.152.
 */
package mmd.orespawn.world;

import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import mmd.orespawn.api.OreSpawnAPI;
import mmd.orespawn.api.SpawnEntry;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.oredict.OreDictionary;

public class OreSpawnWorldGenerator
implements IWorldGenerator {
    private static final Vec3i[] NORMAL_OFFSET = new Vec3i[]{new Vec3i(-1, -1, -1), new Vec3i(0, -1, -1), new Vec3i(1, -1, -1), new Vec3i(-1, 0, -1), new Vec3i(0, 0, -1), new Vec3i(1, 0, -1), new Vec3i(-1, 1, -1), new Vec3i(0, 1, -1), new Vec3i(1, 1, -1), new Vec3i(-1, -1, 0), new Vec3i(0, -1, 0), new Vec3i(1, -1, 0), new Vec3i(-1, 0, 0), new Vec3i(0, 0, 0), new Vec3i(1, 0, 0), new Vec3i(-1, 1, 0), new Vec3i(0, 1, 0), new Vec3i(1, 1, 0), new Vec3i(-1, -1, 1), new Vec3i(0, -1, 1), new Vec3i(1, -1, 1), new Vec3i(-1, 0, 1), new Vec3i(0, 0, 1), new Vec3i(1, 0, 1), new Vec3i(-1, 1, 1), new Vec3i(0, 1, 1), new Vec3i(1, 1, 1)};
    private static final Vec3i[] SMALL_OFFSET = new Vec3i[]{new Vec3i(0, 0, 0), new Vec3i(1, 0, 0), new Vec3i(0, 1, 0), new Vec3i(1, 1, 0), new Vec3i(0, 0, 1), new Vec3i(1, 0, 1), new Vec3i(0, 1, 1), new Vec3i(1, 1, 1)};
    private static final int[] NORMAL_OFFSET_INDEX = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26};
    private static final int[] SMALL_OFFSET_INDEX = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    private static final int MAX_CACHE_SIZE = 1024;
    private static final Map<Vec3i, Map<BlockPos, IBlockState>> OVERFLOW_CACHE = new HashMap<Vec3i, Map<BlockPos, IBlockState>>(1024);
    private static final Deque<Vec3i> CACHE_ORDER = new LinkedList<Vec3i>();
    public static final HashSet<Block> SPAWN_BLOCKS = new HashSet();
    private static final Set<Integer> KNOWN_DIMENSIONS = new HashSet<Integer>();
    private static final Predicate<IBlockState> STONE_PREDICATE = input -> {
        if (input == null) {
            return false;
        }
        Block block = input.func_177230_c();
        return block != Blocks.field_150350_a && SPAWN_BLOCKS.contains(block);
    };
    private final long hash;
    private final int dimension;
    private final SpawnEntry spawnEntry;

    public OreSpawnWorldGenerator(SpawnEntry spawnEntry, int dimension, long hash) {
        this.spawnEntry = spawnEntry;
        this.hash = hash;
        this.dimension = dimension;
        if (dimension != OreSpawnAPI.DIMENSION_WILDCARD) {
            KNOWN_DIMENSIONS.add(dimension);
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (SPAWN_BLOCKS.isEmpty()) {
            SPAWN_BLOCKS.add(Blocks.field_150348_b);
            SPAWN_BLOCKS.add(Blocks.field_150424_aL);
            SPAWN_BLOCKS.add(Blocks.field_150377_bs);
            SPAWN_BLOCKS.addAll(OreDictionary.getOres((String)"stone").stream().filter(stack -> stack.func_77973_b() instanceof ItemBlock).map(stack -> ((ItemBlock)stack.func_77973_b()).func_179223_d()).collect(Collectors.toList()));
        }
        if (this.dimension == OreSpawnAPI.DIMENSION_WILDCARD ? KNOWN_DIMENSIONS.contains(world.field_73011_w.getDimension()) : world.field_73011_w.getDimension() != this.dimension) {
            return;
        }
        BlockPos pos = new BlockPos(chunkX << 4 & 8, 64, chunkZ << 4 & 8);
        if (this.spawnEntry.getBiomes().length != 0) {
            Biome biome = world.func_180494_b(pos);
            boolean flag = false;
            for (Biome b : this.spawnEntry.getBiomes()) {
                if (b != biome) continue;
                flag = true;
                break;
            }
            if (!flag) {
                return;
            }
        }
        Vec3i chunkCoord = new Vec3i(chunkX, chunkZ, world.field_73011_w.getDimension());
        Map<BlockPos, IBlockState> cache = this.retrieveCache(chunkCoord);
        for (BlockPos cachedPos : cache.keySet()) {
            this.replaceStone(cache.get(cachedPos), world, cachedPos, world.field_73011_w.getDimension(), false);
        }
        random.setSeed(random.nextLong() ^ this.hash);
        random.nextInt();
        if (this.spawnEntry.getFrequency() >= 1) {
            for (int i = 0; i < this.spawnEntry.getFrequency(); ++i) {
                int x = (chunkX << 4) + random.nextInt(16);
                int y = random.nextInt(this.spawnEntry.getMaxHeight() - this.spawnEntry.getMinHeight()) + this.spawnEntry.getMinHeight();
                int z = (chunkZ << 4) + random.nextInt(16);
                int r = 0;
                if (this.spawnEntry.getVariation() > 0) {
                    r = random.nextInt(2 * this.spawnEntry.getVariation()) - this.spawnEntry.getVariation();
                }
                this.spawnOre(new BlockPos(x, y, z), this.spawnEntry.getState(), this.spawnEntry.getSize() + r, world, random);
            }
        } else if (random.nextFloat() < (float)this.spawnEntry.getFrequency()) {
            int x = (chunkX << 4) + random.nextInt(16);
            int y = random.nextInt(this.spawnEntry.getMaxHeight() - this.spawnEntry.getMinHeight()) + this.spawnEntry.getMinHeight();
            int z = (chunkZ << 4) + random.nextInt(16);
            int r = 0;
            if (this.spawnEntry.getVariation() > 0) {
                r = random.nextInt(2 * this.spawnEntry.getVariation()) - this.spawnEntry.getVariation();
            }
            this.spawnOre(new BlockPos(x, y, z), this.spawnEntry.getState(), this.spawnEntry.getSize() + r, world, random);
        }
    }

    private void spawnOre(BlockPos blockPos, IBlockState state, int quantity, World world, Random random) {
        block16: {
            int count = quantity;
            if (quantity <= 8) {
                int[] scrambledLUT = new int[SMALL_OFFSET_INDEX.length];
                System.arraycopy(SMALL_OFFSET_INDEX, 0, scrambledLUT, 0, scrambledLUT.length);
                this.scramble(scrambledLUT, random);
                while (count > 0) {
                    this.replaceStone(state, world, blockPos.func_177971_a(SMALL_OFFSET[scrambledLUT[--count]]), world.field_73011_w.getDimension(), true);
                }
                return;
            }
            if (quantity <= 26) {
                int[] scrambledLUT = new int[NORMAL_OFFSET_INDEX.length];
                System.arraycopy(NORMAL_OFFSET_INDEX, 0, scrambledLUT, 0, scrambledLUT.length);
                this.scramble(scrambledLUT, random);
                while (count > 0) {
                    this.replaceStone(state, world, blockPos.func_177971_a(NORMAL_OFFSET[scrambledLUT[--count]]), world.field_73011_w.getDimension(), true);
                }
                return;
            }
            double radius = Math.pow(quantity, 0.3333333333333333) * 0.238732414637843 + 2.0;
            int rSqr = (int)(radius * radius);
            if (random.nextBoolean()) {
                int dy = (int)(-1.0 * radius);
                while ((double)dy < radius) {
                    int dz = (int)(-1.0 * radius);
                    while ((double)dz < radius) {
                        int dx = (int)(-1.0 * radius);
                        while ((double)dx < radius) {
                            if (dx * dx + dy * dy + dz * dz <= rSqr) {
                                this.replaceStone(state, world, blockPos.func_177982_a(dx, dy, dz), world.field_73011_w.getDimension(), true);
                                --count;
                            }
                            if (count > 0) {
                                ++dx;
                                continue;
                            }
                            break block16;
                        }
                        ++dz;
                    }
                    ++dy;
                }
            } else {
                int dy = (int)(-1.0 * radius);
                while ((double)dy < radius) {
                    for (int dx = (int)radius; dx >= (int)(-1.0 * radius); --dx) {
                        for (int dz = (int)radius; dz >= (int)(-1.0 * radius); --dz) {
                            if (dx * dx + dy * dy + dz * dz <= rSqr) {
                                this.replaceStone(state, world, blockPos.func_177982_a(dx, dy, dz), world.field_73011_w.getDimension(), true);
                                --count;
                            }
                            if (count > 0) {
                                continue;
                            }
                            break block16;
                        }
                    }
                    ++dy;
                }
            }
        }
    }

    private void replaceStone(IBlockState state, World world, BlockPos pos, int dimension, boolean cacheOverflow) {
        if (pos.func_177956_o() < 0 || pos.func_177956_o() >= world.func_72800_K()) {
            return;
        }
        if (world.func_175697_a(pos, 0)) {
            if (world.func_175623_d(pos)) {
                return;
            }
            IBlockState bs = world.func_180495_p(pos);
            if (bs.func_177230_c().isReplaceableOreGen(bs, (IBlockAccess)world, pos, STONE_PREDICATE) || SPAWN_BLOCKS.contains(bs.func_177230_c())) {
                world.func_180501_a(pos, state, 2);
            }
        } else if (cacheOverflow) {
            this.cacheOverflowBlock(state, pos, dimension);
        }
    }

    private void cacheOverflowBlock(IBlockState state, BlockPos pos, int dimension) {
        BlockPos chunkCoord = new BlockPos(pos.func_177958_n() >> 4, pos.func_177956_o() >> 4, dimension);
        if (!OVERFLOW_CACHE.containsKey(chunkCoord)) {
            CACHE_ORDER.addLast((Vec3i)chunkCoord);
            if (CACHE_ORDER.size() > 1024) {
                Vec3i drop = CACHE_ORDER.removeFirst();
                OVERFLOW_CACHE.get(drop).clear();
                OVERFLOW_CACHE.remove(drop);
            }
            OVERFLOW_CACHE.put((Vec3i)chunkCoord, new HashMap());
        }
        Map<BlockPos, IBlockState> cache = OVERFLOW_CACHE.get(chunkCoord);
        cache.put(pos, state);
    }

    private Map<BlockPos, IBlockState> retrieveCache(Vec3i chunkCoord) {
        if (OVERFLOW_CACHE.containsKey(chunkCoord)) {
            Map<BlockPos, IBlockState> cache = OVERFLOW_CACHE.get(chunkCoord);
            CACHE_ORDER.remove(chunkCoord);
            OVERFLOW_CACHE.remove(chunkCoord);
            return cache;
        }
        return Collections.emptyMap();
    }

    private void scramble(int[] target, Random random) {
        for (int i = target.length - 1; i > 0; --i) {
            int n = random.nextInt(i);
            int temp = target[i];
            target[i] = target[n];
            target[n] = temp;
        }
    }
}

