/*
 * Decompiled with CFR 0.152.
 */
package mmd.orespawn.world;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapStorage;

public class OreSpawnData
extends WorldSavedData {
    public final Map<ChunkPos, NBTTagList> chunkData = new HashMap<ChunkPos, NBTTagList>();

    public OreSpawnData(String tag) {
        super(tag);
    }

    public void func_76184_a(NBTTagCompound compound) {
        this.chunkData.clear();
        NBTTagList list = compound.func_150295_c("List", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            int chunkX = data.func_74762_e("ChunkX");
            int chunkZ = data.func_74762_e("ChunkZ");
            NBTTagList generatedIDs = data.func_150295_c("GeneratedIDs", 8);
            this.chunkData.put(new ChunkPos(chunkX, chunkZ), generatedIDs);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<ChunkPos, NBTTagList> entry : this.chunkData.entrySet()) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74768_a("ChunkX", entry.getKey().field_77276_a);
            data.func_74768_a("ChunkZ", entry.getKey().field_77275_b);
            data.func_74782_a("GeneratedIDs", (NBTBase)entry.getValue());
            list.func_74742_a((NBTBase)data);
        }
        compound.func_74782_a("List", (NBTBase)list);
        return compound;
    }

    public static OreSpawnData getData(World world) {
        String tag = "orespawn";
        MapStorage storage = world.getPerWorldStorage();
        OreSpawnData data = (OreSpawnData)storage.func_75742_a(OreSpawnData.class, tag);
        if (data == null) {
            data = new OreSpawnData(tag);
            storage.func_75745_a(tag, (WorldSavedData)data);
        }
        return data;
    }
}

