/*
 * Decompiled with CFR 0.152.
 */
package mmd.orespawn.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import mmd.orespawn.OreSpawn;
import mmd.orespawn.api.DimensionLogic;
import mmd.orespawn.api.OreSpawnAPI;
import mmd.orespawn.api.SpawnEntry;
import mmd.orespawn.api.SpawnLogic;
import mmd.orespawn.util.StateUtil;
import net.minecraft.world.biome.Biome;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringEscapeUtils;

public enum OreSpawnWriter {
    INSTANCE;


    public void writeSpawnEntries() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        for (Map.Entry<String, SpawnLogic> entry : OreSpawn.API.getAllSpawnLogic().entrySet()) {
            File file = new File("." + File.separator + "orespawn", entry.getKey() + ".json");
            if (file.exists()) continue;
            Map<Integer, DimensionLogic> dimensions = entry.getValue().getAllDimensions();
            JsonArray array = new JsonArray();
            for (Map.Entry<Integer, DimensionLogic> dimension : dimensions.entrySet()) {
                JsonObject object = new JsonObject();
                if (dimension.getKey() != OreSpawnAPI.DIMENSION_WILDCARD) {
                    object.addProperty("dimension", (Number)dimension.getKey());
                }
                JsonArray ores = new JsonArray();
                Collection<SpawnEntry> entries = dimension.getValue().getEntries();
                for (SpawnEntry spawnEntry : entries) {
                    JsonObject ore = new JsonObject();
                    ore.addProperty("block", spawnEntry.getState().func_177230_c().getRegistryName().toString());
                    if (spawnEntry.getState() != spawnEntry.getState().func_177230_c().func_176223_P()) {
                        ore.addProperty("state", StateUtil.serializeState(spawnEntry.getState()));
                    }
                    ore.addProperty("size", (Number)spawnEntry.getSize());
                    ore.addProperty("variation", (Number)spawnEntry.getVariation());
                    ore.addProperty("frequency", (Number)spawnEntry.getFrequency());
                    ore.addProperty("min_height", (Number)spawnEntry.getMinHeight());
                    ore.addProperty("max_height", (Number)spawnEntry.getMaxHeight());
                    Biome[] biomeArray = spawnEntry.getBiomes();
                    if (biomeArray != null && biomeArray.length != 0) {
                        JsonArray biomes = new JsonArray();
                        for (Biome biome : biomeArray) {
                            biomes.add((JsonElement)new JsonPrimitive(biome.getRegistryName().toString()));
                        }
                        ore.add("biomes", (JsonElement)biomes);
                    }
                    ores.add((JsonElement)ore);
                }
                object.add("ores", (JsonElement)ores);
                array.add((JsonElement)object);
            }
            String json = gson.toJson((JsonElement)array);
            try {
                FileUtils.writeStringToFile((File)file, (String)StringEscapeUtils.unescapeJson((String)json), (Charset)Charsets.UTF_8);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

