/*
 * Decompiled with CFR 0.152.
 */
package mmd.orespawn.impl;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mmd.orespawn.OreSpawn;
import mmd.orespawn.api.DimensionLogic;
import mmd.orespawn.api.OreSpawnAPI;
import mmd.orespawn.api.SpawnEntry;
import mmd.orespawn.api.SpawnLogic;
import mmd.orespawn.impl.SpawnLogicImpl;
import mmd.orespawn.world.OreSpawnWorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class OreSpawnImpl
implements OreSpawnAPI {
    private final Map<String, SpawnLogic> spawnLogic = new HashMap<String, SpawnLogic>();
    private final Map<String, List<OreSpawnWorldGenerator>> worldGenerators = new HashMap<String, List<OreSpawnWorldGenerator>>();

    @Override
    public SpawnLogic createSpawnLogic() {
        return new SpawnLogicImpl();
    }

    @Override
    public SpawnLogic getSpawnLogic(String id) {
        return this.spawnLogic.get(id);
    }

    @Override
    public Map<String, SpawnLogic> getAllSpawnLogic() {
        return ImmutableMap.copyOf(this.spawnLogic);
    }

    public void registerSpawnLogic(String id, SpawnLogic spawnLogic) {
        this.spawnLogic.put(id, spawnLogic);
        Random random = new Random();
        ArrayList<OreSpawnWorldGenerator> list = new ArrayList<OreSpawnWorldGenerator>();
        for (Map.Entry<Integer, DimensionLogic> dimension : spawnLogic.getAllDimensions().entrySet()) {
            for (SpawnEntry entry : dimension.getValue().getEntries()) {
                OreSpawnWorldGenerator generator = new OreSpawnWorldGenerator(entry, dimension.getKey(), random.nextLong());
                list.add(generator);
                if (OreSpawn.DO_RETRO_GENERATION) continue;
                GameRegistry.registerWorldGenerator((IWorldGenerator)generator, (int)100);
            }
        }
        this.worldGenerators.put(id, list);
        OreSpawn.LOGGER.info("Registered spawn logic for mod " + id);
    }

    public Map<String, List<OreSpawnWorldGenerator>> getWorldGenerators() {
        return ImmutableMap.copyOf(this.worldGenerators);
    }
}

