/*
 * Decompiled with CFR 0.152.
 */
package mmd.orespawn;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import mmd.orespawn.EventHandler;
import mmd.orespawn.api.OreSpawnAPI;
import mmd.orespawn.api.SpawnLogic;
import mmd.orespawn.command.AddOreCommand;
import mmd.orespawn.command.ClearChunkCommand;
import mmd.orespawn.command.DumpBiomesCommand;
import mmd.orespawn.impl.OreSpawnImpl;
import mmd.orespawn.json.OreSpawnReader;
import mmd.orespawn.json.OreSpawnWriter;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="orespawn", name="OreSpawn", version="2.0.0", acceptedMinecraftVersions="[1.10.2]")
public class OreSpawn {
    public static final String VERSION = "2.0.0";
    public static final Logger LOGGER = LogManager.getLogger((String)"OreSpawn");
    public static final OreSpawnImpl API = new OreSpawnImpl();
    public static boolean DO_RETRO_GENERATION = true;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        DO_RETRO_GENERATION = config.getBoolean("retrogen", "general", true, "Generate ores in pre-existing chunks");
        config.save();
        MinecraftForge.EVENT_BUS.register((Object)EventHandler.INSTANCE);
        MinecraftForge.ORE_GEN_BUS.register((Object)EventHandler.INSTANCE);
        OreSpawnReader.INSTANCE.readSpawnEntries();
        FMLInterModComms.sendFunctionMessage((String)"orespawn", (String)"api", (String)"mmd.orespawn.VanillaOreSpawn");
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent event) {
        OreSpawnWriter.INSTANCE.writeSpawnEntries();
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new ClearChunkCommand());
        event.registerServerCommand((ICommand)new AddOreCommand());
        event.registerServerCommand((ICommand)new DumpBiomesCommand());
    }

    @Mod.EventHandler
    public void onIMC(FMLInterModComms.IMCEvent event) {
        event.getMessages().stream().filter(message -> message.key.equalsIgnoreCase("api")).forEach(message -> {
            Optional value = message.getFunctionValue(OreSpawnAPI.class, SpawnLogic.class);
            if (API.getSpawnLogic(message.getSender()) == null && value.isPresent()) {
                API.registerSpawnLogic(message.getSender(), (SpawnLogic)((Function)value.get()).apply((Object)API));
            }
        });
    }
}

