/*
 * Decompiled with CFR 0.152.
 */
package mmd.orespawn;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mmd.orespawn.OreSpawn;
import mmd.orespawn.world.OreSpawnData;
import mmd.orespawn.world.OreSpawnWorldGenerator;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public enum EventHandler {
    INSTANCE;


    @SubscribeEvent
    public void onChunkLoad(ChunkDataEvent.Load event) {
        if (OreSpawn.DO_RETRO_GENERATION) {
            WorldServer world = (WorldServer)event.getWorld();
            Chunk chunk = event.getChunk();
            this.generateChunk(world, chunk);
        }
    }

    @SubscribeEvent
    public void onPopulateChunk(PopulateChunkEvent event) {
        if (OreSpawn.DO_RETRO_GENERATION) {
            WorldServer world = (WorldServer)event.getWorld();
            Chunk chunk = world.func_72964_e(event.getChunkX(), event.getChunkZ());
            this.generateChunk(world, chunk);
        }
    }

    public void generateChunk(WorldServer world, Chunk chunk) {
        OreSpawnData data = OreSpawnData.getData((World)world);
        NBTTagList dataList = data.chunkData.get(chunk.func_76632_l());
        ArrayList<String> generatedIDs = new ArrayList<String>();
        if (dataList == null) {
            dataList = new NBTTagList();
        }
        for (int i = 0; i < dataList.func_74745_c(); ++i) {
            generatedIDs.add(dataList.func_150307_f(i));
        }
        for (Map.Entry<String, List<OreSpawnWorldGenerator>> entry : OreSpawn.API.getWorldGenerators().entrySet()) {
            if (generatedIDs.contains(entry.getKey())) continue;
            long worldSeed = world.func_72905_C();
            Random random = new Random(worldSeed);
            long xSeed = random.nextLong() >> 3;
            long zSeed = random.nextLong() >> 3;
            long chunkSeed = xSeed * (long)chunk.field_76635_g + zSeed * (long)chunk.field_76647_h ^ worldSeed;
            ChunkProviderServer chunkProvider = world.func_72863_F();
            IChunkGenerator chunkGenerator = chunkProvider.field_186029_c;
            for (OreSpawnWorldGenerator generator : entry.getValue()) {
                random.setSeed(chunkSeed);
                generator.generate(random, chunk.field_76635_g, chunk.field_76647_h, (World)world, chunkGenerator, (IChunkProvider)chunkProvider);
            }
            dataList.func_74742_a((NBTBase)new NBTTagString(entry.getKey()));
        }
        data.chunkData.put(chunk.func_76632_l(), dataList);
        data.func_76185_a();
    }

    @SubscribeEvent
    public void onGenerateMinable(OreGenEvent.GenerateMinable event) {
        event.setResult(Event.Result.DENY);
    }
}

