/*
 * Decompiled with CFR 0.152.
 */
package crazypants.util;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public class MagnetUtil {
    private static final String PREVENT_REMOTE_MOVEMENT = "PreventRemoteMovement";
    public static final String EIO_PULLER_TAG = "EIOpuller";

    public static boolean shouldAttract(@Nullable BlockPos pullerPos, @Nullable Entity entity) {
        if (entity == null || entity.field_70128_L) {
            return false;
        }
        if (entity instanceof IProjectile && entity.field_70181_x > 0.01) {
            return false;
        }
        NBTTagCompound data = entity.getEntityData();
        if (MagnetUtil.isReservedByOthers(data)) {
            return false;
        }
        if (!MagnetUtil.isReservedByEnderIO(data)) {
            if (pullerPos != null) {
                data.func_74772_a(EIO_PULLER_TAG, pullerPos.func_177986_g());
            }
            return true;
        }
        if (pullerPos == null) {
            return false;
        }
        long posL = data.func_74763_f(EIO_PULLER_TAG);
        if (posL == pullerPos.func_177986_g()) {
            return true;
        }
        BlockPos curOwner = BlockPos.func_177969_a((long)posL);
        double distToCur = curOwner.func_177957_d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        double distToMe = pullerPos.func_177957_d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        if (distToMe + 1.0 < distToCur) {
            data.func_74772_a(EIO_PULLER_TAG, pullerPos.func_177986_g());
            return true;
        }
        return false;
    }

    public static void release(@Nullable Entity entity) {
        if (entity != null && !entity.field_70128_L) {
            NBTTagCompound data = entity.getEntityData();
            data.func_82580_o(EIO_PULLER_TAG);
        }
    }

    public static boolean isReserved(Entity entity) {
        return MagnetUtil.isReservedByEnderIO(entity.getEntityData()) || MagnetUtil.isReservedByOthers(entity.getEntityData());
    }

    public static boolean isReservedByEnderIO(NBTTagCompound data) {
        return data.func_74764_b(EIO_PULLER_TAG);
    }

    public static boolean isReservedByOthers(NBTTagCompound data) {
        return data.func_74764_b(PREVENT_REMOTE_MOVEMENT);
    }
}

