/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.tool;

import com.mojang.authlib.GameProfile;
import crazypants.enderio.EnderIO;
import crazypants.enderio.api.tool.ITool;
import crazypants.enderio.tool.IToolProvider;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.context.BlockPosContext;
import net.minecraftforge.server.permission.context.IContext;

public class ToolUtil {
    private static ToolUtil instance;
    private final List<IToolProvider> toolProviders = new ArrayList<IToolProvider>();

    public static boolean isToolEquipped(EntityPlayer player, EnumHand hand) {
        return ToolUtil.getInstance().isToolEquippedImpl(player, hand);
    }

    public static ITool getEquippedTool(EntityPlayer player, EnumHand hand) {
        return ToolUtil.getInstance().getEquippedToolImpl(player, hand);
    }

    public static boolean breakBlockWithTool(Block block, World world, int x, int y, int z, EntityPlayer entityPlayer, EnumHand hand, String permissionNode) {
        return ToolUtil.breakBlockWithTool(block, world, new BlockPos(x, y, z), null, entityPlayer, hand, permissionNode);
    }

    public static boolean breakBlockWithTool(Block block, World world, BlockPos pos, EnumFacing side, EntityPlayer entityPlayer, EnumHand hand, String permissionNode) {
        return ToolUtil.breakBlockWithTool(block, world, pos, side, entityPlayer, entityPlayer.func_184586_b(hand), permissionNode);
    }

    public static boolean breakBlockWithTool(Block block, World world, BlockPos pos, EnumFacing side, EntityPlayer entityPlayer, ItemStack heldItem, String permissionNode) {
        ITool tool = ToolUtil.getToolFromStack(heldItem);
        if (tool != null && entityPlayer.func_70093_af() && tool.canUse(heldItem, entityPlayer, pos)) {
            IBlockState bs = world.func_180495_p(pos);
            if (!PermissionAPI.hasPermission((GameProfile)entityPlayer.func_146103_bH(), (String)permissionNode, (IContext)new BlockPosContext(entityPlayer, pos, bs, side))) {
                entityPlayer.func_145747_a((ITextComponent)new TextComponentString(EnderIO.lang.localize("wrench.permission.denied")));
                return false;
            }
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, bs, entityPlayer);
            event.setExpToDrop(0);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return false;
            }
            if (block.removedByPlayer(bs, world, pos, entityPlayer, true)) {
                block.func_180657_a(world, entityPlayer, pos, world.func_180495_p(pos), world.func_175625_s(pos), heldItem);
            }
            tool.used(heldItem, entityPlayer, pos);
            return true;
        }
        return false;
    }

    public static ToolUtil getInstance() {
        if (instance == null) {
            instance = new ToolUtil();
        }
        return instance;
    }

    private ToolUtil() {
    }

    public void registerToolProvider(IToolProvider toolProvider) {
        this.toolProviders.add(toolProvider);
    }

    private boolean isToolEquippedImpl(EntityPlayer player, EnumHand hand) {
        return this.getEquippedToolImpl(player, hand) != null;
    }

    private ITool getEquippedToolImpl(EntityPlayer player, EnumHand hand) {
        EntityPlayer entityPlayer = player = player == null ? EnderIO.proxy.getClientPlayer() : player;
        if (player == null) {
            return null;
        }
        ItemStack equipped = player.func_184586_b(hand);
        return ToolUtil.getToolFromStack(equipped);
    }

    public static ITool getToolFromStack(ItemStack equipped) {
        if (equipped == null) {
            return null;
        }
        if (equipped.func_77973_b() instanceof ITool) {
            return (ITool)equipped.func_77973_b();
        }
        return ToolUtil.getInstance().getToolImpl(equipped);
    }

    private ITool getToolImpl(ItemStack equipped) {
        for (IToolProvider provider : this.toolProviders) {
            ITool result = provider.getTool(equipped);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

