/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport;

import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.Util;
import com.enderio.core.common.vecmath.Camera;
import com.enderio.core.common.vecmath.Matrix4d;
import com.enderio.core.common.vecmath.VecmathUtil;
import com.enderio.core.common.vecmath.Vector2d;
import com.enderio.core.common.vecmath.Vector3d;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.api.teleport.IItemOfTravel;
import crazypants.enderio.api.teleport.ITravelAccessable;
import crazypants.enderio.api.teleport.TeleportEntityEvent;
import crazypants.enderio.api.teleport.TravelSource;
import crazypants.enderio.config.Config;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.teleport.anchor.BlockTravelAnchor;
import crazypants.enderio.teleport.packet.PacketOpenAuthGui;
import crazypants.enderio.teleport.packet.PacketTravelEvent;
import crazypants.util.Things;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MovementInput;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TravelController {
    public static final TravelController instance = new TravelController();
    private Random rand = new Random();
    private boolean wasJumping = false;
    private boolean wasSneaking = false;
    private int delayTimer = 0;
    private int timer = Config.travelAnchorCooldown;
    private boolean tempJump;
    private boolean tempSneak;
    private boolean showTargets = false;
    public BlockCoord onBlockCoord;
    public BlockCoord selectedCoord;
    Camera currentView = new Camera();
    private final HashMap<BlockCoord, Float> candidates = new HashMap();
    private boolean selectionEnabled = true;
    private double fovRad;
    private double tanFovRad;

    private TravelController() {
    }

    private boolean doesHandAllowTravel(EnumHand hand) {
        return Config.travelStaffOffhandTravelEnabled || hand == EnumHand.MAIN_HAND;
    }

    private boolean doesHandAllowBlink(EnumHand hand) {
        return Config.travelStaffOffhandBlinkEnabled || hand == EnumHand.MAIN_HAND;
    }

    private boolean doesHandAllowEnderIO(EnumHand hand) {
        return Config.travelStaffOffhandEnderIOEnabled || hand == EnumHand.MAIN_HAND;
    }

    public boolean activateTravelAccessable(ItemStack equipped, EnumHand hand, World world, EntityPlayer player, TravelSource source) {
        ITravelAccessable ta;
        if (!this.hasTarget()) {
            return false;
        }
        BlockCoord target = this.selectedCoord;
        TileEntity te = world.func_175625_s(target.getBlockPos());
        if (te instanceof ITravelAccessable && (ta = (ITravelAccessable)te).getRequiresPassword(player)) {
            PacketOpenAuthGui p = new PacketOpenAuthGui(target.getBlockPos());
            PacketHandler.INSTANCE.sendToServer((IMessage)p);
            return true;
        }
        if (this.doesHandAllowTravel(hand)) {
            this.travelToSelectedTarget(player, equipped, hand, source, false);
            return true;
        }
        return true;
    }

    public boolean doBlink(ItemStack equipped, EnumHand hand, EntityPlayer player) {
        BlockPos bp;
        if (!this.doesHandAllowBlink(hand)) {
            return false;
        }
        Vector3d eye = Util.getEyePositionEio((EntityPlayer)player);
        Vector3d look = Util.getLookVecEio((EntityPlayer)player);
        Vector3d sample = new Vector3d(look);
        sample.scale((double)Config.travelStaffMaxBlinkDistance);
        sample.add(eye);
        Vec3d eye3 = new Vec3d(eye.x, eye.y, eye.z);
        Vec3d end = new Vec3d(sample.x, sample.y, sample.z);
        double playerHeight = player.func_70033_W();
        double lookComp = -look.y * playerHeight;
        double maxDistance = (double)Config.travelStaffMaxBlinkDistance + lookComp;
        RayTraceResult p = player.field_70170_p.func_72901_a(eye3, end, !Config.travelStaffBlinkThroughClearBlocksEnabled);
        if (p == null) {
            for (double i = maxDistance; i > 1.0; i -= 1.0) {
                sample.set(look);
                sample.scale(i);
                sample.add(eye);
                sample.y -= playerHeight;
                if (!this.doBlinkAround(player, equipped, hand, sample, true)) continue;
                return true;
            }
            return false;
        }
        List res = Util.raytraceAll((World)player.field_70170_p, (Vec3d)eye3, (Vec3d)end, (!Config.travelStaffBlinkThroughClearBlocksEnabled ? 1 : 0) != 0);
        for (RayTraceResult pos : res) {
            IBlockState hitBlock;
            if (pos == null || !this.isBlackListedBlock(player, pos, hitBlock = player.field_70170_p.func_180495_p(pos.func_178782_a()))) continue;
            bp = pos.func_178782_a();
            maxDistance = Math.min(maxDistance, VecmathUtil.distance((Vector3d)eye, (Vector3d)new Vector3d((double)bp.func_177958_n() + 0.5, (double)bp.func_177956_o() + 0.5, (double)bp.func_177952_p() + 0.5)) - 1.5 - lookComp);
        }
        eye3 = new Vec3d(eye.x, eye.y, eye.z);
        Vector3d targetBc = new Vector3d(p.func_178782_a());
        double sampleDistance = 1.5;
        bp = p.func_178782_a();
        double teleDistance = VecmathUtil.distance((Vector3d)eye, (Vector3d)new Vector3d((double)bp.func_177958_n() + 0.5, (double)bp.func_177956_o() + 0.5, (double)bp.func_177952_p() + 0.5)) + sampleDistance;
        while (teleDistance < maxDistance) {
            sample.set(look);
            sample.scale(sampleDistance);
            sample.add(targetBc);
            sample.y -= playerHeight;
            if (this.doBlinkAround(player, equipped, hand, sample, false)) {
                return true;
            }
            teleDistance += 1.0;
            sampleDistance += 1.0;
        }
        sampleDistance = -0.5;
        for (teleDistance = VecmathUtil.distance((Vector3d)eye, (Vector3d)new Vector3d((double)bp.func_177958_n() + 0.5, (double)bp.func_177956_o() + 0.5, (double)bp.func_177952_p() + 0.5)) + sampleDistance; teleDistance > 1.0; teleDistance -= 1.0) {
            sample.set(look);
            sample.scale(sampleDistance);
            sample.add(targetBc);
            sample.y -= playerHeight;
            if (this.doBlinkAround(player, equipped, hand, sample, false)) {
                return true;
            }
            sampleDistance -= 1.0;
        }
        return false;
    }

    private boolean isBlackListedBlock(EntityPlayer player, RayTraceResult pos, IBlockState hitBlock) {
        return Things.TRAVEL_BLACKLIST.contains(hitBlock.func_177230_c()) && (hitBlock.func_185887_b(player.field_70170_p, pos.func_178782_a()) < 0.0f || !Config.travelStaffBlinkThroughUnbreakableBlocksEnabled);
    }

    private boolean doBlinkAround(EntityPlayer player, ItemStack equipped, EnumHand hand, Vector3d sample, boolean conserveMomentum) {
        if (this.doBlink(player, equipped, hand, new BlockCoord((int)Math.floor(sample.x), (int)Math.floor(sample.y) - 1, (int)Math.floor(sample.z)), conserveMomentum)) {
            return true;
        }
        if (this.doBlink(player, equipped, hand, new BlockCoord((int)Math.floor(sample.x), (int)Math.floor(sample.y), (int)Math.floor(sample.z)), conserveMomentum)) {
            return true;
        }
        return this.doBlink(player, equipped, hand, new BlockCoord((int)Math.floor(sample.x), (int)Math.floor(sample.y) + 1, (int)Math.floor(sample.z)), conserveMomentum);
    }

    private boolean doBlink(EntityPlayer player, ItemStack equipped, EnumHand hand, BlockCoord coord, boolean conserveMomentum) {
        return this.travelToLocation(player, equipped, hand, TravelSource.STAFF_BLINK, coord, conserveMomentum);
    }

    public boolean showTargets() {
        return this.showTargets && this.selectionEnabled;
    }

    public void setSelectionEnabled(boolean b) {
        this.selectionEnabled = b;
        if (!this.selectionEnabled) {
            this.candidates.clear();
        }
    }

    public boolean isBlockSelected(BlockCoord coord) {
        if (coord == null) {
            return false;
        }
        return coord.equals((Object)this.selectedCoord);
    }

    public void addCandidate(BlockCoord coord) {
        if (!this.candidates.containsKey(coord)) {
            this.candidates.put(coord, Float.valueOf(-1.0f));
        }
    }

    public int getMaxTravelDistanceSq() {
        return TravelSource.getMaxDistanceSq();
    }

    @SubscribeEvent
    public void onRender(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        Vector3d eye = Util.getEyePositionEio((EntityPlayer)mc.field_71439_g);
        Vector3d lookAt = Util.getLookVecEio((EntityPlayer)mc.field_71439_g);
        lookAt.add(eye);
        Matrix4d mv = VecmathUtil.createMatrixAsLookAt((Vector3d)eye, (Vector3d)lookAt, (Vector3d)new Vector3d(0.0, 1.0, 0.0));
        float fov = Minecraft.func_71410_x().field_71474_y.field_74334_X;
        Matrix4d pr = VecmathUtil.createProjectionMatrixAsPerspective((double)fov, (double)0.05f, (double)(mc.field_71474_y.field_151451_c * 16), (int)mc.field_71443_c, (int)mc.field_71440_d);
        this.currentView.setProjectionMatrix(pr);
        this.currentView.setViewMatrix(mv);
        this.currentView.setViewport(0, 0, mc.field_71443_c, mc.field_71440_d);
        this.fovRad = Math.toRadians(fov);
        this.tanFovRad = Math.tanh(this.fovRad);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                return;
            }
            this.onBlockCoord = this.getActiveTravelBlock(player);
            boolean onBlock = this.onBlockCoord != null;
            boolean bl = this.showTargets = onBlock || this.isTravelItemActiveForSelecting((EntityPlayer)player);
            if (this.showTargets) {
                this.updateSelectedTarget(player);
            } else {
                this.selectedCoord = null;
            }
            MovementInput input = player.field_71158_b;
            if (input == null) {
                return;
            }
            this.tempJump = input.field_78901_c;
            this.tempSneak = input.field_78899_d;
            if (input.field_78901_c && !this.wasJumping && onBlock && this.selectedCoord != null && this.delayTimer == 0 || input.field_78899_d && !this.wasSneaking && onBlock && this.selectedCoord != null && this.delayTimer == 0 && Config.travelAnchorSneak) {
                this.onInput(player);
                this.delayTimer = this.timer;
            }
            if (input.field_78901_c && !this.wasJumping && onBlock && this.selectedCoord == null && this.delayTimer == 0) {
                this.updateVerticalTarget(player, 1);
                this.onInput(player);
                this.delayTimer = this.timer;
            }
            if (input.field_78899_d && !this.wasSneaking && onBlock && this.selectedCoord == null && this.delayTimer == 0) {
                this.updateVerticalTarget(player, -1);
                this.onInput(player);
                this.delayTimer = this.timer;
            }
            if (this.delayTimer != 0) {
                --this.delayTimer;
            }
            this.wasJumping = this.tempJump;
            this.wasSneaking = this.tempSneak;
            this.candidates.clear();
        }
    }

    private boolean hasTarget() {
        return this.selectedCoord != null;
    }

    private int getEnergyInTravelItem(ItemStack equipped) {
        if (equipped == null || !(equipped.func_77973_b() instanceof IItemOfTravel)) {
            return 0;
        }
        return ((IItemOfTravel)equipped.func_77973_b()).getEnergyStored(equipped);
    }

    public boolean isTravelItemActiveForRendering(EntityPlayer ep) {
        if (ep == null) {
            return false;
        }
        return this.isTravelItemActive(ep, ep.func_184614_ca()) || Config.travelStaffOffhandShowsTravelTargets && this.isTravelItemActive(ep, ep.func_184592_cb());
    }

    private boolean isTravelItemActiveForSelecting(EntityPlayer ep) {
        if (ep == null) {
            return false;
        }
        return this.isTravelItemActive(ep, ep.func_184614_ca()) || this.isTravelItemActive(ep, ep.func_184592_cb());
    }

    private boolean isTravelItemActive(EntityPlayer ep, ItemStack equipped) {
        return equipped != null && equipped.func_77973_b() instanceof IItemOfTravel && ((IItemOfTravel)equipped.func_77973_b()).isActive(ep, equipped);
    }

    private boolean travelToSelectedTarget(EntityPlayer player, ItemStack equipped, EnumHand hand, TravelSource source, boolean conserveMomentum) {
        return this.travelToLocation(player, equipped, hand, source, this.selectedCoord, conserveMomentum);
    }

    private boolean travelToLocation(EntityPlayer player, ItemStack equipped, EnumHand hand, TravelSource source, BlockCoord coord, boolean conserveMomentum) {
        ITravelAccessable ta;
        TileEntity te;
        if (source != TravelSource.STAFF_BLINK && (te = player.field_70170_p.func_175625_s(coord.getBlockPos())) instanceof ITravelAccessable && !(ta = (ITravelAccessable)te).canBlockBeAccessed(player)) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("enderio.gui.travelAccessable.unauthorised", new Object[0]));
            return false;
        }
        int requiredPower = 0;
        requiredPower = this.getRequiredPower(player, equipped, source, coord);
        if (requiredPower < 0) {
            return false;
        }
        if (!this.isInRangeTarget(player, coord, source.getMaxDistanceTravelledSq())) {
            if (source != TravelSource.STAFF_BLINK) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("enderio.blockTravelPlatform.outOfRange", new Object[0]));
            }
            return false;
        }
        if (!this.isValidTarget(player, coord, source)) {
            if (source != TravelSource.STAFF_BLINK) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("enderio.blockTravelPlatform.invalidTarget", new Object[0]));
            }
            return false;
        }
        if (this.doClientTeleport((Entity)player, hand, coord, source, requiredPower, conserveMomentum)) {
            for (int i = 0; i < 6; ++i) {
                player.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, player.field_70165_t + (this.rand.nextDouble() - 0.5), player.field_70163_u + this.rand.nextDouble() * (double)player.field_70131_O - 0.25, player.field_70161_v + (this.rand.nextDouble() - 0.5), (this.rand.nextDouble() - 0.5) * 2.0, -this.rand.nextDouble(), (this.rand.nextDouble() - 0.5) * 2.0, new int[0]);
            }
        }
        return true;
    }

    private int getRequiredPower(EntityPlayer player, ItemStack equipped, TravelSource source, BlockCoord coord) {
        int canUsePower;
        if (!this.isTravelItemActive(player, equipped)) {
            return 0;
        }
        int requiredPower = (int)(this.getDistance(player, coord) * (double)source.getPowerCostPerBlockTraveledRF());
        if (requiredPower > (canUsePower = this.getEnergyInTravelItem(equipped))) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("enderio.itemTravelStaff.notEnoughPower", new Object[0]));
            return -1;
        }
        return requiredPower;
    }

    private boolean isInRangeTarget(EntityPlayer player, BlockCoord bc, float maxSq) {
        return this.getDistanceSquared(player, bc) <= (double)maxSq;
    }

    private double getDistanceSquared(EntityPlayer player, BlockCoord bc) {
        if (player == null || bc == null) {
            return 0.0;
        }
        Vector3d eye = Util.getEyePositionEio((EntityPlayer)player);
        Vector3d target = new Vector3d((double)bc.x + 0.5, (double)bc.y + 0.5, (double)bc.z + 0.5);
        return eye.distanceSquared(target);
    }

    private double getDistance(EntityPlayer player, BlockCoord coord) {
        return Math.sqrt(this.getDistanceSquared(player, coord));
    }

    private boolean isValidTarget(EntityPlayer player, BlockCoord bc, TravelSource source) {
        if (bc == null) {
            return false;
        }
        World w = player.field_70170_p;
        BlockCoord baseLoc = bc;
        if (source != TravelSource.STAFF_BLINK) {
            baseLoc = bc.getLocation(EnumFacing.UP);
        }
        return this.canTeleportTo(player, source, baseLoc, w) && this.canTeleportTo(player, source, baseLoc.getLocation(EnumFacing.UP), w);
    }

    private boolean canTeleportTo(EntityPlayer player, TravelSource source, BlockCoord bc, World w) {
        Vec3d target;
        Vec3d start;
        if (bc.y < 1) {
            return false;
        }
        if (source == TravelSource.STAFF_BLINK && !Config.travelStaffBlinkThroughSolidBlocksEnabled && !this.canBlinkTo(bc, w, start = Util.getEyePosition((EntityPlayer)player), target = new Vec3d((double)((float)bc.x + 0.5f), (double)((float)bc.y + 0.5f), (double)((float)bc.z + 0.5f)))) {
            return false;
        }
        IBlockState bs = w.func_180495_p(bc.getBlockPos());
        Block block = bs.func_177230_c();
        if (block == null || block.isAir(bs, (IBlockAccess)w, bc.getBlockPos())) {
            return true;
        }
        AxisAlignedBB aabb = bs.func_185900_c((IBlockAccess)w, bc.getBlockPos());
        return aabb == null || aabb.func_72320_b() < 0.7;
    }

    private boolean canBlinkTo(BlockCoord bc, World w, Vec3d start, Vec3d target) {
        RayTraceResult p = w.func_72901_a(start, target, !Config.travelStaffBlinkThroughClearBlocksEnabled);
        if (p != null) {
            Block block;
            if (!Config.travelStaffBlinkThroughClearBlocksEnabled) {
                return false;
            }
            IBlockState bs = w.func_180495_p(p.func_178782_a());
            if (this.isClear(w, bs, block = bs.func_177230_c(), p.func_178782_a())) {
                if (new BlockCoord(p).equals((Object)bc)) {
                    return true;
                }
                Vector3d sv = new Vector3d(start.field_72450_a, start.field_72448_b, start.field_72449_c);
                Vector3d rayDir = new Vector3d(target.field_72450_a, target.field_72448_b, target.field_72449_c);
                rayDir.sub(sv);
                rayDir.normalize();
                rayDir.add(sv);
                return this.canBlinkTo(bc, w, new Vec3d(rayDir.x, rayDir.y, rayDir.z), target);
            }
            return false;
        }
        return true;
    }

    private boolean isClear(World w, IBlockState bs, Block block, BlockPos bp) {
        if (block == null || block.isAir(bs, (IBlockAccess)w, bp)) {
            return true;
        }
        AxisAlignedBB aabb = bs.func_185900_c((IBlockAccess)w, bp);
        if (aabb == null || aabb.func_72320_b() < 0.7) {
            return true;
        }
        return block.getLightOpacity(bs, (IBlockAccess)w, bp) < 2;
    }

    @SideOnly(value=Side.CLIENT)
    private void updateVerticalTarget(EntityPlayerSP player, int direction) {
        BlockCoord currentBlock = this.getActiveTravelBlock(player);
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        int i = 0;
        for (int y = currentBlock.y + direction; i < Config.travelAnchorMaximumDistance && y >= 0 && y <= 255; ++i, y += direction) {
            TileEntity selectedBlock = world.func_175625_s(new BlockPos(currentBlock.x, y, currentBlock.z));
            if (!(selectedBlock instanceof ITravelAccessable)) continue;
            ITravelAccessable travelBlock = (ITravelAccessable)selectedBlock;
            BlockCoord targetBlock = new BlockCoord(currentBlock.x, y, currentBlock.z);
            if (Config.travelAnchorSkipWarning) {
                if (travelBlock.getRequiresPassword((EntityPlayer)player)) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("enderio.gui.travelAccessable.skipLocked", new Object[0]));
                }
                if (travelBlock.getAccessMode() == ITravelAccessable.AccessMode.PRIVATE && !travelBlock.canUiBeAccessed((EntityPlayer)player)) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("enderio.gui.travelAccessable.skipPrivate", new Object[0]));
                }
                if (!this.isValidTarget((EntityPlayer)player, targetBlock, TravelSource.BLOCK)) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("enderio.gui.travelAccessable.skipObstructed", new Object[0]));
                }
            }
            if (!travelBlock.canBlockBeAccessed((EntityPlayer)player) || !this.isValidTarget((EntityPlayer)player, targetBlock, TravelSource.BLOCK)) continue;
            this.selectedCoord = targetBlock;
            return;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateSelectedTarget(EntityPlayerSP player) {
        this.selectedCoord = null;
        if (this.candidates.isEmpty()) {
            return;
        }
        double closestDistance = Double.MAX_VALUE;
        for (BlockCoord bc : this.candidates.keySet()) {
            double d;
            if (bc.equals((Object)this.onBlockCoord) || !((d = this.addRatio(bc)) < closestDistance)) continue;
            this.selectedCoord = bc;
            closestDistance = d;
        }
        if (this.selectedCoord != null) {
            Vector3d blockCenter = new Vector3d((double)this.selectedCoord.x + 0.5, (double)this.selectedCoord.y + 0.5, (double)this.selectedCoord.z + 0.5);
            Vector2d blockCenterPixel = this.currentView.getScreenPoint(blockCenter);
            Vector2d screenMidPixel = new Vector2d((double)Minecraft.func_71410_x().field_71443_c, (double)Minecraft.func_71410_x().field_71440_d);
            screenMidPixel.scale(0.5);
            double pixDist = blockCenterPixel.distance(screenMidPixel);
            double rat = pixDist / (double)Minecraft.func_71410_x().field_71440_d;
            if (rat != rat) {
                rat = 0.0;
            }
            if (rat > 0.07) {
                this.selectedCoord = null;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void onInput(EntityPlayerSP player) {
        ITravelAccessable ta;
        MovementInput input = player.field_71158_b;
        BlockCoord target = TravelController.instance.selectedCoord;
        if (target == null) {
            return;
        }
        TileEntity te = player.field_70170_p.func_175625_s(new BlockPos(target.x, target.y, target.z));
        if (te instanceof ITravelAccessable && (ta = (ITravelAccessable)te).getRequiresPassword((EntityPlayer)player)) {
            PacketOpenAuthGui p = new PacketOpenAuthGui(target.getBlockPos());
            PacketHandler.INSTANCE.sendToServer((IMessage)p);
            return;
        }
        if (this.travelToSelectedTarget((EntityPlayer)player, null, null, TravelSource.BLOCK, false)) {
            input.field_78901_c = false;
            try {
                ObfuscationReflectionHelper.setPrivateValue(EntityPlayer.class, (Object)player, (Object)0, (String[])new String[]{"flyToggleTimer", "field_71101_bC"});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public double getScaleForCandidate(Vector3d loc) {
        if (!this.currentView.isValid()) {
            return 1.0;
        }
        BlockCoord bc = new BlockCoord(loc.x, loc.y, loc.z);
        float ratio = -1.0f;
        Float r = this.candidates.get(bc);
        if (r != null) {
            ratio = r.floatValue();
        }
        if (ratio < 0.0f) {
            this.addRatio(bc);
            ratio = this.candidates.get(bc).floatValue();
        }
        float start = 0.2f;
        float end = 0.01f;
        double mix = MathHelper.func_76131_a((float)((start - ratio) / (start - end)), (float)0.0f, (float)1.0f);
        double scale = 1.0;
        if (mix > 0.0) {
            Vector3d eyePoint = Util.getEyePositionEio((EntityPlayer)EnderIO.proxy.getClientPlayer());
            scale = this.tanFovRad * eyePoint.distance(loc);
            scale *= (double)Config.travelAnchorZoomScale;
            float nf = 1.0f - MathHelper.func_76131_a((float)((float)eyePoint.distanceSquared(loc) / (float)TravelSource.STAFF.getMaxDistanceTravelledSq()), (float)0.0f, (float)1.0f);
            scale *= 0.3 + 0.7 * (double)nf;
            scale = scale * mix + (1.0 - mix);
            scale = Math.max(1.01, scale);
        }
        return scale;
    }

    private double addRatio(BlockCoord bc) {
        Vector2d sp = this.currentView.getScreenPoint(new Vector3d((double)bc.x + 0.5, (double)bc.y + 0.5, (double)bc.z + 0.5));
        Vector2d mid = new Vector2d((double)Minecraft.func_71410_x().field_71443_c, (double)Minecraft.func_71410_x().field_71440_d);
        mid.scale(0.5);
        double d = sp.distance(mid);
        if (d != d) {
            d = 0.0;
        }
        float ratio = (float)d / (float)Minecraft.func_71410_x().field_71443_c;
        this.candidates.put(bc, Float.valueOf(ratio));
        return d;
    }

    public boolean doClientTeleport(Entity entity, EnumHand hand, BlockCoord bc, TravelSource source, int powerUse, boolean conserveMomentum) {
        TeleportEntityEvent evt = new TeleportEntityEvent(entity, source, bc.x, bc.y, bc.z, entity.field_71093_bK);
        if (MinecraftForge.EVENT_BUS.post((Event)evt)) {
            return false;
        }
        bc = new BlockCoord(evt.targetX, evt.targetY, evt.targetZ);
        PacketTravelEvent p = new PacketTravelEvent(entity, bc.x, bc.y, bc.z, powerUse, conserveMomentum, source, hand);
        PacketHandler.INSTANCE.sendToServer((IMessage)p);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private BlockCoord getActiveTravelBlock(EntityPlayerSP player) {
        int z;
        int y;
        int x;
        BlockPos pos;
        Block block;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world != null && player != null && (block = world.func_180495_p(pos = new BlockPos(x = MathHelper.func_76128_c((double)player.field_70165_t), y = MathHelper.func_76128_c((double)player.func_174813_aQ().field_72338_b) - 1, z = MathHelper.func_76128_c((double)player.field_70161_v))).func_177230_c()) instanceof BlockTravelAnchor && (Config.telepadIsTravelAnchor || block != ModObject.blockTelePad.getBlock())) {
            return new BlockCoord(x, y, z);
        }
        return null;
    }
}

