/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.power;

import crazypants.enderio.EnderIO;
import crazypants.enderio.power.PowerHandlerUtil;
import crazypants.util.TextUtil;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PowerDisplayUtil {
    private static final NumberFormat INT_NF;
    private static final NumberFormat FLOAT_NF;
    private static final boolean REPLACE_NBSP;
    private static final char NBSP = '\u00a0';

    public static String perTickStr() {
        return EnderIO.lang.localize("power.tick");
    }

    public static String ofStr() {
        return EnderIO.lang.localize("gui.powerMonitor.of");
    }

    public static String getStoredEnergyString(ItemStack item) {
        if (item == null) {
            return null;
        }
        IEnergyStorage ci = PowerHandlerUtil.getCapability((ICapabilityProvider)item, null);
        if (ci == null) {
            return null;
        }
        return EnderIO.lang.localize("item.tooltip.power") + " " + PowerDisplayUtil.formatPower(ci.getEnergyStored()) + "/" + PowerDisplayUtil.formatPower(ci.getMaxEnergyStored()) + " " + PowerDisplayUtil.abrevation();
    }

    public static String formatPowerPerTick(int powerPerTick) {
        return PowerDisplayUtil.formatPower(powerPerTick) + " " + PowerDisplayUtil.abrevation() + PowerDisplayUtil.perTickStr();
    }

    public static String formatStoredPower(int amount, int capacity) {
        return PowerDisplayUtil.formatPower(amount) + "/" + PowerDisplayUtil.formatPower(capacity) + " " + PowerDisplayUtil.abrevation();
    }

    public static String formatPower(long amount) {
        return TextUtil.fix(INT_NF.format(amount));
    }

    public static String formatInteger(int value) {
        return PowerDisplayUtil.formatPower(value);
    }

    public static String formatInteger(float value) {
        return PowerDisplayUtil.formatPower((long)value);
    }

    public static String formatPower(int powerRF) {
        return TextUtil.fix(INT_NF.format(powerRF));
    }

    public static String formatPowerFloat(float averageRfTickSent) {
        return FLOAT_NF.format(averageRfTickSent);
    }

    public static Integer parsePower(String power) {
        if (power == null) {
            return null;
        }
        try {
            Number d;
            if (REPLACE_NBSP) {
                power = power.replace(' ', '\u00a0');
            }
            if ((d = INT_NF.parse(power)) == null) {
                return null;
            }
            return d.intValue();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String abrevation() {
        return EnderIO.lang.localize("power.rf");
    }

    @SideOnly(value=Side.CLIENT)
    public static int parsePower(GuiTextField tf) {
        String txt = tf.func_146179_b();
        try {
            Integer power = PowerDisplayUtil.parsePower(txt);
            if (power == null) {
                return -1;
            }
            return power;
        }
        catch (Exception e) {
            return -1;
        }
    }

    static {
        DecimalFormatSymbols syms;
        INT_NF = NumberFormat.getIntegerInstance();
        FLOAT_NF = NumberFormat.getInstance();
        boolean res = false;
        if (INT_NF instanceof DecimalFormat && (syms = ((DecimalFormat)INT_NF).getDecimalFormatSymbols()).getGroupingSeparator() == '\u00a0') {
            res = true;
        }
        REPLACE_NBSP = res;
        FLOAT_NF.setMinimumFractionDigits(1);
        FLOAT_NF.setMaximumFractionDigits(1);
    }
}

