/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.painter.blocks;

import com.google.common.base.Predicate;
import crazypants.util.CapturedMob;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;

public enum EnumPressurePlateType implements IStringSerializable
{
    WOOD(Entity.class),
    STONE(EntityLivingBase.class),
    IRON(CountingMode.ENTITIES, Entity.class),
    GOLD(CountingMode.ITEMS, EntityItem.class),
    DARKSTEEL(EntityPlayer.class),
    SOULARIUM(EntityLiving.class, EntitySlime.class, EntityGhast.class, EntityMob.class),
    TUNED(EntityLivingBase.class){

        @Override
        public Predicate<Entity> getPredicate(final CapturedMob capturedMob) {
            return new Predicate<Entity>(){

                public boolean apply(@Nullable Entity entity) {
                    if (capturedMob == null || entity == null || !entity.func_70089_S() || entity.func_145773_az() || entity instanceof EntityPlayer && ((EntityPlayer)entity).func_175149_v()) {
                        return false;
                    }
                    return capturedMob.isSameType(entity);
                }

                public int hashCode() {
                    return super.hashCode();
                }

                public boolean equals(@Nullable Object obj) {
                    return super.equals(obj);
                }
            };
        }
    };

    private final CountingMode countingMode;
    private final Class<? extends Entity> searchClass;
    private final List<Class<? extends Entity>> whiteClasses;

    private EnumPressurePlateType(Class<? extends Entity> searchClass) {
        this.countingMode = CountingMode.BINARY;
        this.searchClass = searchClass;
        this.whiteClasses = Collections.emptyList();
    }

    private EnumPressurePlateType(Class<? extends Entity> searchClass, Class<? extends Entity> ... whiteClasses) {
        this.countingMode = CountingMode.BINARY;
        this.searchClass = searchClass;
        this.whiteClasses = Arrays.asList(whiteClasses);
    }

    private EnumPressurePlateType(CountingMode countingMode, Class<? extends Entity> searchClass) {
        this.countingMode = countingMode;
        this.searchClass = searchClass;
        this.whiteClasses = Collections.emptyList();
    }

    private EnumPressurePlateType(CountingMode countingMode, Class<? extends Entity> searchClass, Class<? extends Entity> ... whiteClasses) {
        this.countingMode = countingMode;
        this.searchClass = searchClass;
        this.whiteClasses = Arrays.asList(whiteClasses);
    }

    public String func_176610_l() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    public String getUnlocName(Item me) {
        return me.func_77658_a() + "." + this.func_176610_l();
    }

    public static EnumPressurePlateType getTypeFromMeta(int meta) {
        int meta1 = meta >> 1;
        return EnumPressurePlateType.values()[meta1 >= 0 && meta1 < EnumPressurePlateType.values().length ? meta1 : 0];
    }

    public static boolean getSilentFromMeta(int meta) {
        return (meta & 1) != 0;
    }

    public static int getMetaFromType(EnumPressurePlateType value, Boolean isSilent) {
        return value.ordinal() << 1 | (isSilent != false ? 1 : 0);
    }

    public int getMetaFromType(Boolean isSilent) {
        return EnumPressurePlateType.getMetaFromType(this, isSilent);
    }

    public int getMetaFromType() {
        return EnumPressurePlateType.getMetaFromType(this, false);
    }

    protected CountingMode getCountingMode() {
        return this.countingMode;
    }

    public Class<? extends Entity> getSearchClass() {
        return this.searchClass;
    }

    public Predicate<Entity> getPredicate(CapturedMob capturedMob) {
        return new Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                if (entity == null || !entity.func_70089_S() || entity.func_145773_az() || entity instanceof EntityPlayer && ((EntityPlayer)entity).func_175149_v()) {
                    return false;
                }
                if (EnumPressurePlateType.this.searchClass.isInstance(entity) && EnumPressurePlateType.this.whiteClasses.isEmpty()) {
                    return true;
                }
                for (Class clazz : EnumPressurePlateType.this.whiteClasses) {
                    if (!clazz.isInstance(entity)) continue;
                    return true;
                }
                return false;
            }

            public int hashCode() {
                return super.hashCode();
            }

            public boolean equals(@Nullable Object obj) {
                return super.equals(obj);
            }
        };
    }

    public static enum CountingMode {
        BINARY{

            @Override
            public int count(List<Entity> list) {
                return list.isEmpty() ? 0 : 15;
            }
        }
        ,
        ENTITIES{

            @Override
            public int count(List<Entity> list) {
                return Math.min(15, list.size());
            }
        }
        ,
        ITEMS{

            @Override
            public int count(List<Entity> list) {
                int result = 0;
                for (Entity entity : list) {
                    if (!(entity instanceof EntityItem)) continue;
                    ItemStack stack = ((EntityItem)entity).func_92059_d();
                    if ((result += stack.field_77994_a) < 15) continue;
                    return 15;
                }
                return Math.min(15, result);
            }
        };


        public abstract int count(List<Entity> var1);
    }
}

