/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm.farmers;

import crazypants.enderio.config.Config;
import crazypants.enderio.machine.farm.FarmNotification;
import crazypants.enderio.machine.farm.FarmStationContainer;
import crazypants.enderio.machine.farm.TileFarmStation;
import crazypants.enderio.machine.farm.farmers.HarvestResult;
import crazypants.enderio.machine.farm.farmers.IFarmerJoe;
import crazypants.enderio.machine.farm.farmers.IHarvestResult;
import crazypants.enderio.machine.farm.farmers.TreeHarvestUtil;
import crazypants.util.Prep;
import crazypants.util.Things;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.event.ForgeEventFactory;

public class TreeFarmer
implements IFarmerJoe {
    private static final HeightComparator comp = new HeightComparator();
    protected Block sapling;
    protected ItemStack saplingItem;
    protected Things woods;
    protected TreeHarvestUtil harvester = new TreeHarvestUtil();
    private boolean ignoreMeta = false;

    public TreeFarmer(Block sapling, Things wood) {
        this.sapling = sapling;
        if (sapling != null) {
            this.saplingItem = new ItemStack(sapling);
            FarmStationContainer.slotItemsSeeds.add(this.saplingItem);
        }
        this.woods = wood;
        for (ItemStack awood : this.woods.getItemStacks()) {
            FarmStationContainer.slotItemsProduce.add(awood);
        }
    }

    private static Things makeThings(Block ... wood) {
        Things result = new Things(new String[0]);
        for (Block block : wood) {
            result.add(block);
        }
        return result;
    }

    public TreeFarmer(Block sapling, Block ... wood) {
        this(sapling, TreeFarmer.makeThings(wood));
    }

    public TreeFarmer(boolean ignoreMeta, Block sapling, Block ... wood) {
        this(sapling, wood);
        this.ignoreMeta = ignoreMeta;
    }

    @Override
    public boolean canHarvest(TileFarmStation farm, BlockPos bc, Block block, IBlockState bs) {
        return this.isWood(block);
    }

    protected boolean isWood(Block block) {
        return this.woods.contains(block);
    }

    @Override
    public boolean canPlant(ItemStack stack) {
        return Prep.isValid(stack) && stack.func_77973_b() == this.saplingItem.func_77973_b();
    }

    @Override
    public boolean prepareBlock(TileFarmStation farm, BlockPos bc, Block block, IBlockState meta) {
        if (block == this.sapling) {
            return true;
        }
        return this.plantFromInventory(farm, bc, block, meta);
    }

    protected boolean plantFromInventory(TileFarmStation farm, BlockPos bc, Block block, IBlockState meta) {
        ItemStack seed;
        World worldObj = farm.func_145831_w();
        if (this.canPlant(worldObj, bc) && Prep.isValid(seed = farm.takeSeedFromSupplies(this.saplingItem, bc, false))) {
            return this.plant(farm, worldObj, bc, seed);
        }
        return false;
    }

    protected boolean canPlant(World worldObj, BlockPos bc) {
        BlockPos grnPos = bc.func_177977_b();
        IBlockState bs = worldObj.func_180495_p(grnPos);
        Block ground = bs.func_177230_c();
        IPlantable plantable = (IPlantable)this.sapling;
        return this.sapling.func_176196_c(worldObj, bc) && ground.canSustainPlant(bs, (IBlockAccess)worldObj, grnPos, EnumFacing.UP, plantable);
    }

    protected boolean plant(TileFarmStation farm, World worldObj, BlockPos bc, ItemStack seed) {
        worldObj.func_175698_g(bc);
        if (this.canPlant(worldObj, bc)) {
            worldObj.func_180501_a(bc, this.sapling.func_176203_a(seed.func_77952_i()), 3);
            farm.actionPerformed(false);
            return true;
        }
        return false;
    }

    @Override
    public IHarvestResult harvestBlock(TileFarmStation farm, BlockPos bc, Block block, IBlockState meta) {
        boolean hasAxe = farm.hasAxe();
        if (!hasAxe) {
            farm.setNotification(FarmNotification.NO_AXE);
            return null;
        }
        World worldObj = farm.func_145831_w();
        EntityPlayerMP fakePlayer = farm.getFakePlayer();
        int fortune = farm.getMaxLootingValue();
        HarvestResult res = new HarvestResult();
        this.harvester.harvest(farm, this, bc, res);
        Collections.sort(res.harvestedBlocks, comp);
        ArrayList<BlockPos> actualHarvests = new ArrayList<BlockPos>();
        boolean hasShears = farm.hasShears();
        int noShearingPercentage = farm.isLowOnSaplings(bc);
        int shearCount = 0;
        for (int i = 0; i < res.harvestedBlocks.size() && hasAxe; ++i) {
            List drops;
            BlockPos coord = res.harvestedBlocks.get(i);
            Block blk = farm.getBlock(coord);
            boolean wasSheared = false;
            boolean wasAxed = false;
            boolean wasWood = this.isWood(blk);
            float chance = 1.0f;
            if (blk instanceof IShearable && hasShears && shearCount / res.harvestedBlocks.size() + noShearingPercentage < 100) {
                drops = ((IShearable)blk).onSheared(farm.getTool(TileFarmStation.ToolType.SHEARS), (IBlockAccess)worldObj, coord, 0);
                wasSheared = true;
                shearCount += 100;
            } else {
                drops = blk.getDrops((IBlockAccess)worldObj, coord, farm.getBlockState(coord), fortune);
                farm.setJoeUseItem(farm.getTool(TileFarmStation.ToolType.AXE));
                chance = ForgeEventFactory.fireBlockHarvesting((List)drops, (World)fakePlayer.field_70170_p, (BlockPos)coord, (IBlockState)farm.getBlockState(coord), (int)fortune, (float)chance, (boolean)false, (EntityPlayer)fakePlayer);
                farm.clearJoeUseItem(true);
                wasAxed = true;
            }
            if (drops != null) {
                for (ItemStack drop : drops) {
                    if (!(worldObj.field_73012_v.nextFloat() <= chance)) continue;
                    res.drops.add(new EntityItem(worldObj, (double)bc.func_177958_n() + 0.5, (double)bc.func_177956_o() + 0.5, (double)bc.func_177952_p() + 0.5, drop.func_77946_l()));
                }
            }
            if (wasAxed && !wasWood) {
                wasAxed = Config.farmAxeDamageOnLeafBreak;
            }
            farm.actionPerformed(wasWood || wasSheared);
            if (wasAxed) {
                farm.damageAxe(blk, new BlockPos((Vec3i)coord));
                hasAxe = farm.hasAxe();
            } else if (wasSheared) {
                farm.damageShears(blk, new BlockPos((Vec3i)coord));
                hasShears = farm.hasShears();
            }
            farm.func_145831_w().func_175698_g(coord);
            actualHarvests.add(coord);
        }
        farm.clearJoeUseItem(false);
        if (!hasAxe) {
            farm.setNotification(FarmNotification.NO_AXE);
        }
        res.harvestedBlocks.clear();
        res.harvestedBlocks.addAll(actualHarvests);
        this.tryReplanting(farm, worldObj, bc, res);
        return res;
    }

    protected void tryReplanting(TileFarmStation farm, World worldObj, BlockPos bc, HarvestResult res) {
        ItemStack seedTypeInSuppliesFor;
        if (!farm.isOpen(bc)) {
            return;
        }
        ItemStack allowedSeed = Prep.getEmpty();
        int supplySlotForCoord = farm.getSupplySlotForCoord(bc);
        if (farm.isSlotLocked(supplySlotForCoord) && Prep.isValid(seedTypeInSuppliesFor = farm.getSeedTypeInSuppliesFor(supplySlotForCoord))) {
            allowedSeed = seedTypeInSuppliesFor;
        }
        for (EntityItem drop : res.drops) {
            if (!Prep.isInvalid(allowedSeed) && !ItemStack.func_179545_c((ItemStack)allowedSeed, (ItemStack)drop.func_92059_d()) || !this.canPlant(drop.func_92059_d()) || !this.plant(farm, worldObj, bc, drop.func_92059_d())) continue;
            res.drops.remove(drop);
            return;
        }
    }

    public boolean getIgnoreMeta() {
        return this.ignoreMeta;
    }

    public void setIgnoreMeta(boolean ignoreMeta) {
        this.ignoreMeta = ignoreMeta;
    }

    private static class HeightComparator
    implements Comparator<BlockPos> {
        private HeightComparator() {
        }

        @Override
        public int compare(BlockPos o1, BlockPos o2) {
            return HeightComparator.compare(o2.func_177956_o(), o1.func_177956_o());
        }

        public static int compare(int x, int y) {
            return x < y ? -1 : (x == y ? 0 : 1);
        }
    }
}

