/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.capbank.packet;

import crazypants.enderio.Log;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.machine.capbank.TileCapBank;
import crazypants.enderio.machine.capbank.network.ICapBankNetwork;
import crazypants.enderio.machine.capbank.packet.PacketCapBank;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketGuiChange
extends PacketCapBank<PacketGuiChange, IMessage> {
    private int maxSend;
    private int maxRec;
    private RedstoneControlMode inputMode;
    private RedstoneControlMode outputMode;

    public PacketGuiChange() {
    }

    public PacketGuiChange(TileCapBank capBank) {
        super(capBank);
        ICapBankNetwork network = capBank.getNetwork();
        this.maxSend = network.getMaxOutput();
        this.maxRec = network.getMaxInput();
        this.inputMode = network.getInputControlMode();
        this.outputMode = network.getOutputControlMode();
        if (Config.debugTraceCapLimitsExtremelyDetailed) {
            StringBuilder sb = new StringBuilder("CapBankNetwork ").append(network).append(" sending network package in=").append(this.maxRec).append(" out=").append(this.maxSend);
            for (StackTraceElement elem : new Exception("Stackstrace").getStackTrace()) {
                sb.append(" at ").append(elem);
            }
            Log.warn(sb);
        }
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.maxSend);
        buf.writeInt(this.maxRec);
        buf.writeShort(this.inputMode.ordinal());
        buf.writeShort(this.outputMode.ordinal());
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.maxSend = buf.readInt();
        this.maxRec = buf.readInt();
        this.inputMode = RedstoneControlMode.values()[buf.readShort()];
        this.outputMode = RedstoneControlMode.values()[buf.readShort()];
    }

    @Override
    protected IMessage handleMessage(TileCapBank te, PacketGuiChange message, MessageContext ctx) {
        ICapBankNetwork net = te.getNetwork();
        if (net == null) {
            return null;
        }
        net.setMaxOutput(message.maxSend);
        net.setMaxInput(message.maxRec);
        net.setInputControlMode(message.inputMode);
        net.setOutputControlMode(message.outputMode);
        return null;
    }
}

