/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.integration.top;

import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.BlockEnder;
import com.enderio.core.common.util.FluidUtil;
import com.google.common.base.Function;
import com.mojang.authlib.GameProfile;
import crazypants.enderio.BlockEio;
import crazypants.enderio.EnderIO;
import crazypants.enderio.Log;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.integration.top.TOPData;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.power.PowerDisplayUtil;
import crazypants.util.CapturedMob;
import crazypants.util.NbtValue;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.ILayoutStyle;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeConfigProvider;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class TOPCompatibility
implements Function<ITheOneProbe, Void>,
IProbeInfoProvider,
IProbeConfigProvider {
    public static ITheOneProbe probe;

    @Nullable
    public Void apply(@Nullable ITheOneProbe theOneProbe) {
        if (Config.topEnabled) {
            probe = theOneProbe;
            Log.info("Enabled support for The One Probe");
            probe.registerProvider((IProbeInfoProvider)this);
            probe.registerProbeConfigProvider((IProbeConfigProvider)this);
        } else {
            Log.info("Support for The One Probe is DISABLED by a configuration setting");
        }
        return null;
    }

    public String getID() {
        return EnderIO.DOMAIN + ":default";
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData hitData) {
        TileEntity tileEntity;
        if (mode == ProbeMode.DEBUG) {
            probeInfo.text(blockState.toString());
        }
        if (probeInfo != null && world != null && blockState != null && hitData != null && (blockState.func_177230_c() instanceof BlockEio || blockState.func_177230_c() instanceof IPaintable) && (tileEntity = BlockEnder.getAnyTileEntitySafe((IBlockAccess)world, (BlockPos)hitData.getPos())) != null) {
            EioBox eiobox = new EioBox(probeInfo);
            TOPData data = new TOPData(tileEntity, hitData);
            this.mkOwner(mode, eiobox, data);
            this.mkPaint(mode, eiobox, data);
            this.mkProgressLine(mode, eiobox, data);
            this.mkRfLine(mode, eiobox, data);
            this.mkXPLine(mode, eiobox, data);
            this.mkRedstoneLine(mode, eiobox, data);
            this.mkSideConfigLine(mode, eiobox, data);
            this.mkRangeLine(mode, eiobox, data);
            this.mkTankLines(mode, eiobox, data);
            this.mkItemFillLevelLine(mode, eiobox, data);
            eiobox.finish();
            EioBox mobbox = new EioBox(probeInfo);
            this.mkMobsBox(mode, mobbox, world, data);
            mobbox.finish();
        }
    }

    private void mkMobsBox(ProbeMode mode, EioBox mobbox, World world, TOPData data) {
        if (data.hasMobs) {
            if (mode != ProbeMode.NORMAL || Config.topShowMobsByDefault) {
                mobbox.get().text(TextFormatting.YELLOW + EnderIO.lang.localize("top.action.header", new Object[]{data.mobAction}));
                if (data.mobs.isEmpty()) {
                    mobbox.get().text(TextFormatting.DARK_RED + EnderIO.lang.localize("top.action.none"));
                } else if (data.mobs.size() <= 4) {
                    for (CapturedMob capturedMob : data.mobs) {
                        mobbox.get().horizontal(mobbox.center()).entity(capturedMob.getEntity(world, false)).text(capturedMob.getDisplayName());
                    }
                } else {
                    IProbeInfo mobList = mobbox.get().horizontal(mobbox.center());
                    int count = 0;
                    for (CapturedMob capturedMob : data.mobs) {
                        if (count++ >= 4) {
                            mobList = mobbox.get().horizontal(mobbox.center());
                            count = 0;
                        }
                        mobList.entity(capturedMob.getEntity(world, false));
                    }
                }
            } else {
                mobbox.addMore();
            }
        }
    }

    private void mkRangeLine(ProbeMode mode, EioBox eiobox, TOPData data) {
        if (data.hasRange) {
            if (mode != ProbeMode.NORMAL || Config.topShowRangeByDefault) {
                int sizeX = (int)data.bounds.sizeX();
                int sizeY = (int)data.bounds.sizeY();
                int sizeZ = (int)data.bounds.sizeZ();
                TOPCompatibility.addIcon(eiobox.get().horizontal(eiobox.center()), IconEIO.SHOW_RANGE).text(TextFormatting.YELLOW + EnderIO.lang.localize("top.range.header", new Object[]{TextFormatting.WHITE + EnderIO.lang.localize("top.range", new Object[]{sizeX, sizeY, sizeZ})}));
            } else {
                eiobox.addMore();
            }
        }
    }

    private void mkSideConfigLine(ProbeMode mode, EioBox eiobox, TOPData data) {
        if (data.hasIOMode) {
            if (mode != ProbeMode.NORMAL || Config.topShowSideConfigByDefault) {
                TOPCompatibility.addIcon(eiobox.get().horizontal(eiobox.center()), IconEIO.IO_CONFIG_UP).vertical(eiobox.getProbeinfo().defaultLayoutStyle().spacing(-1)).text(TextFormatting.YELLOW + EnderIO.lang.localize("gui.machine.side", new Object[]{TextFormatting.WHITE + EnderIO.lang.localize("gui.machine.side." + data.sideName)})).text(TextFormatting.YELLOW + EnderIO.lang.localize("gui.machine.ioMode", new Object[]{data.ioMode.colorLocalisedName()}));
            } else {
                eiobox.addMore();
            }
        }
    }

    private void mkRedstoneLine(ProbeMode mode, EioBox eiobox, TOPData data) {
        if (data.hasRedstone) {
            if (mode != ProbeMode.NORMAL || Config.topShowRedstoneByDefault) {
                TOPCompatibility.addIcon(eiobox.get().horizontal(eiobox.center()), data.redstoneIcon).vertical(eiobox.getProbeinfo().defaultLayoutStyle().spacing(-1)).text(data.redstoneTooltip).text(TextFormatting.YELLOW + EnderIO.lang.localize("top.redstone.header", new Object[]{TextFormatting.WHITE + EnderIO.lang.localize("top.redstone." + data.redstoneControlStatus)}));
            } else {
                eiobox.addMore();
            }
        }
    }

    private void mkPaint(ProbeMode mode, EioBox eiobox, TOPData data) {
        if (data.isPainted) {
            IProbeInfo info = eiobox.get().horizontal(eiobox.center()).item(new ItemStack(Items.field_151159_an)).vertical(eiobox.getProbeinfo().defaultLayoutStyle().spacing(-1)).text(TextFormatting.YELLOW + EnderIO.lang.localize("top.paint.header"));
            if (data.paint2 != null) {
                info.horizontal(eiobox.center()).item(data.paint2).text(data.paint2.func_82833_r());
            }
            if (data.paint1 != null) {
                info.horizontal(eiobox.center()).item(data.paint1).text(data.paint1.func_82833_r());
            }
        }
    }

    private void mkOwner(ProbeMode mode, EioBox eiobox, TOPData data) {
        if (mode == ProbeMode.DEBUG && data.owner != null) {
            ItemStack skull = new ItemStack(Items.field_151144_bL, 1, 3);
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74782_a("SkullOwner", (NBTBase)NBTUtil.func_180708_a((NBTTagCompound)new NBTTagCompound(), (GameProfile)data.owner.getAsGameProfile()));
            skull.func_77982_d(nbt);
            eiobox.get().horizontal(eiobox.center()).item(skull).vertical(eiobox.getProbeinfo().defaultLayoutStyle().spacing(-1)).text(TextFormatting.YELLOW + EnderIO.lang.localize("top.owner.header")).text(data.owner.getPlayerName());
        }
    }

    private void mkRfLine(ProbeMode mode, EioBox eiobox, TOPData data) {
        if (data.hasRF) {
            if (mode != ProbeMode.NORMAL || Config.topShowPowerByDefault) {
                IProbeInfo rfLine = eiobox.get().horizontal(eiobox.center()).item(new ItemStack(Items.field_151137_ax));
                if (data.hasRFIO) {
                    rfLine = rfLine.vertical();
                }
                if (data.isPowered) {
                    rfLine.progress(data.rf, data.maxrf, eiobox.getProbeinfo().defaultProgressStyle().suffix(EnderIO.lang.localize("top.suffix.rf")).filledColor(-2739677).alternateFilledColor(-2739677));
                } else {
                    rfLine.text(TextFormatting.DARK_RED + EnderIO.lang.localize("top.machine.outofpower"));
                }
                if (data.hasRFIO) {
                    rfLine = rfLine.horizontal();
                    rfLine.vertical(eiobox.getProbeinfo().defaultLayoutStyle().spacing(-1)).text(TextFormatting.YELLOW + EnderIO.lang.localize("top.rf.header.avg")).text(TextFormatting.YELLOW + EnderIO.lang.localize("top.rf.header.maxin")).text(TextFormatting.YELLOW + EnderIO.lang.localize("top.rf.header.maxout"));
                    String line1 = EnderIO.lang.localize("top.rf.value", new Object[]{(data.avgRF == 0 ? TextFormatting.WHITE : (data.avgRF > 0 ? TextFormatting.GREEN + "+" : TextFormatting.RED)) + PowerDisplayUtil.formatPower(data.avgRF)});
                    String line2 = EnderIO.lang.localize("top.rf.value", new Object[]{TextFormatting.WHITE + PowerDisplayUtil.formatPower(data.maxRFIn)});
                    String line3 = EnderIO.lang.localize("top.rf.value", new Object[]{TextFormatting.WHITE + PowerDisplayUtil.formatPower(data.maxRFOut)});
                    rfLine = rfLine.vertical(eiobox.getProbeinfo().defaultLayoutStyle().spacing(-1)).text(line1).text(line2).text(line3);
                }
            } else {
                eiobox.addMore();
            }
        }
    }

    private void mkXPLine(ProbeMode mode, EioBox eiobox, TOPData data) {
        if (data.hasXP) {
            if (mode != ProbeMode.NORMAL || Config.topShowXPByDefault) {
                int scalemax = data.xpBarScaled > 0 ? data.experienceLevel * 100 / data.xpBarScaled : Integer.MAX_VALUE;
                eiobox.get().horizontal(eiobox.center()).item(new ItemStack(Items.field_151062_by)).progress(data.experienceLevel, scalemax, eiobox.getProbeinfo().defaultProgressStyle().suffix(EnderIO.lang.localize("top.suffix.levels")).filledColor(-16711921).alternateFilledColor(-16733686).borderColor(-16733686));
            } else {
                eiobox.addMore();
            }
        }
    }

    private void mkItemFillLevelLine(ProbeMode mode, EioBox eiobox, TOPData data) {
        if (data.hasItemFillLevel) {
            if (mode != ProbeMode.NORMAL || Config.topShowItemCountDefault) {
                eiobox.get().horizontal(eiobox.center()).item(new ItemStack((Block)Blocks.field_150486_ae)).progress(data.fillCur, data.fillMax, eiobox.getProbeinfo().defaultProgressStyle().suffix(EnderIO.lang.localize("top.suffix.items")).filledColor(-460740).alternateFilledColor(-3167221).borderColor(-3167221));
            } else {
                eiobox.addMore();
            }
        }
    }

    private void mkTankLines(ProbeMode mode, EioBox eiobox, TOPData data) {
        if (data.tankData != null && !data.tankData.isEmpty()) {
            if (mode != ProbeMode.NORMAL || Config.topShowTanksByDefault) {
                for (ITankAccess.ITankData tank : data.tankData) {
                    ItemStack stack = new ItemStack(ModObject.blockTank.getBlock());
                    String content1 = null;
                    String content2 = null;
                    FluidStack fluid = tank.getContent();
                    if (fluid != null) {
                        FluidStack fluid2 = fluid.copy();
                        fluid2.amount = fluid.amount * 16000 / tank.getCapacity();
                        FluidUtil.FluidAndStackResult fillContainer = FluidUtil.tryFillContainer((ItemStack)stack, (FluidStack)fluid2);
                        if (fillContainer.result.itemStack != null) {
                            stack = fillContainer.result.itemStack;
                            NbtValue.FAKE.setInt(stack, 1);
                        }
                        content1 = fluid.getLocalizedName();
                        content2 = EnderIO.lang.localize("top.tank.content", new Object[]{fluid.amount, tank.getCapacity()});
                    } else {
                        content1 = EnderIO.lang.localize("top.tank.content.empty");
                        content2 = EnderIO.lang.localize("top.tank.content", new Object[]{0, tank.getCapacity()});
                    }
                    switch (tank.getTankType()) {
                        case INPUT: {
                            content1 = TextFormatting.YELLOW + EnderIO.lang.localize("top.tank.header.input", new Object[]{TextFormatting.WHITE + content1});
                            break;
                        }
                        case OUTPUT: {
                            content1 = TextFormatting.YELLOW + EnderIO.lang.localize("top.tank.header.output", new Object[]{TextFormatting.WHITE + content1});
                            break;
                        }
                        case STORAGE: {
                            content1 = TextFormatting.YELLOW + EnderIO.lang.localize("top.tank.header.storage", new Object[]{TextFormatting.WHITE + content1});
                        }
                    }
                    eiobox.get().horizontal(eiobox.center()).item(stack).vertical(eiobox.getProbeinfo().defaultLayoutStyle().spacing(-1)).text(content1).text(content2);
                }
            } else {
                eiobox.addMore();
            }
        }
    }

    private void mkProgressLine(ProbeMode mode, EioBox eiobox, TOPData data) {
        if (data.progressResult != TOPData.ProgressResult.NONE) {
            if (mode != ProbeMode.NORMAL || Config.topShowProgressByDefault || data.progressResult == TOPData.ProgressResult.PROGRESS_NO_POWER) {
                IProbeInfo progressLine = eiobox.get().horizontal(eiobox.center()).item(new ItemStack(Items.field_151113_aN));
                switch (data.progressResult) {
                    case PROGRESS: {
                        progressLine.progress((int)(data.progress * 100.0f), 100, eiobox.getProbeinfo().defaultProgressStyle().suffix(EnderIO.lang.localize("top.suffix.percent")).filledColor(-18944).alternateFilledColor(-18944));
                        break;
                    }
                    case PROGRESS_NO_POWER: {
                        progressLine.text(TextFormatting.DARK_RED + EnderIO.lang.localize("top.progress.outofpower"));
                        break;
                    }
                    case PROGRESS_ACTIVE: 
                    case NO_PROGRESS_ACTIVE: {
                        progressLine.text(EnderIO.lang.localize("top.machine.active"));
                        break;
                    }
                    case PROGRESS_IDLE: 
                    case NO_PROGRESS_IDLE: {
                        progressLine.text(EnderIO.lang.localize("top.machine.idle"));
                        break;
                    }
                }
            } else {
                eiobox.addMore();
            }
        }
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        return super.equals(obj);
    }

    public void getProbeConfig(IProbeConfig config, EntityPlayer player, World world, Entity entity, IProbeHitEntityData data) {
    }

    public void getProbeConfig(IProbeConfig config, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        if (config != null && blockState != null && blockState.func_177230_c() instanceof BlockEio) {
            config.setRFMode(0);
        }
    }

    private static IProbeInfo addIcon(IProbeInfo probeInfo, IWidgetIcon icon) {
        return TOPCompatibility.addIcon(probeInfo, icon, 4);
    }

    private static IProbeInfo addIcon(IProbeInfo probeInfo, IWidgetIcon icon, int border) {
        ResourceLocation texture = icon.getMap().getTexture();
        int x = icon.getX();
        int y = icon.getY();
        int width = icon.getWidth();
        int height = icon.getHeight();
        return probeInfo.icon(texture, x, y, width, height, probeInfo.defaultIconStyle().width(width + border).height(height + border));
    }

    private static class EioBox {
        private final IProbeInfo probeinfo;
        private IProbeInfo eiobox;
        private boolean addMoreIndicator = false;

        public EioBox(IProbeInfo probeinfo) {
            this.probeinfo = probeinfo;
        }

        public IProbeInfo getProbeinfo() {
            return this.probeinfo;
        }

        public IProbeInfo get() {
            if (this.eiobox == null) {
                this.eiobox = this.probeinfo.vertical(this.probeinfo.defaultLayoutStyle().borderColor(Integer.valueOf(-65536)));
            }
            return this.eiobox;
        }

        public ILayoutStyle center() {
            return this.probeinfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER);
        }

        public ILayoutStyle right() {
            return this.probeinfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_BOTTOMRIGHT);
        }

        public void addMore() {
            this.addMoreIndicator = true;
        }

        public void finish() {
            if (this.eiobox != null) {
                if (this.addMoreIndicator) {
                    TOPCompatibility.addIcon(TOPCompatibility.addIcon(this.get().horizontal(this.center()), IconEIO.TOP_NOICON, 0), IconEIO.TOP_MORE, 0);
                } else {
                    TOPCompatibility.addIcon(TOPCompatibility.addIcon(this.get().horizontal(this.center()), IconEIO.TOP_NOICON, 0), IconEIO.TOP_NOMORE, 0);
                }
            } else if (this.addMoreIndicator) {
                TOPCompatibility.addIcon(TOPCompatibility.addIcon(this.probeinfo.vertical().horizontal(this.center()), IconEIO.TOP_NOICON_WIDE, 0), IconEIO.TOP_MORE, 0);
            }
        }
    }
}

