/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.config.recipes.xml;

import crazypants.enderio.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.config.recipes.RecipeConfigElement;
import crazypants.enderio.config.recipes.StaxFactory;
import crazypants.enderio.config.recipes.xml.OptionalItem;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public class Grid
implements RecipeConfigElement {
    private String size;
    private List<OptionalItem> items;
    private transient int width;
    private transient int height;
    private transient boolean valid;

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        try {
            if (this.size != null && !this.size.trim().isEmpty() && !"3x3".equals(this.size.trim())) {
                if (this.size.trim().length() != 3 || this.size.charAt(1) != 'x') {
                    throw new InvalidRecipeConfigException("Invalid size attribute '" + this.size.trim());
                }
                String widthString = this.size.substring(0, 1);
                String heightString = this.size.substring(2, 3);
                try {
                    this.width = Integer.parseInt(widthString);
                    this.height = Integer.parseInt(heightString);
                }
                catch (NumberFormatException e) {
                    throw new InvalidRecipeConfigException("Invalid size attribute '" + this.size.trim());
                }
                if (this.width < 1 || this.width > 3 || this.height < 1 || this.height > 3) {
                    throw new InvalidRecipeConfigException("Invalid size attribute '" + this.size.trim());
                }
            } else {
                this.height = 3;
                this.width = 3;
            }
            if (this.items == null) {
                throw new InvalidRecipeConfigException("No items");
            }
            if (this.items.isEmpty() || this.items.size() < this.width * this.height) {
                throw new InvalidRecipeConfigException("Not enough items (required=" + this.width * this.height + ", provided=" + this.items.size() + ")");
            }
            if (this.items.size() > this.width * this.height) {
                throw new InvalidRecipeConfigException("Too many items (required=" + this.width * this.height + ", provided=" + this.items.size() + ")");
            }
            this.valid = true;
            boolean hasAtLeastOneItem = false;
            for (OptionalItem item : this.items) {
                this.valid = this.valid && item.isValid();
                hasAtLeastOneItem = hasAtLeastOneItem || item.getRecipeObject() != null;
            }
            if (!hasAtLeastOneItem) {
                throw new InvalidRecipeConfigException("Rejecting crafting recipe without any items, only empty spaces");
            }
        }
        catch (InvalidRecipeConfigException e) {
            throw new InvalidRecipeConfigException(e, "in <grid>");
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        for (OptionalItem item : this.items) {
            item.enforceValidity();
        }
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    public Object[] getElements() {
        ArrayList<String> rowStrings = new ArrayList<String>();
        ArrayList<Object> elements = new ArrayList<Object>();
        char letter = 'A';
        for (int row = 0; row < this.height; ++row) {
            String rowString = "";
            for (int col = 0; col < this.width; ++col) {
                int idx = row * this.width + col;
                Object recipeObject = this.items.get(idx).getRecipeObject();
                if (recipeObject == null) {
                    rowString = rowString + " ";
                    continue;
                }
                rowString = rowString + letter;
                elements.add(Character.valueOf(letter));
                elements.add(recipeObject);
                letter = (char)(letter + '\u0001');
            }
            rowStrings.add(rowString);
        }
        rowStrings.addAll(elements);
        return rowStrings.toArray();
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("size".equals(name)) {
            this.size = value;
            return true;
        }
        return false;
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        if ("item".equals(name)) {
            if (this.items == null) {
                this.items = new ArrayList<OptionalItem>();
            }
            this.items.add(factory.read(new OptionalItem(), startElement));
            return true;
        }
        return false;
    }
}

